/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.uipreview;

import com.android.SdkConstants;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.AndroidManifestPackageNameUtils;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.util.PathString;
import com.android.projectmodel.ExternalLibrary;
import com.android.tools.idea.LogAnonymizerUtil;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.model.Namespacing;
import com.android.tools.idea.projectsystem.AndroidModuleSystem;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.rendering.RenderSecurityManager;
import com.android.tools.idea.rendering.classloading.ClassConverter;
import com.android.tools.idea.rendering.classloading.ConstantRemapperManager;
import com.android.tools.idea.rendering.classloading.PreviewAnimationClockMethodTransform;
import com.android.tools.idea.rendering.classloading.RenderClassLoader;
import com.android.tools.idea.rendering.classloading.RepackageTransform;
import com.android.tools.idea.rendering.classloading.ThreadLocalRenameTransform;
import com.android.tools.idea.rendering.classloading.UtilKt;
import com.android.tools.idea.rendering.classloading.VersionClassTransform;
import com.android.tools.idea.rendering.classloading.ViewMethodWrapperTransform;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceClassRegistry;
import com.android.tools.idea.res.ResourceIdManager;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.resources.aar.AarResourceRepository;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.android.tools.idea.util.FileExtensions;
import com.android.tools.idea.util.VirtualFileSystemOpener;
import com.android.utils.SdkUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.jetbrains.android.dom.manifest.AndroidManifestUtils;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.StudioEmbeddedRenderTarget;
import org.jetbrains.android.uipreview.ClassLoadingUtilsKt;
import org.jetbrains.android.uipreview.RecyclerViewHelper;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.ClassVisitor;

public final class ModuleClassLoader
extends RenderClassLoader {
    private static final Logger LOG = Logger.getInstance(ModuleClassLoader.class);
    private static final String INTERNAL_PACKAGE = "_layoutlib_._internal_.";
    private static final ImmutableList<String> PACKAGES_TO_RENAME = ImmutableList.of((Object)"kotlin.", (Object)"kotlinx.", (Object)"android.support.constraint.solver.");
    static final Function<ClassVisitor, ClassVisitor> PROJECT_DEFAULT_TRANSFORMS = UtilKt.multiTransformOf(visitor2 -> new ViewMethodWrapperTransform((ClassVisitor)visitor2), visitor2 -> new VersionClassTransform((ClassVisitor)visitor2, ClassConverter.getCurrentClassVersion(), 0), visitor2 -> new ThreadLocalRenameTransform((ClassVisitor)visitor2), visitor2 -> new RepackageTransform((ClassVisitor)visitor2, (Collection<String>)PACKAGES_TO_RENAME, INTERNAL_PACKAGE));
    static final Function<ClassVisitor, ClassVisitor> NON_PROJECT_CLASSES_DEFAULT_TRANSFORMS = UtilKt.multiTransformOf(visitor2 -> new ViewMethodWrapperTransform((ClassVisitor)visitor2), visitor2 -> new VersionClassTransform((ClassVisitor)visitor2, ClassConverter.getCurrentClassVersion(), 0), visitor2 -> new ThreadLocalRenameTransform((ClassVisitor)visitor2), visitor2 -> new PreviewAnimationClockMethodTransform((ClassVisitor)visitor2), visitor2 -> new RepackageTransform((ClassVisitor)visitor2, (Collection<String>)PACKAGES_TO_RENAME, INTERNAL_PACKAGE));
    private final WeakReference<Module> myModuleReference;
    private final long myConstantRemapperModificationCount;
    private Map<String, VirtualFile> myClassFiles;
    private Map<String, ClassModificationTimestamp> myClassFilesLastModified;
    private final List<URL> mAdditionalLibraries;
    private static final Pattern RESOURCE_CLASS_NAME = Pattern.compile(".+\\.R(\\$[^.]+)?$");

    @NotNull
    private static String nonProjectClassNameLookup(@NotNull String name) {
        return StringUtil.trimStart((String)name, (String)INTERNAL_PACKAGE);
    }

    ModuleClassLoader(@Nullable ClassLoader parent, @NotNull Module module2, @NotNull Function<ClassVisitor, ClassVisitor> projectTransformations, @NotNull Function<ClassVisitor, ClassVisitor> nonProjectTransformations) {
        super(parent, projectTransformations, nonProjectTransformations, ModuleClassLoader::nonProjectClassNameLookup);
        this.myModuleReference = new WeakReference<Module>(module2);
        this.mAdditionalLibraries = ModuleClassLoader.getAdditionalLibraries();
        this.myConstantRemapperModificationCount = ConstantRemapperManager.INSTANCE.getConstantRemapper().getModificationCount();
        ModuleClassLoader.registerResources(module2);
    }

    ModuleClassLoader(@Nullable ClassLoader parent, @NotNull Module module2) {
        this(parent, module2, PROJECT_DEFAULT_TRANSFORMS, NON_PROJECT_CLASSES_DEFAULT_TRANSFORMS);
    }

    @NotNull
    private static List<URL> getAdditionalLibraries() {
        String layoutlibDistributionPath = StudioEmbeddedRenderTarget.getEmbeddedLayoutLibPath();
        if (layoutlibDistributionPath == null) {
            return Collections.emptyList();
        }
        String relativeCoroutineLibPath = FileUtil.toSystemIndependentName((String)"data/layoutlib-extensions.jar");
        try {
            return Lists.newArrayList((Object[])new URL[]{SdkUtils.fileToUrl((File)new File(layoutlibDistributionPath, relativeCoroutineLibPath))});
        }
        catch (MalformedURLException e) {
            LOG.error("Failed to find layoutlib-extensions library", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private static boolean isRepackagedClass(@NotNull String classFqn) {
        for (String pkgName : PACKAGES_TO_RENAME) {
            if (!classFqn.startsWith(pkgName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if ("kotlinx.coroutines.android.AndroidDispatcherFactory".equals(name)) {
            throw new IllegalArgumentException("AndroidDispatcherFactory not supported by layoutlib");
        }
        if (ModuleClassLoader.isRepackagedClass(name)) {
            name = INTERNAL_PACKAGE + name;
        }
        return super.loadClass(name);
    }

    @Override
    @NotNull
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("findClass(%s)", name));
        }
        Module module2 = (Module)this.myModuleReference.get();
        try {
            if (!this.myInsideJarClassLoader && module2 != null && ModuleClassLoader.isResourceClassName(name)) {
                AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
                if (facet2 != null) {
                    ResourceRepositoryManager repositoryManager = ResourceRepositoryManager.getInstance(facet2);
                    byte[] data = ResourceClassRegistry.get(module2.getProject()).findClassDefinition(name, repositoryManager);
                    if (data != null) {
                        LOG.debug("  Defining class from AAR registry");
                        return this.loadClass(name, data);
                    }
                } else {
                    LOG.debug("  LocalResourceRepositoryInstance not found");
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("  super.findClass(%s)", LogAnonymizerUtil.anonymizeClassName((String)name)));
            }
            return super.findClass(name);
        }
        catch (ClassNotFoundException e) {
            byte[] clazz = null;
            if ("com.android.layoutlib.bridge.android.support.Adapter".equals(name)) {
                clazz = RecyclerViewHelper.getAdapterClass(DependencyManagementUtil.mapAndroidxName(module2, SdkConstants.CLASS_RECYCLER_VIEW_V7), DependencyManagementUtil.mapAndroidxName(module2, SdkConstants.CLASS_RECYCLER_VIEW_VIEW_HOLDER), DependencyManagementUtil.mapAndroidxName(module2, SdkConstants.CLASS_RECYCLER_VIEW_ADAPTER));
            }
            if ("com.android.layoutlib.bridge.android.support.Adapter$ViewHolder".equals(name)) {
                clazz = RecyclerViewHelper.getViewHolder(DependencyManagementUtil.mapAndroidxName(module2, SdkConstants.CLASS_RECYCLER_VIEW_V7), DependencyManagementUtil.mapAndroidxName(module2, SdkConstants.CLASS_RECYCLER_VIEW_VIEW_HOLDER), DependencyManagementUtil.mapAndroidxName(module2, SdkConstants.CLASS_RECYCLER_VIEW_ADAPTER));
            }
            if (clazz != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("  Defining RecyclerView helper class");
                }
                return this.defineClassAndPackage(name, clazz, 0, clazz.length);
            }
            LOG.debug((Throwable)e);
            throw e;
        }
    }

    @Override
    @NotNull
    protected Class<?> load(@NotNull String name) throws ClassNotFoundException {
        Module module2;
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("load(%s)", LogAnonymizerUtil.anonymizeClassName((String)name)));
        }
        if ((module2 = (Module)this.myModuleReference.get()) == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("  ClassNotFoundException(%s)", name));
            }
            throw new ClassNotFoundException(name);
        }
        Class<?> aClass = this.loadClassFromModuleOrDependency(module2, name);
        if (aClass != null) {
            return aClass;
        }
        return this.loadClassFromNonProjectDependency(name);
    }

    @Nullable
    private Class<?> loadClassFromModuleOrDependency(@NotNull Module module2, @NotNull String name) {
        if (module2.isDisposed()) {
            return null;
        }
        VirtualFile classFile = ProjectSystemUtil.getModuleSystem(module2).findClassFile(name);
        if (classFile == null) {
            return null;
        }
        return this.loadClassFile(name, classFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSourceModified(@NotNull String name, @Nullable Object myCredential) {
        if (ModuleClassLoader.isResourceClassName(name)) {
            return false;
        }
        Module module2 = (Module)this.myModuleReference.get();
        if (module2 == null) {
            return false;
        }
        VirtualFile classFile = this.getClassFile(name);
        if (classFile == null) {
            return false;
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
        if (facet2 == null || AndroidModel.get(facet2) == null) {
            return false;
        }
        boolean token = RenderSecurityManager.enterSafeRegion(myCredential);
        try {
            boolean bl = AndroidModel.get(facet2).isClassFileOutOfDate(module2, name, classFile);
            return bl;
        }
        finally {
            RenderSecurityManager.exitSafeRegion(token);
        }
    }

    private static boolean isResourceClassName(@NotNull String className2) {
        return RESOURCE_CLASS_NAME.matcher(className2).matches();
    }

    @Override
    @Nullable
    protected Class<?> loadClassFile(@NotNull String name, @NotNull VirtualFile classFile) {
        if (this.myClassFiles == null) {
            this.myClassFiles = new ConcurrentHashMap<String, VirtualFile>();
            this.myClassFilesLastModified = new ConcurrentHashMap<String, ClassModificationTimestamp>();
        }
        this.myClassFiles.put(name, classFile);
        this.myClassFilesLastModified.put(name, new ClassModificationTimestamp(classFile.getTimeStamp(), classFile.getLength()));
        return super.loadClassFile(name, classFile);
    }

    private static void registerResources(@NotNull Module module2) {
        AndroidFacet androidFacet = AndroidFacet.getInstance((Module)module2);
        if (androidFacet == null) {
            return;
        }
        ResourceRepositoryManager repositoryManager = ResourceRepositoryManager.getInstance(androidFacet);
        ResourceIdManager idManager = ResourceIdManager.get(module2);
        ResourceClassRegistry classRegistry = ResourceClassRegistry.get(module2.getProject());
        if (!idManager.finalIdsUsed()) {
            classRegistry.addLibrary((ResourceRepository)repositoryManager.getAppResources(), idManager, (String)ReadAction.compute(() -> AndroidManifestUtils.getPackageName(androidFacet)), repositoryManager.getNamespace());
        }
        for (AndroidFacet dependency : AndroidUtils.getAllAndroidDependencies(module2, false)) {
            classRegistry.addLibrary((ResourceRepository)repositoryManager.getAppResources(), idManager, (String)ReadAction.compute(() -> AndroidManifestUtils.getPackageName(dependency)), repositoryManager.getNamespace());
        }
        AndroidModuleSystem moduleSystem = ProjectSystemUtil.getModuleSystem(module2);
        for (ExternalLibrary library : moduleSystem.getResolvedLibraryDependencies()) {
            if (!library.getHasResources()) continue;
            ModuleClassLoader.registerLibraryResources(library, repositoryManager, classRegistry, idManager);
        }
    }

    private static void registerLibraryResources(@NotNull ExternalLibrary library, @NotNull ResourceRepositoryManager repositoryManager, @NotNull ResourceClassRegistry classRegistry, @NotNull ResourceIdManager idManager) {
        ResourceNamespace resourcesNamespace;
        Object rClassContents;
        String packageName;
        LocalResourceRepository appResources = repositoryManager.getAppResources();
        if (repositoryManager.getNamespacing() == Namespacing.DISABLED) {
            packageName = ModuleClassLoader.getPackageName(library);
            if (packageName == null) {
                return;
            }
            rClassContents = appResources;
            resourcesNamespace = ResourceNamespace.RES_AUTO;
        } else {
            AarResourceRepository aarResources = repositoryManager.findLibraryResources(library);
            if (aarResources == null) {
                return;
            }
            rClassContents = aarResources;
            resourcesNamespace = aarResources.getNamespace();
            packageName = aarResources.getPackageName();
        }
        classRegistry.addLibrary((ResourceRepository)rClassContents, idManager, packageName, resourcesNamespace);
    }

    @Nullable
    private static String getPackageName(@NotNull ExternalLibrary library) {
        block6: {
            if (library.getPackageName() != null) {
                return library.getPackageName();
            }
            PathString manifestFile = library.getManifestFile();
            if (manifestFile != null) {
                try {
                    return AndroidManifestPackageNameUtils.getPackageNameFromManifestFile((PathString)manifestFile);
                }
                catch (IOException ignore) {
                    if (!VirtualFileSystemOpener.INSTANCE.recognizes(manifestFile)) break block6;
                    FileExtensions.toVirtualFile(manifestFile, true);
                    try {
                        return AndroidManifestPackageNameUtils.getPackageNameFromManifestFile((PathString)manifestFile);
                    }
                    catch (IOException ignore2) {
                        return null;
                    }
                }
            }
        }
        return null;
    }

    @Override
    @NotNull
    protected List<URL> getExternalJars() {
        return Lists.newArrayList((Iterable)Iterables.concat(this.mAdditionalLibraries, ClassLoadingUtilsKt.getLibraryDependenciesJars((Module)this.myModuleReference.get())));
    }

    @Nullable
    private VirtualFile getClassFile(@NotNull String className2) {
        if (this.myClassFiles == null) {
            return null;
        }
        VirtualFile file2 = this.myClassFiles.get(className2);
        if (file2 == null) {
            return null;
        }
        return file2.isValid() ? file2 : null;
    }

    boolean isUpToDate() {
        if (this.myClassFiles != null) {
            for (Map.Entry<String, VirtualFile> entry : this.myClassFiles.entrySet()) {
                String className2 = entry.getKey();
                VirtualFile classFile = entry.getValue();
                if (!classFile.isValid()) {
                    return false;
                }
                ClassModificationTimestamp lastModifiedStamp = this.myClassFilesLastModified.get(className2);
                if (lastModifiedStamp == null) continue;
                long loadedModifiedTime = lastModifiedStamp.timestamp;
                long loadedModifiedLength = lastModifiedStamp.length;
                long classFileModifiedTime = classFile.getTimeStamp();
                long classFileModifiedLength = classFile.getLength();
                if ((classFileModifiedTime <= 0L || loadedModifiedTime <= 0L || loadedModifiedTime >= classFileModifiedTime) && loadedModifiedLength == classFileModifiedLength) continue;
                return false;
            }
        }
        return this.areDependenciesUpToDate();
    }

    public boolean isClassLoaded(@NotNull String className2) {
        return this.findLoadedClass(className2) != null;
    }

    private static class ClassModificationTimestamp {
        public final long timestamp;
        public final long length;

        ClassModificationTimestamp(long timestamp, long length) {
            this.timestamp = timestamp;
            this.length = length;
        }
    }
}

