/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.spellchecker;

import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.lint.detector.api.Lint;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.templateLanguages.TemplateLanguage;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.spellchecker.inspections.BaseSplitter;
import com.intellij.spellchecker.inspections.PlainTextSplitter;
import com.intellij.spellchecker.inspections.Splitter;
import com.intellij.spellchecker.inspections.TextSplitter;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import com.intellij.spellchecker.tokenizer.TokenizerBase;
import com.intellij.spellchecker.xml.XmlSpellcheckingStrategy;
import com.intellij.util.Consumer;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericAttributeValue;
import org.jetbrains.android.dom.AndroidDomElement;
import org.jetbrains.android.dom.converters.AndroidPackageConverter;
import org.jetbrains.android.dom.converters.AndroidPermissionConverter;
import org.jetbrains.android.dom.converters.AndroidResourceReferenceBase;
import org.jetbrains.android.dom.converters.ConstantFieldConverter;
import org.jetbrains.android.dom.converters.ResourceReferenceConverter;
import org.jetbrains.android.dom.resources.ResourceNameConverter;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidXmlSpellcheckingStrategy
extends XmlSpellcheckingStrategy {
    private final MyResourceReferenceTokenizer myResourceReferenceTokenizer = new MyResourceReferenceTokenizer();
    private final Tokenizer<XmlAttributeValue> myAttributeValueRenamingTokenizer = new Tokenizer<XmlAttributeValue>(){

        public void tokenize(@NotNull XmlAttributeValue element2, TokenConsumer consumer) {
            consumer.consumeToken((PsiElement)element2, true, (Splitter)TextSplitter.getInstance());
        }
    };
    private static final AaptXmlTextSplitter AAPT_SPLITTER = new AaptXmlTextSplitter();
    private static final Tokenizer<PsiElement> AAPT_TOKENIZER = new TokenizerBase((Splitter)AAPT_SPLITTER);

    public boolean isMyContext(@NotNull PsiElement element2) {
        PsiFile file2 = element2.getContainingFile();
        if (!(file2 instanceof XmlFile)) {
            return false;
        }
        return AndroidFacet.getInstance((PsiElement)file2) != null || AndroidXmlSpellcheckingStrategy.isLintConfig((XmlFile)file2);
    }

    private static boolean isLintConfig(@NotNull XmlFile file2) {
        String tagName;
        if (file2.getName().equals("lint.xml")) {
            return true;
        }
        XmlTag tag = file2.getRootTag();
        return tag != null && ("lint".equals(tagName = tag.getName()) || "issues".equals(tagName));
    }

    @NotNull
    public Tokenizer getTokenizer(PsiElement element2) {
        if (AndroidXmlSpellcheckingStrategy.isAttributeValueContext(element2)) {
            return this.getAttributeValueTokenizer(element2);
        }
        if (AndroidXmlSpellcheckingStrategy.inEnglish(element2)) {
            if (element2 instanceof XmlToken && ((XmlToken)element2).getTokenType() == XmlTokenType.XML_DATA_CHARACTERS) {
                PsiFile file2 = element2.getContainingFile();
                if (file2 == null || file2.getLanguage() instanceof TemplateLanguage) {
                    return EMPTY_TOKENIZER;
                }
                PsiElement injection = InjectedLanguageManager.getInstance((Project)element2.getProject()).findInjectedElementAt(element2.getContainingFile(), element2.getTextOffset());
                if (injection != null) {
                    return EMPTY_TOKENIZER;
                }
                return AAPT_TOKENIZER;
            }
            return super.getTokenizer(element2);
        }
        return EMPTY_TOKENIZER;
    }

    @NotNull
    public Tokenizer getAttributeValueTokenizer(PsiElement element2) {
        GenericAttributeValue domValue;
        String value2;
        assert (element2 instanceof XmlAttributeValue);
        if (IdeResourcesUtil.isIdDeclaration((XmlAttributeValue)element2)) {
            return this.myAttributeValueRenamingTokenizer;
        }
        PsiElement parent = element2.getParent();
        if (parent instanceof XmlAttribute && (value2 = ((XmlAttribute)parent).getValue()) != null && (domValue = DomManager.getDomManager((Project)parent.getProject()).getDomElement((XmlAttribute)parent)) != null) {
            Converter converter = domValue.getConverter();
            if (converter instanceof ResourceReferenceConverter) {
                return this.myResourceReferenceTokenizer;
            }
            if (converter instanceof ConstantFieldConverter || converter instanceof AndroidPermissionConverter) {
                return EMPTY_TOKENIZER;
            }
            if (converter instanceof ResourceNameConverter || converter instanceof AndroidPackageConverter) {
                return this.myAttributeValueRenamingTokenizer;
            }
        }
        return super.getTokenizer(element2);
    }

    private static boolean isAttributeValueContext(@NotNull PsiElement element2) {
        if (!(element2 instanceof XmlAttributeValue)) {
            return false;
        }
        PsiElement parent = element2.getParent();
        PsiElement psiElement = parent = parent != null ? parent.getParent() : null;
        if (!(parent instanceof XmlTag)) {
            return false;
        }
        DomElement domElement = DomManager.getDomManager((Project)element2.getProject()).getDomElement((XmlTag)parent);
        if (domElement instanceof AndroidDomElement) {
            return AndroidXmlSpellcheckingStrategy.inEnglish(element2);
        }
        return false;
    }

    private static boolean inEnglish(PsiElement element2) {
        XmlFile file2 = (XmlFile)PsiTreeUtil.getParentOfType((PsiElement)element2, XmlFile.class);
        if (file2 != null) {
            PsiDirectory dir;
            String name = file2.getName();
            if (name.equals("AndroidManifest.xml")) {
                return true;
            }
            if (name.equals("generated.xml")) {
                AndroidModel androidModel;
                AndroidFacet facet2 = AndroidFacet.getInstance((PsiElement)file2);
                VirtualFile virtualFile = file2.getVirtualFile();
                if (facet2 != null && AndroidModel.isRequired(facet2) && virtualFile != null && (androidModel = AndroidModel.get(facet2)) != null && androidModel.isGenerated(virtualFile)) {
                    return false;
                }
            } else if (AndroidXmlSpellcheckingStrategy.isLintConfig(file2)) {
                return false;
            }
            if ((dir = file2.getParent()) != null) {
                String locale = Lint.getLocaleAndRegion((String)dir.getName());
                if (locale == null) {
                    locale = AndroidXmlSpellcheckingStrategy.getToolsLocale(file2);
                }
                return locale == null || locale.startsWith("en") || locale.equals("b+en") || locale.startsWith("b+en+");
            }
        }
        return false;
    }

    @Nullable
    private static String getToolsLocale(XmlFile file2) {
        XmlTag rootTag = file2.getRootTag();
        if (rootTag != null) {
            return rootTag.getAttributeValue("locale", "http://schemas.android.com/tools");
        }
        return null;
    }

    public static class AaptXmlTextSplitter
    extends BaseSplitter {
        public void split(@Nullable String text2, @NotNull TextRange range, Consumer<TextRange> consumer) {
            if (text2 == null || StringUtil.isEmpty((String)text2)) {
                return;
            }
            PlainTextSplitter ps = PlainTextSplitter.getInstance();
            if (text2.indexOf(92) == -1) {
                ps.split(text2, range, consumer);
            } else {
                int end;
                int length = range.getEndOffset();
                int start2 = range.getStartOffset();
                do {
                    if ((end = text2.indexOf(92, start2)) == -1) {
                        end = length;
                    }
                    ps.split(text2, new TextRange(start2, end), consumer);
                } while ((start2 = end + 2) < length);
            }
        }
    }

    private static class MyResourceReferenceTokenizer
    extends SpellcheckingStrategy.XmlAttributeValueTokenizer {
        private MyResourceReferenceTokenizer() {
        }

        @Nullable
        private static AndroidResourceReferenceBase findResourceReference(PsiElement element2) {
            for (PsiReference reference2 : element2.getReferences()) {
                if (!(reference2 instanceof AndroidResourceReferenceBase)) continue;
                return (AndroidResourceReferenceBase)reference2;
            }
            return null;
        }

        public void tokenize(@NotNull XmlAttributeValue element2, TokenConsumer consumer) {
            AndroidResourceReferenceBase reference2 = MyResourceReferenceTokenizer.findResourceReference((PsiElement)element2);
            if (reference2 != null) {
                if (reference2.getResourceValue().getPackage() == null) {
                    consumer.consumeToken((PsiElement)element2, true, (Splitter)TextSplitter.getInstance());
                }
                return;
            }
            super.tokenize(element2, consumer);
        }
    }
}

