/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.android.resources.ResourceType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.Map;
import org.jetbrains.android.dom.converters.AndroidResourceReferenceBase;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.android.refactoring.AndroidAttributeInfo;
import org.jetbrains.android.refactoring.StyleRefData;
import org.jetbrains.android.refactoring.StyleUsageData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ViewStyleUsageData
implements StyleUsageData {
    private final XmlTag myTag;
    private final GenericAttributeValue<ResourceValue> myStyleAttribute;
    private final AndroidResourceReferenceBase myReference;

    ViewStyleUsageData(@NotNull XmlTag tag, @NotNull GenericAttributeValue<ResourceValue> styleAttribute, @NotNull AndroidResourceReferenceBase reference2) {
        this.myTag = tag;
        this.myStyleAttribute = styleAttribute;
        this.myReference = reference2;
    }

    @Override
    @Nullable
    public PsiFile getFile() {
        return this.myTag.getContainingFile();
    }

    @Override
    public void inline(@NotNull Map<AndroidAttributeInfo, String> attributeValues, @Nullable StyleRefData parentStyleRef) {
        for (Map.Entry<AndroidAttributeInfo, String> entry : attributeValues.entrySet()) {
            String namespace;
            AndroidAttributeInfo info2 = entry.getKey();
            String localName = info2.getName();
            if (this.myTag.getAttribute(localName, namespace = info2.getNamespace()) != null) continue;
            this.myTag.setAttribute(localName, namespace, entry.getValue());
        }
        this.myStyleAttribute.setValue(parentStyleRef != null ? ResourceValue.referenceTo('@', parentStyleRef.getStylePackage(), ResourceType.STYLE.getName(), parentStyleRef.getStyleName()) : null);
    }

    @Override
    @NotNull
    public AndroidResourceReferenceBase getReference() {
        return this.myReference;
    }
}

