/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.LintIdeQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import org.jetbrains.android.refactoring.UnusedResourcesHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnusedResourcesQuickFix
implements LintIdeQuickFix {
    private final String myResource;

    public UnusedResourcesQuickFix(@Nullable String resource) {
        this.myResource = resource;
    }

    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        Project project = startElement.getProject();
        UnusedResourcesHandler.invoke(project, null, this.myResource, true, true);
    }

    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        return true;
    }

    @NotNull
    public String getName() {
        return this.myResource != null ? "Remove Declarations for " + this.myResource : "Remove All Unused Resources";
    }

    public boolean startInWriteAction() {
        return false;
    }
}

