/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.android.AndroidModel;
import com.android.tools.idea.gradle.dsl.api.android.FlavorTypeModel;
import com.android.tools.idea.gradle.dsl.api.ext.ResolvedPropertyModel;
import com.android.tools.idea.lint.AndroidLintIdeIssueRegistry;
import com.android.tools.idea.lint.common.LintBatchResult;
import com.android.tools.idea.lint.common.LintIdeClient;
import com.android.tools.idea.lint.common.LintIdeRequest;
import com.android.tools.idea.lint.common.LintIdeSupport;
import com.android.tools.idea.lint.common.LintProblemData;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.lint.checks.UnusedResourceDetector;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.LintRequest;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Scope;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.analysis.AnalysisScope;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.IncorrectOperationException;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.android.refactoring.UnusedResourcesUsageViewDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;

public class UnusedResourcesProcessor
extends BaseRefactoringProcessor {
    private final String myFilter;
    private final Module[] myModules;
    private PsiElement[] myElements = PsiElement.EMPTY_ARRAY;
    private boolean myIncludeIds;
    private String myCachedCommandName = null;
    private Map<PsiElement, GradleBuildModel> myBuildModelMap;

    public UnusedResourcesProcessor(@NotNull Project project, @NotNull Module[] modules, @Nullable String filter2) {
        super(project, null);
        this.myModules = modules;
        this.myFilter = filter2;
        this.myBuildModelMap = new HashMap<PsiElement, GradleBuildModel>();
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        return new UnusedResourcesUsageViewDescriptor(this.myElements);
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        Map<Issue, Map<File, List<LintProblemData>>> map2 = this.computeUnusedMap();
        List<PsiElement> elements = this.computeUnusedDeclarationElements(map2);
        this.myElements = elements.toArray(PsiElement.EMPTY_ARRAY);
        UsageInfo[] result2 = new UsageInfo[this.myElements.length];
        int n = this.myElements.length;
        for (int i2 = 0; i2 < n; ++i2) {
            result2[i2] = new UsageInfo(this.myElements[i2]);
        }
        return UsageViewUtil.removeDuplicatedUsages((UsageInfo[])result2);
    }

    @NotNull
    private List<PsiElement> computeUnusedDeclarationElements(Map<Issue, Map<File, List<LintProblemData>>> map2) {
        ArrayList elements = Lists.newArrayList();
        for (Issue issue2 : Lists.newArrayList(map2.keySet())) {
            if (issue2 == UnusedResourceDetector.ISSUE || issue2 == UnusedResourceDetector.ISSUE_IDS) continue;
            map2.remove(issue2);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiManager manager = PsiManager.getInstance((Project)this.myProject);
        for (Issue issue3 : new Issue[]{UnusedResourceDetector.ISSUE, UnusedResourceDetector.ISSUE_IDS}) {
            Map<File, List<LintProblemData>> fileListMap = map2.get(issue3);
            if (fileListMap == null || fileListMap.isEmpty()) continue;
            HashMap files2 = Maps.newHashMap();
            for (File file2 : fileListMap.keySet()) {
                PsiFile psiFile2;
                VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByIoFile(file2);
                if (virtualFile == null || virtualFile.isDirectory() || (psiFile2 = manager.findFile(virtualFile)) == null) continue;
                files2.put(file2, psiFile2);
            }
            if (files2.isEmpty()) continue;
            for (File file2 : files2.keySet()) {
                PsiFile psiFile3 = (PsiFile)files2.get(file2);
                if (psiFile3 == null || !CommonRefactoringUtil.checkReadOnlyStatus((Project)this.myProject, (PsiElement)psiFile3)) continue;
                List<LintProblemData> problems = fileListMap.get(file2);
                if (psiFile3.getFileType().isBinary()) {
                    if (!this.matchesFilter(fileListMap, file2)) continue;
                    elements.add(psiFile3);
                    continue;
                }
                ResourceFolderType folderType = IdeResourcesUtil.getFolderType(psiFile3);
                if (folderType == null) {
                    if (!(psiFile3 instanceof GroovyFile) && !(psiFile3 instanceof KtFile) || !psiFile3.getName().endsWith("gradle") && !psiFile3.getName().endsWith("gradle.kts")) continue;
                    GradleBuildModel gradleBuildModel = GradleBuildModel.parseBuildFile(psiFile3.getVirtualFile(), this.myProject);
                    AndroidModel androidElement = gradleBuildModel.android();
                    List<FlavorTypeModel.ResValue> resValues = androidElement.defaultConfig().resValues();
                    resValues.addAll(androidElement.productFlavors().stream().flatMap(e -> e.resValues().stream()).collect(Collectors.toList()));
                    resValues.addAll(androidElement.buildTypes().stream().flatMap(e -> e.resValues().stream()).collect(Collectors.toList()));
                    for (FlavorTypeModel.ResValue resValue : resValues) {
                        ResolvedPropertyModel typeString = resValue.type();
                        ResolvedPropertyModel nameString = resValue.name();
                        List<LintProblemData> lintProblems = fileListMap.get(VfsUtilCore.virtualToIoFile((VirtualFile)psiFile3.getVirtualFile()));
                        if (problems == null) continue;
                        for (LintProblemData problem : lintProblems) {
                            String unusedResource = (String)LintFix.getData((LintFix)problem.getQuickfixData(), String.class);
                            if (unusedResource == null || !unusedResource.equals("R." + typeString + '.' + nameString) || resValue.getModel().getPsiElement() == null) continue;
                            elements.add(resValue.getModel().getPsiElement());
                            this.myBuildModelMap.put(resValue.getModel().getPsiElement(), gradleBuildModel);
                            resValue.remove();
                        }
                    }
                    continue;
                }
                if (folderType != ResourceFolderType.VALUES) {
                    if (issue3 == UnusedResourceDetector.ISSUE_IDS) {
                        Map<File, List<LintProblemData>> m = map2.get(UnusedResourceDetector.ISSUE);
                        if (m != null && m.containsKey(file2)) continue;
                        this.addElementsInFile(elements, psiFile3, problems);
                        continue;
                    }
                    if (!this.matchesFilter(fileListMap, file2)) continue;
                    elements.add(psiFile3);
                    continue;
                }
                this.addElementsInFile(elements, psiFile3, problems);
            }
        }
        return elements;
    }

    private void addElementsInFile(List<PsiElement> elements, PsiFile psiFile2, List<LintProblemData> problems) {
        if (psiFile2 instanceof XmlFile) {
            ArrayList starts = Lists.newArrayListWithCapacity((int)problems.size());
            for (LintProblemData problem : problems) {
                if (!this.matchesFilter(problem)) continue;
                starts.add(problem.getTextRange().getStartOffset());
            }
            starts.sort(Collections.reverseOrder());
            for (Integer offset2 : starts) {
                XmlAttribute attribute;
                if (!psiFile2.isValid()) continue;
                XmlAttribute remove = attribute = (XmlAttribute)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)psiFile2, (int)offset2, XmlAttribute.class, (boolean)false);
                if (attribute == null) {
                    remove = PsiTreeUtil.findElementOfClassAtOffset((PsiFile)psiFile2, (int)offset2, XmlTag.class, (boolean)false);
                } else if (!"id".equals(attribute.getLocalName())) {
                    remove = PsiTreeUtil.getParentOfType((PsiElement)attribute, XmlTag.class);
                }
                if (remove == null) continue;
                elements.add((PsiElement)remove);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Map<Issue, Map<File, List<LintProblemData>>> computeUnusedMap() {
        HashMap map2 = Maps.newHashMap();
        ImmutableSet issues = this.myIncludeIds ? ImmutableSet.of((Object)UnusedResourceDetector.ISSUE, (Object)UnusedResourceDetector.ISSUE_IDS) : ImmutableSet.of((Object)UnusedResourceDetector.ISSUE);
        AnalysisScope scope2 = new AnalysisScope(this.myProject);
        boolean unusedWasEnabled = UnusedResourceDetector.ISSUE.isEnabledByDefault();
        boolean unusedIdsWasEnabled = UnusedResourceDetector.ISSUE_IDS.isEnabledByDefault();
        UnusedResourceDetector.ISSUE.setEnabledByDefault(true);
        UnusedResourceDetector.ISSUE_IDS.setEnabledByDefault(this.myIncludeIds);
        try {
            LintBatchResult lintResult = new LintBatchResult(this.myProject, (Map)map2, scope2, (Set)issues);
            LintIdeClient client = LintIdeSupport.get().createBatchClient(lintResult);
            LintIdeRequest request = new LintIdeRequest(client, this.myProject, null, Arrays.asList(this.myModules), false);
            request.setScope(Scope.ALL);
            LintDriver lint = client.createDriver((LintRequest)request, (IssueRegistry)new AndroidLintIdeIssueRegistry());
            lint.analyze();
        }
        finally {
            UnusedResourceDetector.ISSUE.setEnabledByDefault(unusedWasEnabled);
            UnusedResourceDetector.ISSUE_IDS.setEnabledByDefault(unusedIdsWasEnabled);
        }
        return map2;
    }

    private boolean matchesFilter(@NotNull Map<File, List<LintProblemData>> fileListMap, @NotNull File file2) {
        if (this.myFilter != null) {
            List<LintProblemData> problems = fileListMap.get(file2);
            for (LintProblemData problem : problems) {
                String unusedResource = (String)LintFix.getData((LintFix)problem.getQuickfixData(), String.class);
                if (!this.myFilter.equals(unusedResource)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean matchesFilter(@NotNull LintProblemData problem) {
        return this.myFilter == null || this.myFilter.equals(LintFix.getData((LintFix)problem.getQuickfixData(), String.class));
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        return true;
    }

    public PsiElement[] getElements() {
        return this.myElements;
    }

    protected void refreshElements(@NotNull PsiElement[] elements) {
        System.arraycopy(elements, 0, this.myElements, 0, elements.length);
    }

    @Nullable
    protected RefactoringEventData getBeforeData() {
        RefactoringEventData beforeData = new RefactoringEventData();
        beforeData.addElements(this.myElements);
        return beforeData;
    }

    @Nullable
    protected String getRefactoringId() {
        return "refactoring.unused.resources";
    }

    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        try {
            for (UsageInfo usage : usages) {
                PsiElement element2 = usage.getElement();
                if (element2 == null || !element2.isValid()) continue;
                if (this.myBuildModelMap.get(element2) != null && this.myBuildModelMap.get(element2).isModified()) {
                    WriteCommandAction.runWriteCommandAction((Project)this.myProject, this.myBuildModelMap.get(element2)::applyChanges);
                    continue;
                }
                element2.delete();
            }
        }
        catch (IncorrectOperationException e) {
            RefactoringUIUtil.processIncorrectOperation((Project)this.myProject, (IncorrectOperationException)e);
        }
    }

    private String calcCommandName() {
        return "Deleting " + RefactoringUIUtil.calculatePsiElementDescriptionList((PsiElement[])this.myElements);
    }

    @NotNull
    protected String getCommandName() {
        if (this.myCachedCommandName == null) {
            this.myCachedCommandName = this.calcCommandName();
        }
        return this.myCachedCommandName;
    }

    protected boolean skipNonCodeUsages() {
        return true;
    }

    public void setIncludeIds(boolean includeIds) {
        this.myIncludeIds = includeIds;
    }

    protected boolean isToBeChanged(@NotNull UsageInfo usageInfo) {
        PsiElement element2;
        if (ApplicationManager.getApplication().isUnitTestMode() && (element2 = usageInfo.getElement()) != null && element2.getText().contains("AUTO-EXCLUDE")) {
            return false;
        }
        return super.isToBeChanged(usageInfo);
    }
}

