/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.dom.manifest.Activity;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.refactoring.MigrateToAppCompatUsageInfo;
import org.jetbrains.android.refactoring.MigrateToAppCompatUtil;
import org.jetbrains.annotations.NotNull;

class AppCompatStyleMigration {
    private final Set<String> myAppCompatAttributes;
    private final Set<String> myAppCompatStyles;

    AppCompatStyleMigration(Set<String> appCompatAttributes, Set<String> appCompatStyles) {
        this.myAppCompatAttributes = ImmutableSet.copyOf(appCompatAttributes);
        this.myAppCompatStyles = ImmutableSet.copyOf(appCompatStyles);
    }

    private boolean isAppCompatAttribute(String attribute) {
        return this.myAppCompatAttributes.contains(attribute);
    }

    private boolean isAppCompatStyle(String styleName) {
        return this.myAppCompatStyles.contains(styleName);
    }

    @NotNull
    public List<MigrateToAppCompatUsageInfo.ChangeStyleUsageInfo> findStyleElementsToBeModified(@NotNull Project project, @NotNull AndroidFacet facet2) {
        ConfigurationManager configManager = ConfigurationManager.getOrCreateInstance(facet2.getModule());
        if (configManager.getTarget() == null) {
            return Collections.emptyList();
        }
        ResourceRepository frameworkResources = configManager.getResolverCache().getFrameworkResources(new FolderConfiguration(), configManager.getTarget());
        ArrayList<MigrateToAppCompatUsageInfo.ChangeStyleUsageInfo> result2 = new ArrayList<MigrateToAppCompatUsageInfo.ChangeStyleUsageInfo>();
        if (frameworkResources == null) {
            return Collections.emptyList();
        }
        this.addStyleUsagesFromManifest(facet2, frameworkResources, result2);
        LocalResourceRepository projectResources = ResourceRepositoryManager.getProjectResources(facet2);
        this.addUsagesFromStyles(project, frameworkResources, result2, projectResources);
        this.addUsagesFromLayout(project, result2, projectResources);
        return result2;
    }

    private void addUsagesFromLayout(Project project, final List<MigrateToAppCompatUsageInfo.ChangeStyleUsageInfo> result2, LocalResourceRepository projectResources) {
        Set<XmlFile> psiLayoutFiles = MigrateToAppCompatUtil.getPsiFilesOfType(project, (ResourceRepository)projectResources, ResourceType.LAYOUT);
        for (XmlFile layoutFile : psiLayoutFiles) {
            layoutFile.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

                public void visitXmlTag(XmlTag tag) {
                    super.visitXmlTag(tag);
                    XmlAttribute attr = tag.getAttribute("style");
                    AppCompatStyleMigration.this.themeOrStyle2UsageInfo(attr, result2);
                    for (XmlAttribute attribute : tag.getAttributes()) {
                        String attributeValue;
                        if (!"http://schemas.android.com/apk/res/android".equals(attribute.getNamespace()) || (attributeValue = attribute.getValue()) == null) continue;
                        if (attributeValue.startsWith("?") && attributeValue.contains("android:")) {
                            ResourceUrl url = ResourceUrl.parse((String)attributeValue);
                            if (url == null || !url.isFramework() || !AppCompatStyleMigration.this.isAppCompatAttribute(url.name)) continue;
                            ResourceUrl toChange = url.isTheme() ? ResourceUrl.createThemeReference(null, (ResourceType)ResourceType.ATTR, (String)url.name) : ResourceUrl.create(null, (ResourceType)ResourceType.ATTR, (String)url.name);
                            String newResource = toChange.toString();
                            result2.add(new MigrateToAppCompatUsageInfo.ChangeStyleUsageInfo((PsiElement)attribute.getValueElement(), attributeValue, newResource));
                            continue;
                        }
                        if (!attributeValue.startsWith("@") || !attributeValue.contains("android:")) continue;
                        AppCompatStyleMigration.this.themeOrStyle2UsageInfo(attribute, result2);
                    }
                }
            });
        }
    }

    private void themeOrStyle2UsageInfo(XmlAttribute styleAttr, List<MigrateToAppCompatUsageInfo.ChangeStyleUsageInfo> result2) {
        if (styleAttr != null && styleAttr.getValue() != null) {
            String attrValue = styleAttr.getValue();
            ResourceUrl attrRes = ResourceUrl.parse((String)attrValue);
            if (attrRes == null) {
                return;
            }
            if (attrRes.isFramework()) {
                Pair<Boolean, String> converted = AppCompatStyleMigration.replaceStyleNameIfContains(attrRes.name, ".Material");
                if (!((Boolean)converted.first).booleanValue()) {
                    return;
                }
                if (this.isAppCompatStyle((String)converted.second)) {
                    ResourceUrl toChange = ResourceUrl.create(null, (ResourceType)ResourceType.STYLE, (String)((String)converted.second));
                    result2.add(new MigrateToAppCompatUsageInfo.ChangeStyleUsageInfo((PsiElement)styleAttr, styleAttr.getValue(), toChange.toString()));
                }
            }
        }
    }

    private void addUsagesFromStyles(@NotNull Project project, ResourceRepository frameworkResources, List<MigrateToAppCompatUsageInfo.ChangeStyleUsageInfo> result2, LocalResourceRepository projectResources) {
        Set<XmlFile> xmlFiles = MigrateToAppCompatUtil.getPsiFilesOfType(project, (ResourceRepository)projectResources, ResourceType.STYLE);
        for (XmlFile xmlFile : xmlFiles) {
            XmlTag[] styleTags;
            XmlTag rootTag = xmlFile.getRootTag();
            if (rootTag == null) continue;
            for (XmlTag styleTag : styleTags = rootTag.findSubTags("style")) {
                XmlTag[] items2;
                XmlAttribute parent = styleTag.getAttribute("parent");
                if (parent != null && parent.getValue() != null && parent.getValueElement() != null) {
                    String changeToStyle;
                    String parentValue = parent.getValue();
                    String parentStyle = StringUtil.trimStart((String)parentValue, (String)"android:");
                    if (parentValue.startsWith("android:") && frameworkResources.hasResources(ResourceNamespace.ANDROID, ResourceType.STYLE, parentStyle) && this.isAppCompatStyle(changeToStyle = AppCompatStyleMigration.toAppCompatThemeOrStyleName(parentStyle))) {
                        result2.add(new MigrateToAppCompatUsageInfo.ChangeThemeUsageInfo(parent.getValueElement(), parent.getValue(), changeToStyle));
                    }
                }
                for (XmlTag xmlItemTag : items2 = styleTag.findSubTags("item")) {
                    ResourceUrl attrUrl;
                    XmlTagValue tagValue;
                    String tagValueText;
                    String itemNameNoAndroidPrefix;
                    String itemNameAttr = xmlItemTag.getAttributeValue("name");
                    String string = itemNameNoAndroidPrefix = itemNameAttr == null ? null : StringUtil.trimStart((String)itemNameAttr, (String)"android:");
                    if (itemNameAttr != null && itemNameAttr.startsWith("android:") && frameworkResources.hasResources(ResourceNamespace.ANDROID, ResourceType.ATTR, itemNameNoAndroidPrefix) && this.isAppCompatAttribute(itemNameNoAndroidPrefix)) {
                        result2.add(new MigrateToAppCompatUsageInfo.ChangeStyleUsageInfo((PsiElement)xmlItemTag.getAttribute("name"), itemNameAttr, itemNameNoAndroidPrefix));
                    }
                    if (!AppCompatStyleMigration.hasResourceItem(frameworkResources, tagValueText = (tagValue = xmlItemTag.getValue()).getText()) || (attrUrl = ResourceUrl.parse((String)tagValueText)) == null || !attrUrl.isFramework() || !this.isAppCompatAttribute(attrUrl.name) || xmlItemTag.getValue().getTextElements().length != 1) continue;
                    ResourceUrl changeToStyleAttr = attrUrl.isTheme() ? ResourceUrl.createThemeReference(null, (ResourceType)ResourceType.ATTR, (String)attrUrl.name) : ResourceUrl.create(null, (ResourceType)ResourceType.ATTR, (String)attrUrl.name);
                    String changedStyle = changeToStyleAttr.toString();
                    result2.add(new MigrateToAppCompatUsageInfo.ChangeStyleUsageInfo((PsiElement)xmlItemTag.getValue().getTextElements()[0], tagValueText, changedStyle));
                }
            }
        }
    }

    private void addStyleUsagesFromManifest(@NotNull AndroidFacet facet2, ResourceRepository frameworkResources, List<MigrateToAppCompatUsageInfo.ChangeStyleUsageInfo> result2) {
        Manifest manifest = Manifest.getMainManifest(facet2);
        if (manifest != null) {
            XmlTag applicationTag = manifest.getApplication().getXmlTag();
            if (applicationTag != null) {
                XmlAttribute theme = applicationTag.getAttribute("theme", "http://schemas.android.com/apk/res/android");
                this.convertThemeAttr2UsageInfo(theme, frameworkResources, result2);
            }
            List<Activity> activities = manifest.getApplication().getActivities();
            for (Activity activity : activities) {
                XmlAttribute activityTheme = activity.getXmlTag().getAttribute("theme", "http://schemas.android.com/apk/res/android");
                this.convertThemeAttr2UsageInfo(activityTheme, frameworkResources, result2);
            }
        }
    }

    private static String toAppCompatThemeOrStyleName(String themeName) {
        block3: {
            Pair<Boolean, String> result2;
            block2: {
                result2 = AppCompatStyleMigration.replaceStyleNameIfContains(themeName, ".Material");
                if (((Boolean)result2.first).booleanValue()) break block2;
                result2 = AppCompatStyleMigration.replaceStyleNameIfContains(themeName, ".Holo");
                if (!((Boolean)result2.first).booleanValue()) break block3;
            }
            return (String)result2.second;
        }
        return themeName;
    }

    private static Pair<Boolean, String> replaceStyleNameIfContains(@NotNull String originalStyleName, @NotNull String findWithoutTrailingDot) {
        if (originalStyleName.endsWith(findWithoutTrailingDot)) {
            return Pair.create((Object)true, (Object)StringUtil.replace((String)originalStyleName, (String)findWithoutTrailingDot, (String)".AppCompat"));
        }
        if (originalStyleName.contains(findWithoutTrailingDot + ".")) {
            return Pair.create((Object)true, (Object)StringUtil.replace((String)originalStyleName, (String)(findWithoutTrailingDot + "."), (String)".AppCompat."));
        }
        return Pair.create((Object)false, null);
    }

    private void convertThemeAttr2UsageInfo(XmlAttribute theme, ResourceRepository frameworkResources, List<MigrateToAppCompatUsageInfo.ChangeStyleUsageInfo> result2) {
        String appCompatThemeName;
        String themeValue;
        ResourceUrl themeUrl;
        if (theme != null && theme.getValueElement() != null && theme.getValue() != null && AppCompatStyleMigration.hasResourceItem(frameworkResources, theme.getValue()) && (themeUrl = ResourceUrl.parse((String)(themeValue = theme.getValue()))) != null && this.isAppCompatStyle(appCompatThemeName = AppCompatStyleMigration.toAppCompatThemeOrStyleName(themeUrl.name))) {
            ResourceUrl changeToStyleAttr = ResourceUrl.create(null, (ResourceType)ResourceType.STYLE, (String)appCompatThemeName);
            result2.add(new MigrateToAppCompatUsageInfo.ChangeStyleUsageInfo((PsiElement)theme.getValueElement(), themeValue, changeToStyleAttr.toString()));
        }
    }

    private static boolean hasResourceItem(@NotNull ResourceRepository frameworkResources, @NotNull String url) {
        if (url.startsWith("?")) {
            String remainder = url.substring("?".length());
            if (url.startsWith("?attr/")) {
                url = "@" + url.substring("?".length());
                return AppCompatStyleMigration.hasResourceItem(frameworkResources, url);
            }
            int colon = url.indexOf(58);
            if (colon >= 0) {
                if (remainder.indexOf(47, colon) == -1) {
                    remainder = remainder.substring(0, colon) + "attr" + '/' + remainder.substring(colon);
                }
                url = "@" + remainder;
                return AppCompatStyleMigration.hasResourceItem(frameworkResources, url);
            }
            int slash = url.indexOf(47);
            if (slash < 0) {
                url = "@attr/" + remainder;
                return AppCompatStyleMigration.hasResourceItem(frameworkResources, url);
            }
        }
        if (!url.startsWith("@")) {
            return false;
        }
        assert (url.startsWith("@") || url.startsWith("?")) : url;
        int typeEnd = url.indexOf(47, 1);
        if (typeEnd >= 0) {
            String typeName;
            ResourceType type;
            int nameBegin = typeEnd + 1;
            int typeBegin = url.startsWith("@+") ? 2 : 1;
            int colon = url.lastIndexOf(58, typeEnd);
            ResourceNamespace namespace = ResourceNamespace.RES_AUTO;
            if (colon >= 0) {
                namespace = colon - typeBegin == "android".length() && url.startsWith("android", typeBegin) ? ResourceNamespace.ANDROID : ResourceNamespace.TODO();
                typeBegin = colon + 1;
            }
            if ((type = ResourceType.fromXmlValue((String)(typeName = url.substring(typeBegin, typeEnd)))) != null) {
                String name = url.substring(nameBegin);
                return frameworkResources.hasResources(namespace, type, name);
            }
        }
        return false;
    }
}

