/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.lint;

import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.LintIdeQuickFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class SetScrollViewSizeQuickFix
implements LintIdeQuickFix {
    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class);
        if (tag == null) {
            return;
        }
        XmlTag parentTag = tag.getParentTag();
        if (parentTag == null) {
            return;
        }
        boolean isHorizontal = "HorizontalScrollView".equals(parentTag.getName());
        String attributeName = isHorizontal ? "layout_width" : "layout_height";
        tag.setAttribute(attributeName, "http://schemas.android.com/apk/res/android", "wrap_content");
    }

    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class);
        if (tag == null) {
            return false;
        }
        return tag.getParentTag() != null;
    }

    @NotNull
    public String getName() {
        return AndroidBundle.message("android.lint.fix.set.to.wrap.content", new Object[0]);
    }
}

