/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.lint;

import com.android.resources.ResourceType;
import com.google.common.base.CharMatcher;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.android.intentions.AndroidAddStringResourceAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidAddStringResourceQuickFix
extends AndroidAddStringResourceAction {
    private static final CharMatcher DISALLOWED_CHARS = CharMatcher.inRange((char)'a', (char)'z').or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.inRange((char)'0', (char)'9')).negate();
    private final PsiElement myStartElement;

    public AndroidAddStringResourceQuickFix(@NotNull PsiElement startElement) {
        this.myStartElement = startElement;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor2, PsiFile file2) {
        if (!this.myStartElement.isValid()) {
            return false;
        }
        XmlAttributeValue value2 = AndroidAddStringResourceQuickFix.getAttributeValue(this.myStartElement);
        return value2 != null && AndroidAddStringResourceQuickFix.getStringLiteralValue(project, (PsiElement)value2, file2, ResourceType.STRING) != null;
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor2, PsiFile file2) throws IncorrectOperationException {
        String value2;
        String defaultName = null;
        PsiElement parent = this.myStartElement.getParent();
        if (parent instanceof XmlAttribute && (value2 = ((XmlAttribute)parent).getValue()) != null) {
            defaultName = AndroidAddStringResourceQuickFix.buildResourceName(value2);
        }
        this.invokeIntention(project, editor2, file2, defaultName);
    }

    @NotNull
    static String buildResourceName(@NotNull String value2) {
        String result2 = StringUtil.toLowerCase((String)DISALLOWED_CHARS.trimAndCollapseFrom((CharSequence)value2, '_'));
        if (!result2.isEmpty() && CharMatcher.javaDigit().matches(result2.charAt(0))) {
            return "_" + result2;
        }
        return result2;
    }

    public void invokeIntention(Project project, Editor editor2, PsiFile file2, @Nullable String resName) {
        XmlAttributeValue attributeValue = AndroidAddStringResourceQuickFix.getAttributeValue(this.myStartElement);
        if (attributeValue != null) {
            AndroidAddStringResourceQuickFix.doInvoke(project, editor2, file2, resName, (PsiElement)attributeValue, ResourceType.STRING);
        }
    }

    @Nullable
    private static XmlAttributeValue getAttributeValue(@NotNull PsiElement element2) {
        XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)element2, XmlAttribute.class);
        return attribute != null ? attribute.getValueElement() : null;
    }
}

