/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.importDependencies;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.ListModel;
import org.jetbrains.android.importDependencies.ImportDependenciesTask;
import org.jetbrains.android.util.AndroidBundle;

class ImportDependenciesDialog
extends DialogWrapper {
    private final CheckBoxList myCheckBoxList = new CheckBoxList();
    private final List<ImportDependenciesTask> myTasks;
    private final Map<ImportDependenciesTask, JCheckBox> myTask2Checkbox = new HashMap<ImportDependenciesTask, JCheckBox>();

    protected ImportDependenciesDialog(Project project, List<ImportDependenciesTask> tasks) {
        super(project, false);
        this.setTitle(AndroidBundle.message("android.import.dependencies.dialog.title", new Object[0]));
        this.myTasks = tasks;
        Object[] checkBoxes = new JCheckBox[tasks.size()];
        for (int i2 = 0; i2 < checkBoxes.length; ++i2) {
            ImportDependenciesTask task2 = tasks.get(i2);
            JCheckBox checkBox = new JCheckBox(task2.getTitle());
            checkBox.setSelected(true);
            checkBoxes[i2] = checkBox;
            this.myTask2Checkbox.put(task2, checkBox);
        }
        this.myCheckBoxList.setModel((ListModel)new CollectionListModel(checkBoxes));
        this.init();
    }

    protected JComponent createCenterPanel() {
        JBScrollPane pane = new JBScrollPane((Component)this.myCheckBoxList);
        pane.setPreferredSize((Dimension)JBUI.size((int)500, (int)200));
        return pane;
    }

    public List<ImportDependenciesTask> getSelectedTasks() {
        ArrayList<ImportDependenciesTask> result2 = new ArrayList<ImportDependenciesTask>();
        for (ImportDependenciesTask task2 : this.myTasks) {
            if (!this.myTask2Checkbox.get(task2).isSelected()) continue;
            result2.add(task2);
        }
        return result2;
    }
}

