/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.formatter;

import com.intellij.application.options.XmlCodeStyleSettingsProvider;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationsConfiguration;
import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.formatter.AndroidXmlCodeStyleSettings;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidCodeStyleNotificationProvider
extends EditorNotifications.Provider<MyPanel> {
    private static final Key<MyPanel> KEY = Key.create((String)"android.xml.code.style.notification");
    @NonNls
    private static final String ANDROID_XML_CODE_STYLE_NOTIFICATION_GROUP = "Android XML code style notification";
    private final Project myProject;
    private final EditorNotifications myNotifications;

    public AndroidCodeStyleNotificationProvider(Project project) {
        this.myProject = project;
        this.myNotifications = EditorNotifications.getInstance((Project)project);
    }

    @NotNull
    public Key<MyPanel> getKey() {
        return KEY;
    }

    @Nullable
    public MyPanel createNotificationPanel(@NotNull VirtualFile file2, @NotNull FileEditor fileEditor) {
        VirtualFile resDir;
        if (file2.getFileType() != XmlFileType.INSTANCE || !(fileEditor instanceof TextEditor)) {
            return null;
        }
        Module module2 = ModuleUtilCore.findModuleForFile((VirtualFile)file2, (Project)this.myProject);
        if (module2 == null) {
            return null;
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
        if (facet2 == null) {
            return null;
        }
        VirtualFile parent = file2.getParent();
        VirtualFile virtualFile = resDir = parent != null ? parent.getParent() : null;
        if (resDir == null || !ModuleResourceManagers.getInstance(facet2).getLocalResourceManager().isResourceDir(resDir)) {
            return null;
        }
        CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)this.myProject);
        AndroidXmlCodeStyleSettings androidSettings = AndroidXmlCodeStyleSettings.getInstance(settings);
        if (androidSettings.USE_CUSTOM_SETTINGS) {
            return null;
        }
        if (NotificationsConfigurationImpl.getSettings((String)ANDROID_XML_CODE_STYLE_NOTIFICATION_GROUP).getDisplayType() == NotificationDisplayType.NONE) {
            return null;
        }
        NotificationsConfiguration.getNotificationsConfiguration().register(ANDROID_XML_CODE_STYLE_NOTIFICATION_GROUP, NotificationDisplayType.BALLOON, false);
        return new MyPanel();
    }

    public class MyPanel
    extends EditorNotificationPanel {
        MyPanel() {
            this.setText("You can format your XML resources in the 'standard' Android way. Choose 'Set from... | Android' in the XML code style settings.");
            this.createActionLabel("Open code style settings", new Runnable(){

                @Override
                public void run() {
                    ShowSettingsUtilImpl.showSettingsDialog((Project)AndroidCodeStyleNotificationProvider.this.myProject, (String)("preferences.sourceCode." + XmlCodeStyleSettingsProvider.getConfigurableDisplayNameText()), (String)"");
                    AndroidCodeStyleNotificationProvider.this.myNotifications.updateAllNotifications();
                }
            });
            this.createActionLabel("Disable notification", new Runnable(){

                @Override
                public void run() {
                    NotificationsConfiguration.getNotificationsConfiguration().changeSettings(AndroidCodeStyleNotificationProvider.ANDROID_XML_CODE_STYLE_NOTIFICATION_GROUP, NotificationDisplayType.NONE, false, false);
                    AndroidCodeStyleNotificationProvider.this.myNotifications.updateAllNotifications();
                }
            });
        }
    }
}

