/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.facet;

import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.projectsystem.ScopeType;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.lint.checks.AnnotationDetector;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.InheritanceUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u001a\"\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u001a \u0010\u0007\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005\u001a\u0018\u0010\b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0018\u0010\t\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a+\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b2\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0010\u001a\n\u0010\u0011\u001a\u00020\u0012*\u00020\u0001\u00a8\u0006\u0013"}, d2={"findClassByName", "Lcom/intellij/psi/PsiClass;", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "name", "", "baseClassName", "findClassValidInXMLByName", "findViewClassByName", "findViewValidInXMLByName", "getTagNamesByClass", "", "c", "apiLevel", "", "parentClassQualifiedName", "(Lcom/intellij/psi/PsiClass;ILjava/lang/String;)[Ljava/lang/String;", "isVisibleInXml", "", "intellij.android.core"})
public final class AndroidClassesForXmlUtilKt {
    private static final PsiClass findClassByName(AndroidFacet facet2, String name, String baseClassName) {
        PsiClass psiClass;
        block5: {
            Module module2 = facet2.getModule();
            Project project = module2.getProject();
            PsiClass psiClass2 = JavaPsiFacade.getInstance((Project)project).findClass(baseClassName, module2.getModuleWithLibrariesScope());
            if (psiClass2 == null) {
                return null;
            }
            PsiClass baseClass = psiClass2;
            if (!StringsKt.contains$default((CharSequence)name, (CharSequence)".", (boolean)false, (int)2, null)) {
                PsiClass[] classes2;
                PsiClass[] psiClassArray = classes2 = PsiShortNamesCache.getInstance((Project)project).getClassesByName(name, module2.getModuleWithLibrariesScope());
                boolean bl = false;
                PsiClass[] psiClassArray2 = psiClassArray;
                boolean bl2 = false;
                PsiClass[] psiClassArray3 = psiClassArray2;
                int n = psiClassArray3.length;
                for (int j = 0; j < n; ++j) {
                    PsiClass psiClass3;
                    PsiClass it = psiClass3 = psiClassArray3[j];
                    boolean bl3 = false;
                    if (!(it.getQualifiedName() != null && InheritanceUtil.isInheritorOrSelf((PsiClass)it, (PsiClass)baseClass, (boolean)true))) continue;
                    psiClass = psiClass3;
                    break block5;
                }
                psiClass = null;
            } else {
                PsiClass[] classes3;
                PsiClass[] psiClassArray = classes3 = JavaPsiFacade.getInstance((Project)project).findClasses(name, ProjectSystemUtil.getModuleSystem(module2).getResolveScope(ScopeType.MAIN));
                boolean bl = false;
                PsiClass[] psiClassArray4 = psiClassArray;
                boolean bl4 = false;
                PsiClass[] psiClassArray5 = psiClassArray4;
                int n = psiClassArray5.length;
                for (int j = 0; j < n; ++j) {
                    PsiClass psiClass4;
                    PsiClass it = psiClass4 = psiClassArray5[j];
                    boolean bl5 = false;
                    if (!InheritanceUtil.isInheritorOrSelf((PsiClass)it, (PsiClass)baseClass, (boolean)true)) continue;
                    psiClass = psiClass4;
                    break block5;
                }
                psiClass = null;
            }
        }
        return psiClass;
    }

    @Nullable
    public static final PsiClass findClassValidInXMLByName(@NotNull AndroidFacet facet2, @NotNull String name, @NotNull String baseClassName) {
        PsiClass psiClass = AndroidClassesForXmlUtilKt.findClassByName(facet2, name, baseClassName);
        if (psiClass == null) {
            return null;
        }
        PsiClass candidate = psiClass;
        if (!AndroidClassesForXmlUtilKt.isVisibleInXml(candidate)) {
            return null;
        }
        if (Intrinsics.areEqual((Object)candidate.getName(), (Object)name)) {
            String string = candidate.getQualifiedName();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            if (IdeResourcesUtil.isClassPackageNeeded(string, candidate, AndroidModuleInfo.getInstance(facet2).getModuleMinApi(), baseClassName)) {
                return null;
            }
        }
        return candidate;
    }

    @Nullable
    public static final PsiClass findViewClassByName(@NotNull AndroidFacet facet2, @NotNull String name) {
        return AndroidClassesForXmlUtilKt.findClassByName(facet2, name, "android.view.View");
    }

    @Nullable
    public static final PsiClass findViewValidInXMLByName(@NotNull AndroidFacet facet2, @NotNull String name) {
        return AndroidClassesForXmlUtilKt.findClassValidInXMLByName(facet2, name, "android.view.View");
    }

    @NotNull
    public static final String[] getTagNamesByClass(@NotNull PsiClass c, int apiLevel, @Nullable String parentClassQualifiedName) {
        boolean $i$f$runReadAction = false;
        return (String[])ApplicationManager.getApplication().runReadAction(new Computable<T>(c, apiLevel, parentClassQualifiedName){
            final /* synthetic */ PsiClass $c$inlined;
            final /* synthetic */ int $apiLevel$inlined;
            final /* synthetic */ String $parentClassQualifiedName$inlined;
            {
                this.$c$inlined = psiClass;
                this.$apiLevel$inlined = n;
                this.$parentClassQualifiedName$inlined = string;
            }

            public final T compute() {
                String[] stringArray;
                boolean bl = false;
                String name = this.$c$inlined.getName();
                if (name == null || !AndroidClassesForXmlUtilKt.isVisibleInXml(this.$c$inlined)) {
                    stringArray = new String[]{};
                } else {
                    String string = this.$c$inlined.getQualifiedName();
                    if (string == null) {
                        String[] stringArray2 = new String[1];
                        stringArray = stringArray2;
                        stringArray2[0] = name;
                    } else {
                        String qualifiedName = string;
                        if (IdeResourcesUtil.isClassPackageNeeded(qualifiedName, this.$c$inlined, this.$apiLevel$inlined, this.$parentClassQualifiedName$inlined)) {
                            String[] stringArray3 = new String[1];
                            stringArray = stringArray3;
                            stringArray3[0] = qualifiedName;
                        } else {
                            String[] stringArray4 = new String[2];
                            stringArray4[0] = name;
                            stringArray = stringArray4;
                            stringArray4[1] = qualifiedName;
                        }
                    }
                }
                return (T)stringArray;
            }
        });
    }

    public static final boolean isVisibleInXml(@NotNull PsiClass $this$isVisibleInXml) {
        PsiModifierList psiModifierList = $this$isVisibleInXml.getModifierList();
        if (psiModifierList == null) {
            return false;
        }
        PsiModifierList modifierList = psiModifierList;
        boolean isPublic = modifierList.hasModifierProperty("public");
        boolean isRestricted = modifierList.hasAnnotation(AnnotationDetector.RESTRICT_TO_ANNOTATION.oldName()) || modifierList.hasAnnotation(AnnotationDetector.RESTRICT_TO_ANNOTATION.newName());
        return isPublic && !isRestricted && !AndroidUtils.isAbstract($this$isVisibleInXml);
    }
}

