/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.resources;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ValueResourceNameValidator;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.res.psi.ResourceReferencePsiElement;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.dom.converters.AndroidResourceReferenceBase;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.android.dom.resources.Style;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.inspections.CreateValueResourceQuickFix;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceNameConverter
extends ResolvingConverter<String>
implements CustomReferenceConverter<String> {
    public String fromString(@Nullable @NonNls String s, ConvertContext context) {
        if (this.getErrorMessage(s, context) != null) {
            return null;
        }
        return s;
    }

    public String toString(@Nullable String s, ConvertContext context) {
        return s;
    }

    public String getErrorMessage(@Nullable String s, ConvertContext context) {
        ResourceType type = null;
        XmlTag tag = context.getTag();
        if (tag != null && "attr".equals(tag.getName())) {
            type = ResourceType.ATTR;
        }
        return s == null ? null : ValueResourceNameValidator.getErrorText((String)s, type);
    }

    @Nullable
    public PsiElement resolve(String s, ConvertContext context) {
        ResourceType type;
        XmlTag tag;
        XmlElement element2 = context.getXmlElement();
        XmlTag xmlTag = tag = element2 instanceof XmlTag ? (XmlTag)element2 : (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element2, XmlTag.class);
        if (tag == null || s == null) {
            return null;
        }
        ResourceNamespace namespace = IdeResourcesUtil.getResourceNamespace((PsiElement)element2);
        if (namespace == null) {
            return null;
        }
        PsiFile file2 = tag.getContainingFile();
        if (file2 == null) {
            return null;
        }
        PsiDirectory directory = file2.getParent();
        if (directory == null) {
            return null;
        }
        ResourceFolderType resType = ResourceFolderType.getFolderType((String)directory.getName());
        if (ResourceFolderType.VALUES == resType && (type = IdeResourcesUtil.getResourceTypeForResourceTag(tag)) != null) {
            return new ResourceReferencePsiElement(new ResourceReference(namespace, type, s), context.getPsiManager(), false);
        }
        return null;
    }

    public boolean isReferenceTo(@NotNull PsiElement element2, String stringValue, @Nullable String resolveResult, ConvertContext context) {
        if (((Boolean)StudioFlags.RESOLVE_USING_REPOS.get()).booleanValue() && element2 instanceof ResourceReferencePsiElement) {
            return ((ResourceReferencePsiElement)element2).getPsiManager().areElementsEquivalent(element2, this.resolve(stringValue, context));
        }
        return super.isReferenceTo(element2, stringValue, (Object)resolveResult, context);
    }

    @NotNull
    public Collection<String> getVariants(ConvertContext context) {
        DomElement element2 = context.getInvocationElement();
        if (!(element2 instanceof GenericAttributeValue)) {
            return Collections.emptyList();
        }
        if (element2.getParent() instanceof Style) {
            return ResourceNameConverter.getStyleNameVariants(context, (GenericAttributeValue)element2);
        }
        return Collections.emptyList();
    }

    private static Collection<String> getStyleNameVariants(ConvertContext context, GenericAttributeValue element2) {
        Module module2 = context.getModule();
        if (module2 == null) {
            return Collections.emptyList();
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
        if (facet2 == null) {
            return Collections.emptyList();
        }
        LocalResourceManager manager = LocalResourceManager.getInstance(module2);
        if (manager == null) {
            return Collections.emptyList();
        }
        LocalResourceRepository appResources = ResourceRepositoryManager.getAppResources(facet2);
        Set styleNames = appResources.getResources(ResourceNamespace.TODO(), ResourceType.STYLE).keySet();
        ArrayList<String> result2 = new ArrayList<String>();
        String currentValue = element2.getStringValue();
        for (String name : styleNames) {
            if (currentValue != null && currentValue.startsWith(name)) continue;
            result2.add(name + '.');
        }
        return result2;
    }

    @NotNull
    public PsiReference[] createReferences(GenericDomValue<String> value2, PsiElement element2, ConvertContext context) {
        Module module2 = context.getModule();
        if (module2 == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
        if (facet2 == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        DomElement parent = value2.getParent();
        if (parent instanceof Style) {
            return ResourceNameConverter.getReferencesInStyleName((Style)parent, value2, facet2);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static PsiReference[] getReferencesInStyleName(@NotNull Style style, @NotNull GenericDomValue<String> value2, @NotNull AndroidFacet facet2) {
        String s = value2.getStringValue();
        if (s == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        String[] ids2 = s.split("\\.");
        if (ids2.length < 2 || style.getParentStyle().getStringValue() != null) {
            return PsiReference.EMPTY_ARRAY;
        }
        ArrayList<MyParentStyleReference> result2 = new ArrayList<MyParentStyleReference>(ids2.length - 1);
        int offset2 = s.length();
        for (int i2 = ids2.length - 1; i2 >= 0; --i2) {
            if (i2 < ids2.length - 1) {
                String parentStyleName = s.substring(0, offset2);
                ResourceValue val = ResourceValue.referenceTo('\u0000', null, ResourceType.STYLE.getName(), parentStyleName);
                result2.add(new MyParentStyleReference(value2, new TextRange(1, 1 + offset2), val, facet2));
                if (ResourceNameConverter.hasExplicitParent(facet2, parentStyleName)) break;
            }
            offset2 = offset2 - ids2[i2].length() - 1;
        }
        return result2.toArray(PsiReference.EMPTY_ARRAY);
    }

    public static boolean hasExplicitParent(@NotNull AndroidFacet facet2, @NotNull String localStyleName) {
        LocalResourceRepository repository = ResourceRepositoryManager.getAppResources(facet2);
        List<ResourceItem> styles2 = repository.getResources(ResourceNamespace.TODO(), ResourceType.STYLE, localStyleName);
        if (styles2.isEmpty()) {
            return false;
        }
        for (ResourceItem style : styles2) {
            com.android.ide.common.rendering.api.ResourceValue resourceValue2 = style.getResourceValue();
            if (resourceValue2 instanceof StyleResourceValue && ((StyleResourceValue)resourceValue2).getParentStyleName() != null) continue;
            return false;
        }
        return true;
    }

    public static class MyParentStyleReference
    extends AndroidResourceReferenceBase
    implements LocalQuickFixProvider {
        public MyParentStyleReference(@NotNull GenericDomValue value2, @Nullable TextRange range, @NotNull ResourceValue resourceValue2, @NotNull AndroidFacet facet2) {
            super(value2, range, resourceValue2, facet2);
        }

        public LocalQuickFix[] getQuickFixes() {
            String resourceName = this.getValue();
            if (resourceName.isEmpty()) {
                return LocalQuickFix.EMPTY_ARRAY;
            }
            PsiFile psiFile2 = ((XmlElement)this.getElement()).getContainingFile();
            if (psiFile2 == null) {
                return LocalQuickFix.EMPTY_ARRAY;
            }
            return new LocalQuickFix[]{new CreateValueResourceQuickFix(this.myFacet, ResourceType.STYLE, resourceName, psiFile2, false)};
        }
    }
}

