/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.android.tools.idea.model.ManifestPlaceholderResolver;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManifestPlaceholderConverter
extends ResolvingConverter
implements CustomReferenceConverter<Object> {
    private static Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\$\\{(\\w+)\\}?");
    private Converter myConverterDelegate;

    public ManifestPlaceholderConverter(@NotNull Converter converter) {
        this.myConverterDelegate = converter;
    }

    @NotNull
    public Collection<?> getVariants(ConvertContext context) {
        if (this.myConverterDelegate instanceof ResolvingConverter) {
            return ((ResolvingConverter)this.myConverterDelegate).getVariants(context);
        }
        return Collections.emptyList();
    }

    public String getErrorMessage(@Nullable String s, ConvertContext context) {
        if (context.getModule() != null && s != null && s.contains("${")) {
            ManifestPlaceholderResolver resolver = new ManifestPlaceholderResolver(context.getModule());
            s = resolver.resolve(s);
        }
        return this.myConverterDelegate.getErrorMessage(s, context);
    }

    @Nullable
    public Object fromString(@Nullable @NonNls String s, ConvertContext context) {
        if (s != null && s.contains("${")) {
            return new PlaceholderValue(s);
        }
        return this.myConverterDelegate.fromString(s, context);
    }

    @Nullable
    public String toString(@Nullable Object o, ConvertContext context) {
        if (o instanceof PlaceholderValue) {
            return ((PlaceholderValue)o).myValueWithPlaceholders;
        }
        return this.myConverterDelegate != null ? this.myConverterDelegate.toString(o, context) : null;
    }

    @NotNull
    public PsiReference[] createReferences(GenericDomValue<Object> value2, PsiElement element2, ConvertContext context) {
        if (context.getModule() == null || !(value2.getValue() instanceof PlaceholderValue) && this.myConverterDelegate instanceof CustomReferenceConverter) {
            return ((CustomReferenceConverter)this.myConverterDelegate).createReferences(value2, element2, context);
        }
        String stringValue = element2.getText();
        if (stringValue == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        ManifestPlaceholderResolver resolver = new ManifestPlaceholderResolver(context.getModule());
        ImmutableSet placeholders = resolver.getPlaceholders().keySet();
        if (placeholders.isEmpty()) {
            return PsiReference.EMPTY_ARRAY;
        }
        String[] placeholdersArray = ArrayUtil.toStringArray((Collection)placeholders);
        ArrayList result2 = Lists.newArrayList();
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(stringValue);
        while (matcher.find()) {
            TextRange range = new TextRange(matcher.start(1), matcher.end(1));
            result2.add(new PlaceholderReference(element2, range, placeholdersArray));
        }
        return result2.toArray(PsiReference.EMPTY_ARRAY);
    }

    private static class PlaceholderReference
    extends PsiReferenceBase<PsiElement> {
        private final PsiElement myDummyElement = new FakePsiElement(){

            public PsiElement getParent() {
                return this.getElement();
            }
        };
        private final ImmutableSet<String> myPlaceholderNames;
        private final String[] myValues;
        private final String myName;

        public PlaceholderReference(@NotNull PsiElement element2, TextRange range, String[] values2) {
            super(element2, range, true);
            this.myName = range.substring(element2.getText());
            this.myPlaceholderNames = ImmutableSet.copyOf((Object[])values2);
            this.myValues = values2;
        }

        @Nullable
        public PsiElement resolve() {
            return this.myPlaceholderNames.contains((Object)this.myName) ? this.myDummyElement : null;
        }

        @NotNull
        public Object[] getVariants() {
            return this.myValues;
        }
    }

    static class PlaceholderValue {
        String myValueWithPlaceholders;

        PlaceholderValue(String valueWithPlaceholders) {
            this.myValueWithPlaceholders = valueWithPlaceholders;
        }
    }
}

