/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.android.tools.idea.databinding.index.BindingXmlIndex;
import com.android.tools.idea.databinding.util.DataBindingUtil;
import com.android.utils.OffsetTrackingDecodedXmlValue;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import org.jetbrains.android.dom.converters.DataBindingConverter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataBindingVariableTypeConverter
extends DataBindingConverter {
    public String getErrorMessage(@Nullable String type, @NotNull ConvertContext context) {
        PsiTypeElement typeElement = DataBindingVariableTypeConverter.createTypeElement(type, context);
        if (typeElement != null) {
            PsiType unresolved = DataBindingVariableTypeConverter.findUnresolvedType(typeElement.getType());
            if (unresolved == null) {
                return null;
            }
            type = unresolved.getPresentableText();
        }
        return super.getErrorMessage(type, context);
    }

    @Override
    @Nullable
    public PsiElement fromString(@Nullable String type, @NotNull ConvertContext context) {
        if (type == null) {
            return null;
        }
        PsiElement element2 = super.fromString(type, context);
        if (element2 != null) {
            return element2;
        }
        PsiTypeElement typeElement = DataBindingVariableTypeConverter.createTypeElement(type, context);
        if (typeElement != null && DataBindingVariableTypeConverter.findUnresolvedType(typeElement.getType()) != null) {
            return null;
        }
        return typeElement;
    }

    @Nullable
    private static PsiTypeElement createTypeElement(@Nullable String type, @NotNull ConvertContext context) {
        if (type == null) {
            return null;
        }
        BindingXmlIndex.Entry indexEntry = DataBindingVariableTypeConverter.getBindingIndexEntry(context);
        if (indexEntry == null) {
            return null;
        }
        Project project = context.getProject();
        type = DataBindingUtil.getQualifiedType(project, type, indexEntry.getData(), false);
        if (type == null) {
            return null;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        PsiJavaParserFacade parser = facade.getParserFacade();
        try {
            return parser.createTypeElementFromText(type, null);
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    @Nullable
    private static PsiType findUnresolvedType(@NotNull PsiType psiType) {
        final PsiType[] result2 = new PsiType[1];
        psiType.accept((PsiTypeVisitor)new DataBindingUtil.ClassReferenceVisitor(){

            @Override
            public void visitClassReference(@NotNull PsiClassReferenceType classType) {
                PsiClassType rawType;
                if (result2[0] == null && (rawType = classType.rawType()).resolve() == null) {
                    result2[0] = rawType;
                }
            }
        });
        return result2[0];
    }

    @Override
    @NotNull
    public PsiReference[] createReferences(GenericDomValue<PsiElement> value2, final PsiElement element2, final ConvertContext context) {
        PsiType psiType;
        assert (element2 instanceof XmlAttributeValue);
        XmlAttributeValue attrValue = (XmlAttributeValue)element2;
        final OffsetTrackingDecodedXmlValue decodedValue = new OffsetTrackingDecodedXmlValue((CharSequence)attrValue.getValue());
        String typeStr = decodedValue.getDecodedCharacters().toString();
        final ArrayList<PsiReferenceBase.Immediate> result2 = new ArrayList<PsiReferenceBase.Immediate>();
        final int valueOffset = attrValue.getValueTextRange().getStartOffset() - attrValue.getTextRange().getStartOffset();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)element2.getProject());
        PsiJavaParserFacade parser = psiFacade.getParserFacade();
        try {
            psiType = parser.createTypeFromText(typeStr, null);
        }
        catch (IncorrectOperationException e) {
            return PsiReference.EMPTY_ARRAY;
        }
        if (psiType instanceof PsiPrimitiveType) {
            result2.add(new PsiReferenceBase.Immediate(element2, true, element2));
        } else {
            psiType.accept((PsiTypeVisitor)new DataBindingUtil.ClassReferenceVisitor(){

                @Override
                public void visitClassReference(@NotNull PsiClassReferenceType classReference) {
                    PsiJavaCodeReferenceElement reference2 = classReference.getReference();
                    int offset2 = reference2.getTextRange().getStartOffset();
                    offset2 = decodedValue.getEncodedOffset(offset2);
                    DataBindingConverter.createReferences(element2, DataBindingVariableTypeConverter.getName(reference2), true, valueOffset + offset2, context, result2);
                }
            });
        }
        return result2.toArray(PsiReference.EMPTY_ARRAY);
    }

    @Nullable
    private static String getName(PsiJavaCodeReferenceElement reference2) {
        return reference2.isQualified() ? reference2.getQualifiedName() : reference2.getReferenceName();
    }
}

