/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.StyleItemResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceNamespaceContext;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.res.psi.ResourceReferencePsiElement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ResolvingConverter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.FrameworkResourceManager;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u0004\u0018\u00010\u00022\n\b\u0001\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016J*\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00062\b\u0010\u0014\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u00122\b\u0010\u0016\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001e\u0010\u0017\u001a\u0004\u0018\u00010\u00062\b\u0010\u0016\u001a\u0004\u0018\u00010\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/android/dom/converters/AttrNameConverter;", "Lcom/intellij/util/xml/ResolvingConverter;", "Lcom/android/ide/common/rendering/api/ResourceReference;", "()V", "fromString", "s", "", "context", "Lcom/intellij/util/xml/ConvertContext;", "getAttributesUsedByParentStyle", "", "styleTag", "Lcom/intellij/psi/xml/XmlTag;", "getParentStyleFromTag", "getVariants", "isReferenceTo", "", "element", "Lcom/intellij/psi/PsiElement;", "stringValue", "resolveResult", "resolve", "resourceReference", "toString", "intellij.android.core"})
public final class AttrNameConverter
extends ResolvingConverter<ResourceReference> {
    @NotNull
    public Collection<ResourceReference> getVariants(@NotNull ConvertContext context) {
        AndroidFacet facet2;
        AttributeDefinitions attrDefs;
        boolean bl = false;
        ArrayList<ResourceReference> result2 = new ArrayList<ResourceReference>();
        FrameworkResourceManager manager = FrameworkResourceManager.getInstance(context);
        if (manager != null && (attrDefs = manager.getAttributeDefinitions()) != null) {
            for (ResourceReference attr : attrDefs.getAttrs()) {
                result2.add(attr);
            }
        }
        if ((facet2 = AndroidFacet.getInstance((ConvertContext)context)) != null) {
            LocalResourceManager localResourceManager = ModuleResourceManagers.getInstance(facet2).getLocalResourceManager();
            AttributeDefinitions attrDefs2 = localResourceManager.getAttributeDefinitions();
            for (ResourceReference attr : attrDefs2.getAttrs()) {
                result2.add(attr);
            }
        }
        return result2;
    }

    @Nullable
    public PsiElement resolve(@Nullable ResourceReference resourceReference, @NotNull ConvertContext context) {
        if (context.getXmlElement() == null || resourceReference == null) {
            return null;
        }
        AndroidFacet androidFacet = AndroidFacet.getInstance((ConvertContext)context);
        if (androidFacet == null) {
            return null;
        }
        AndroidFacet facet2 = androidFacet;
        ResourceRepository resourceRepository = ResourceRepositoryManager.getInstance(facet2).getAllResources();
        if (resourceRepository == null) {
            return null;
        }
        ResourceRepository allResources = resourceRepository;
        boolean hasResources = allResources.hasResources(resourceReference.getNamespace(), resourceReference.getResourceType(), resourceReference.getName());
        return hasResources ? (PsiElement)new ResourceReferencePsiElement(resourceReference, context.getPsiManager(), false, 4, null) : null;
    }

    public boolean isReferenceTo(@NotNull PsiElement element2, @NotNull String stringValue, @Nullable ResourceReference resolveResult, @NotNull ConvertContext context) {
        PsiElement target = this.resolve(resolveResult, context);
        return element2.getManager().areElementsEquivalent(target, element2);
    }

    private final Collection<ResourceReference> getAttributesUsedByParentStyle(XmlTag styleTag) {
        ResourceReference parentStyleReference;
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)styleTag));
        if (module2 == null) {
            return CollectionsKt.emptyList();
        }
        Module module3 = module2;
        LocalResourceRepository localResourceRepository = ResourceRepositoryManager.getAppResources(module3);
        if (localResourceRepository == null) {
            return CollectionsKt.emptyList();
        }
        LocalResourceRepository appResources = localResourceRepository;
        ResourceReference resourceReference = this.getParentStyleFromTag(styleTag);
        if (resourceReference == null) {
            return CollectionsKt.emptyList();
        }
        ResourceReference resourceReference2 = parentStyleReference = resourceReference;
        if (resourceReference2 == null) {
            Intrinsics.throwNpe();
        }
        List parentStyles = appResources.getResources(resourceReference2);
        HashSet<ResourceReference> attributeNames = new HashSet<ResourceReference>();
        ArrayDeque<Pair> toExplore = new ArrayDeque<Pair>();
        for (ResourceItem parentStyle : parentStyles) {
            toExplore.push(Pair.pair((Object)parentStyle, (Object)0));
        }
        while (!toExplore.isEmpty()) {
            StyleResourceValue parentValue;
            Pair top = (Pair)toExplore.pop();
            Integer depth = (Integer)top.second;
            if (depth > 50 || (parentValue = (StyleResourceValue)((ResourceItem)top.first).getResourceValue()) == null || parentValue.isFramework()) continue;
            for (StyleItemResourceValue value2 : parentValue.getDefinedItems()) {
                ResourceReference attr;
                if (value2.isFramework() || (attr = value2.getAttr()) == null) continue;
                attributeNames.add(attr);
            }
            parentStyleReference = parentValue.getParentStyle();
            if (parentStyleReference == null) continue;
            for (ResourceItem parentStyle : appResources.getResources(parentStyleReference)) {
                toExplore.add(Pair.pair((Object)parentStyle, (Object)(depth + 1)));
            }
        }
        return attributeNames;
    }

    private final ResourceReference getParentStyleFromTag(XmlTag styleTag) {
        String parentName = styleTag.getAttributeValue("parent");
        if (parentName == null) {
            String string = styleTag.getAttributeValue("name");
            if (string == null) {
                return null;
            }
            String styleName = string;
            int lastDot = StringsKt.lastIndexOf$default((CharSequence)styleName, (char)'.', (int)0, (boolean)false, (int)6, null);
            if (lastDot == -1) {
                return null;
            }
            String string2 = styleName;
            int n = 0;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n, lastDot);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            parentName = string4;
        }
        ResourceUrl resourceUrl = ResourceUrl.parseStyleParentReference((String)parentName);
        return resourceUrl != null ? IdeResourcesUtil.resolve(resourceUrl, (XmlElement)styleTag) : null;
    }

    @Nullable
    public ResourceReference fromString(@NonNls @Nullable String s, @NotNull ConvertContext context) {
        if (s == null) {
            return null;
        }
        XmlElement xmlElement = context.getXmlElement();
        if (xmlElement == null) {
            return null;
        }
        XmlElement xmlElement2 = xmlElement;
        ResourceUrl resourceUrl = ResourceUrl.parseAttrReference((String)s);
        return resourceUrl != null ? IdeResourcesUtil.resolve(resourceUrl, xmlElement2) : null;
    }

    @Nullable
    public String toString(@Nullable ResourceReference resourceReference, @Nullable ConvertContext context) {
        if (resourceReference == null || context == null) {
            return null;
        }
        XmlTag xmlTag = context.getTag();
        if (xmlTag == null) {
            return resourceReference.getResourceUrl().toString();
        }
        XmlTag tag = xmlTag;
        ResourceNamespaceContext namespaceContext = IdeResourcesUtil.getNamespacesContext((XmlElement)tag);
        return namespaceContext != null ? resourceReference.getRelativeResourceUrl(namespaceContext.getCurrentNs(), namespaceContext.getResolver()).getQualifiedName() : resourceReference.getResourceUrl().toString();
    }
}

