/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.utils.SdkUtils;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.EnumConverter;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.WrappingConverter;
import com.intellij.util.xml.impl.ConvertContextFactory;
import com.intellij.util.xml.impl.DomCompletionContributor;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import java.util.ArrayList;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.dom.converters.AndroidResourceReferenceBase;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidResourceReference
extends AndroidResourceReferenceBase {
    private final GenericDomValue<ResourceValue> myValue;
    private boolean myIncludeDynamicFeatures;

    public AndroidResourceReference(@NotNull GenericDomValue<ResourceValue> value2, @NotNull AndroidFacet facet2, @NotNull ResourceValue resourceValue2, boolean includeDynamicFeatures) {
        super(value2, null, resourceValue2, facet2);
        this.myValue = value2;
        this.myIncludeDynamicFeatures = includeDynamicFeatures;
    }

    @Override
    public boolean includeDynamicFeatures() {
        return this.myIncludeDynamicFeatures;
    }

    @NotNull
    public Object[] getVariants() {
        Converter converter = this.getConverter();
        if ((converter instanceof EnumConverter || converter == AndroidDomUtil.BOOLEAN_CONVERTER) && DomCompletionContributor.isSchemaEnumerated((PsiElement)this.getElement())) {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        if (converter instanceof ResolvingConverter) {
            ResolvingConverter resolvingConverter = (ResolvingConverter)converter;
            ArrayList<Object> result2 = new ArrayList<Object>();
            ConvertContext convertContext = ConvertContextFactory.createConvertContext(this.myValue);
            for (Object variant2 : resolvingConverter.getVariants(convertContext)) {
                String name = converter.toString(variant2, convertContext);
                if (name == null) continue;
                result2.add(ElementPresentationManager.getInstance().createVariant(variant2, name, resolvingConverter.getPsiElement(variant2)));
            }
            return result2.toArray();
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName.startsWith("@+id/")) {
            newElementName = IdeResourcesUtil.getResourceNameByReferenceText(newElementName);
        }
        ResourceValue value2 = (ResourceValue)this.myValue.getValue();
        assert (value2 != null);
        ResourceType resType = value2.getType();
        if (resType != null && newElementName != null) {
            String newText;
            Converter converter;
            ResourceFolderType folderType = FolderTypeRelationship.getNonValuesRelatedFolder((ResourceType)resType);
            String newResName = folderType != null && newElementName.contains(".") ? SdkUtils.fileNameToResourceName((String)newElementName) : newElementName;
            ResourceValue newValue = ResourceValue.parse(newResName, true, true, false);
            if (newValue == null || newValue.getPrefix() == '\u0000') {
                newValue = ResourceValue.referenceTo(value2.getPrefix(), value2.getPackage(), value2.getResourceType(), newResName);
            }
            if ((converter = this.getConverter()) != null && (newText = converter.toString((Object)newValue, this.createConvertContext())) != null) {
                return super.handleElementRename(newText);
            }
        }
        return this.myValue.getXmlTag();
    }

    @Nullable
    private Converter getConverter() {
        return WrappingConverter.getDeepestConverter((Converter)this.myValue.getConverter(), this.myValue);
    }

    @NotNull
    private ConvertContext createConvertContext() {
        return ConvertContextFactory.createConvertContext((DomInvocationHandler)DomManagerImpl.getDomInvocationHandler(this.myValue));
    }
}

