/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.attrs;

import com.android.SdkConstants;
import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.ide.common.rendering.api.AttributeFormat;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleableResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.resources.ResourceType;
import com.android.tools.idea.resources.base.CommentTrackingXmlPullParser;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import com.intellij.openapi.diagnostic.Logger;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.dom.attrs.StyleableDefinition;
import org.jetbrains.android.dom.attrs.StyleableDefinitionImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class AttributeDefinitionsImpl
implements AttributeDefinitions {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.dom.attrs.AttributeDefinitionsImpl");
    private static final Splitter PIPE_SPLITTER = Splitter.on((char)'|').trimResults();
    @NotNull
    private final Map<ResourceReference, AttributeDefinition> myAttrs = new HashMap<ResourceReference, AttributeDefinition>();
    @NotNull
    private final Map<ResourceReference, StyleableDefinitionImpl> myStyleables = new HashMap<ResourceReference, StyleableDefinitionImpl>();
    @Nullable
    private final AttributeDefinitions myFrameworkAttributeDefinitions;

    private AttributeDefinitionsImpl(@Nullable AttributeDefinitions frameworkAttributeDefinitions) {
        this.myFrameworkAttributeDefinitions = frameworkAttributeDefinitions;
    }

    @NotNull
    public static AttributeDefinitions parseFrameworkFiles(File ... files2) {
        AttributeDefinitionsImpl attributeDefinitions = new AttributeDefinitionsImpl(null);
        for (File file2 : files2) {
            attributeDefinitions.addAttrsFromFile(file2);
        }
        return attributeDefinitions;
    }

    @NotNull
    public static AttributeDefinitions create(@Nullable AttributeDefinitions frameworkAttributeDefinitions, @NotNull ResourceRepository resources) {
        AttributeDefinitionsImpl attributeDefinitions = new AttributeDefinitionsImpl(frameworkAttributeDefinitions);
        attributeDefinitions.initializeFromResourceRepository(resources);
        return attributeDefinitions;
    }

    private void initializeFromResourceRepository(@NotNull ResourceRepository resources) {
        ResourceValue resourceValue2;
        Collection items2;
        for (ResourceNamespace namespace : resources.getNamespaces()) {
            items2 = resources.getResources(namespace, ResourceType.ATTR).values();
            for (ResourceItem item : items2) {
                resourceValue2 = item.getResourceValue();
                if (!(resourceValue2 instanceof AttrResourceValue)) continue;
                this.createOrUpdateAttributeDefinition((AttrResourceValue)resourceValue2, null);
            }
        }
        for (ResourceNamespace namespace : resources.getNamespaces()) {
            items2 = resources.getResources(namespace, ResourceType.STYLEABLE).values();
            for (ResourceItem item : items2) {
                resourceValue2 = item.getResourceValue();
                if (!(resourceValue2 instanceof StyleableResourceValue)) continue;
                StyleableResourceValue styleableValue = (StyleableResourceValue)resourceValue2;
                ResourceReference reference2 = styleableValue.asReference();
                StyleableDefinitionImpl styleable = this.myStyleables.computeIfAbsent(reference2, ref -> new StyleableDefinitionImpl(namespace, styleableValue.getName()));
                for (AttrResourceValue attrValue : styleableValue.getAllAttributes()) {
                    this.createOrUpdateAttributeDefinition(attrValue, styleable);
                }
            }
        }
    }

    private void createOrUpdateAttributeDefinition(@NotNull AttrResourceValue attrValue, @Nullable StyleableDefinitionImpl parentStyleable) {
        String groupName;
        String description2;
        ResourceReference attrRef = attrValue.asReference();
        AttributeDefinition attr = this.myAttrs.get(attrRef);
        if (attr == null) {
            if (this.myFrameworkAttributeDefinitions != null && attrValue.getNamespace().equals((Object)ResourceNamespace.ANDROID) && (attr = this.myFrameworkAttributeDefinitions.getAttrDefinition(attrRef)) != null) {
                attr = new AttributeDefinition(attr);
            }
            if (attr == null) {
                attr = new AttributeDefinition(attrValue.getNamespace(), attrValue.getName(), attrValue.getLibraryName(), null);
            }
            this.myAttrs.put(attrRef, attr);
        }
        attr.addFormats(attrValue.getFormats());
        Map valueMappings = attrValue.getAttributeValues();
        if (!valueMappings.isEmpty()) {
            attr.setValueMappings(valueMappings);
            HashMap valueDescriptions = Maps.newHashMapWithExpectedSize((int)valueMappings.size());
            for (String value2 : valueMappings.keySet()) {
                String description3 = attrValue.getValueDescription(value2);
                if (description3 == null) continue;
                valueDescriptions.put(value2, description3);
            }
            if (!valueDescriptions.isEmpty()) {
                attr.setValueDescriptions(valueDescriptions);
            }
        }
        if ((description2 = attrValue.getDescription()) != null) {
            attr.setDescription(description2, parentStyleable == null ? null : parentStyleable.getResourceReference());
        }
        if ((groupName = attrValue.getGroupName()) != null) {
            attr.setGroupName(groupName);
        }
        if (parentStyleable != null) {
            parentStyleable.addAttribute(attr);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void addAttrsFromFile(@NotNull File file) {
        try {
            stream = new BufferedInputStream(new FileInputStream(file));
            var3_4 = null;
            try {
                parser = new CommentTrackingXmlPullParser();
                parser.setInput(stream, null);
                styleable = null;
                event = parser.nextToken();
                depth = parser.getDepth();
                switch (event) {
                    case 2: {
                        tagName = parser.getName();
                        if (depth == 1) {
                            if (tagName.equals("resources")) ** break;
                            return;
                        }
                        if (depth <= 1) ** break;
                        var9_12 = tagName;
                        var10_14 = -1;
                        switch (var9_12.hashCode()) {
                            case 3004913: {
                                if (!var9_12.equals("attr")) break;
                                var10_14 = 0;
                                break;
                            }
                            case 1909939688: {
                                if (!var9_12.equals("declare-styleable")) break;
                                var10_14 = 1;
                            }
                        }
                        switch (var10_14) {
                            case 0: {
                                this.processAttrTag((XmlPullParser)parser, file, parser.getLastComment(), parser.getAttrGroupComment(), styleable);
                            }
                            case 1: {
                                if (styleable != null) {
                                    AttributeDefinitionsImpl.LOG.info("Found nested declare-styleable tag at " + file.getAbsolutePath() + " line " + parser.getLineNumber());
                                }
                                styleableName = parser.getAttributeValue(null, "name");
                                if (styleableName == null) {
                                    AttributeDefinitionsImpl.LOG.info("Found declare-styleable tag with no name at " + file.getAbsolutePath() + " line " + parser.getLineNumber());
                                }
                                styleable = new StyleableDefinitionImpl(ResourceNamespace.ANDROID, styleableName);
                                this.myStyleables.put(styleable.getResourceReference(), styleable);
                            }
                        }
                    }
                    case 3: {
                        if (!parser.getName().equals("declare-styleable")) ** break;
                        styleable = null;
                    }
                    ** default:
                    {
                    }
                    {
                    }
                }
            }
            catch (Throwable var4_7) {
                var3_4 = var4_7;
                throw var4_7;
            }
            finally {
                if (stream != null) {
                    if (var3_4 != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable var9_13) {
                            var3_4.addSuppressed(var9_13);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
        }
        catch (IOException | XmlPullParserException e) {
            AttributeDefinitionsImpl.LOG.warn("Failed to parse " + file.getAbsolutePath(), e);
        }
    }

    private void processAttrTag(@NotNull XmlPullParser parser, @NotNull File file2, @Nullable String precedingComment, @Nullable String attrGroup, @Nullable StyleableDefinitionImpl parentStyleable) throws IOException, XmlPullParserException {
        int event;
        String attrName = parser.getAttributeValue(null, "name");
        if (attrName == null) {
            LOG.info("Found attr tag with no name at " + file2.getAbsolutePath() + " line " + parser.getLineNumber());
            return;
        }
        if (attrName.startsWith("android:")) {
            attrName = attrName.substring(SdkConstants.ANDROID_NS_NAME_PREFIX_LEN);
        }
        if (attrName.indexOf(58) >= 0) {
            LOG.info("Found attr tag with an invalid name at " + file2.getAbsolutePath() + " line " + parser.getLineNumber());
            return;
        }
        AttributeDefinition attrDef = this.myAttrs.get(ResourceReference.attr((ResourceNamespace)ResourceNamespace.ANDROID, (String)attrName));
        if (attrDef == null) {
            attrDef = new AttributeDefinition(ResourceNamespace.ANDROID, attrName, null, null);
            attrDef.setGroupName(attrGroup);
            this.myAttrs.put(attrDef.getResourceReference(), attrDef);
        }
        if (parentStyleable != null) {
            parentStyleable.addAttribute(attrDef);
        }
        EnumSet<AttributeFormat> formats = EnumSet.noneOf(AttributeFormat.class);
        String format2 = parser.getAttributeValue(null, "format");
        if (format2 != null) {
            formats.addAll(AttributeDefinitionsImpl.parseAttrFormat(format2));
        }
        HashMap<String, Integer> valueMappings = null;
        HashMap<String, String> valueDescriptions = null;
        String lastComment = null;
        int attrTagDepth = parser.getDepth();
        do {
            event = parser.nextToken();
            switch (event) {
                case 2: {
                    Integer intValue;
                    String tagName = parser.getName();
                    if (tagName.equals("enum") && !formats.contains(AttributeFormat.FLAGS)) {
                        formats.add(AttributeFormat.ENUM);
                    } else if (tagName.equals("flag") && !formats.contains(AttributeFormat.ENUM)) {
                        formats.add(AttributeFormat.FLAGS);
                    }
                    String valueName = parser.getAttributeValue(null, "name");
                    if (valueName == null) {
                        LOG.info("Unknown value for tag: " + tagName);
                        break;
                    }
                    String strIntValue = parser.getAttributeValue(null, "value");
                    Integer n = intValue = strIntValue == null ? null : AttributeDefinitionsImpl.decodeIntegerValue(strIntValue);
                    if (valueMappings == null) {
                        valueMappings = new HashMap<String, Integer>();
                    }
                    valueMappings.putIfAbsent(valueName, intValue);
                    if (lastComment != null) {
                        if (valueDescriptions == null) {
                            valueDescriptions = new HashMap<String, String>();
                        }
                        valueDescriptions.putIfAbsent(valueName, lastComment);
                    }
                    lastComment = null;
                    break;
                }
                case 9: {
                    String commentText = parser.getText().trim();
                    if (AttributeDefinitionsImpl.isEmptyOrAsciiArt(commentText)) break;
                    lastComment = commentText;
                    break;
                }
            }
        } while (event != 3 || parser.getDepth() > attrTagDepth);
        attrDef.addFormats(formats);
        if (precedingComment != null) {
            attrDef.setDescription(precedingComment, parentStyleable == null ? null : parentStyleable.getResourceReference());
        }
        if (valueMappings != null) {
            attrDef.setValueMappings(valueMappings);
        }
        if (valueDescriptions != null) {
            attrDef.setValueDescriptions(valueDescriptions);
        }
    }

    @Nullable
    private static Integer decodeIntegerValue(@NotNull String value2) {
        try {
            return Long.decode(value2).intValue();
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static boolean isEmptyOrAsciiArt(@NotNull String commentText) {
        return commentText.isEmpty() || commentText.charAt(0) == '*' || commentText.charAt(0) == '=';
    }

    @NotNull
    private static Set<AttributeFormat> parseAttrFormat(@NotNull String formatString) {
        List formats = PIPE_SPLITTER.splitToList((CharSequence)formatString);
        EnumSet<AttributeFormat> result2 = EnumSet.noneOf(AttributeFormat.class);
        for (String format2 : formats) {
            AttributeFormat attributeFormat = AttributeFormat.fromXmlName((String)format2);
            if (attributeFormat == null) continue;
            result2.add(attributeFormat);
        }
        return result2;
    }

    @Override
    @Nullable
    public StyleableDefinition getStyleableDefinition(@NotNull ResourceReference styleable) {
        if (this.myFrameworkAttributeDefinitions != null && styleable.getNamespace().equals((Object)ResourceNamespace.ANDROID)) {
            return this.myFrameworkAttributeDefinitions.getStyleableDefinition(styleable);
        }
        return this.myStyleables.get(styleable);
    }

    @Override
    @Deprecated
    @Nullable
    public StyleableDefinition getStyleableByName(@NotNull String name) {
        StyleableDefinition styleable = this.getStyleableDefinition(ResourceReference.styleable((ResourceNamespace)ResourceNamespace.TODO(), (String)name));
        if (styleable == null) {
            styleable = this.getStyleableDefinition(ResourceReference.styleable((ResourceNamespace)ResourceNamespace.ANDROID, (String)name));
        }
        return styleable;
    }

    @Override
    @NotNull
    public Set<ResourceReference> getAttrs() {
        return this.myAttrs.keySet();
    }

    @Override
    @Nullable
    public AttributeDefinition getAttrDefinition(@NotNull ResourceReference attr) {
        AttributeDefinition attributeDefinition = this.myAttrs.get(attr);
        if (attributeDefinition == null && this.myFrameworkAttributeDefinitions != null && attr.getNamespace().equals((Object)ResourceNamespace.ANDROID)) {
            return this.myFrameworkAttributeDefinitions.getAttrDefinition(attr);
        }
        return attributeDefinition;
    }

    @Override
    @Deprecated
    @Nullable
    public AttributeDefinition getAttrDefByName(@NotNull String name) {
        ResourceReference attr = name.startsWith("android:") ? ResourceReference.attr((ResourceNamespace)ResourceNamespace.ANDROID, (String)name.substring(SdkConstants.ANDROID_NS_NAME_PREFIX_LEN)) : (this.myFrameworkAttributeDefinitions == null ? ResourceReference.attr((ResourceNamespace)ResourceNamespace.ANDROID, (String)name) : ResourceReference.attr((ResourceNamespace)ResourceNamespace.TODO(), (String)name));
        return this.getAttrDefinition(attr);
    }

    @Override
    @Nullable
    public String getAttrGroup(@NotNull ResourceReference attr) {
        AttributeDefinition attributeDefinition = this.getAttrDefinition(attr);
        return attributeDefinition == null ? null : attributeDefinition.getGroupName();
    }
}

