/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom;

import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.projectsystem.ScopeType;
import com.android.tools.idea.psi.TagToClassMapper;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.util.ModuleExtensionsKt;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiQualifiedNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.migration.MigrationClassImpl;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ProcessingContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.android.dom.AndroidXmlReferenceProviderKt;
import org.jetbrains.android.dom.layout.LayoutViewElement;
import org.jetbrains.android.dom.layout.View;
import org.jetbrains.android.dom.xml.AndroidXmlResourcesUtil;
import org.jetbrains.android.dom.xml.PreferenceElement;
import org.jetbrains.android.facet.AndroidClassesForXmlUtilKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.TagFromClassDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u000b2\u00020\u0001:\u0002\u000b\fB\u0005\u00a2\u0006\u0002\u0010\u0002J#\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\n\u00a8\u0006\r"}, d2={"Lorg/jetbrains/android/dom/AndroidXmlReferenceProvider;", "Lcom/intellij/psi/PsiReferenceProvider;", "()V", "getReferencesByElement", "", "Lcom/intellij/psi/PsiReference;", "element", "Lcom/intellij/psi/PsiElement;", "context", "Lcom/intellij/util/ProcessingContext;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/util/ProcessingContext;)[Lcom/intellij/psi/PsiReference;", "Companion", "MyClassOrPackageReference", "intellij.android.core"})
public final class AndroidXmlReferenceProvider
extends PsiReferenceProvider {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element2, @NotNull ProcessingContext context) {
        ASTNode closingTagName;
        if (!(element2 instanceof XmlTag)) {
            return new PsiReference[0];
        }
        AndroidFacet androidFacet = ModuleExtensionsKt.getAndroidFacet((PsiElement)element2);
        if (androidFacet == null) {
            return new PsiReference[0];
        }
        AndroidFacet facet2 = androidFacet;
        String string = AndroidXmlReferenceProvider.Companion.computeBaseClass((XmlTag)element2);
        if (string == null) {
            return new PsiReference[0];
        }
        String baseClassQName = string;
        List result2 = new ArrayList();
        ASTNode startTagName = XmlChildRole.START_TAG_NAME_FINDER.findChild(element2.getNode());
        if (startTagName != null) {
            AndroidXmlReferenceProvider.Companion.addReferences((XmlTag)element2, startTagName, result2, facet2, baseClassQName, true);
        }
        if ((closingTagName = XmlChildRole.CLOSING_TAG_NAME_FINDER.findChild(element2.getNode())) != null) {
            AndroidXmlReferenceProvider.Companion.addReferences((XmlTag)element2, closingTagName, result2, facet2, baseClassQName, false);
        }
        Collection $this$toTypedArray$iv = result2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        PsiReference[] psiReferenceArray = thisCollection$iv.toArray(new PsiReference[0]);
        if (psiReferenceArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return psiReferenceArray;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B5\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u0002H\u0016J\b\u0010\u001a\u001a\u00020\bH\u0016J\u0013\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0016\u00a2\u0006\u0002\u0010\u001eJ\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00022\u0006\u0010 \u001a\u00020\fH\u0016J\n\u0010!\u001a\u0004\u0018\u00010\u0002H\u0016J\n\u0010\"\u001a\u0004\u0018\u00010\u0002H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0010\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0015\u001a\u00070\u0016\u00a2\u0006\u0002\b\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/android/dom/AndroidXmlReferenceProvider$MyClassOrPackageReference;", "Lcom/intellij/psi/PsiReferenceBase;", "Lcom/intellij/psi/PsiElement;", "tag", "Lcom/intellij/psi/xml/XmlTag;", "myNameElement", "Lcom/intellij/lang/ASTNode;", "myRangeInNameElement", "Lcom/intellij/openapi/util/TextRange;", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "myBaseClassQName", "", "myStartTag", "", "(Lcom/intellij/psi/xml/XmlTag;Lcom/intellij/lang/ASTNode;Lcom/intellij/openapi/util/TextRange;Lorg/jetbrains/android/facet/AndroidFacet;Ljava/lang/String;Z)V", "isParentContainer", "()Z", "isParentContainer$delegate", "Lkotlin/Lazy;", "packagePrefix", "project", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/annotations/NotNull;", "bindToElement", "element", "getRangeInElement", "getVariants", "", "", "()[Ljava/lang/Object;", "handleElementRename", "newElementName", "resolve", "resolveInner", "intellij.android.core"})
    private static final class MyClassOrPackageReference
    extends PsiReferenceBase<PsiElement> {
        private final Project project;
        private final String packagePrefix;
        private final Lazy isParentContainer$delegate;
        private final ASTNode myNameElement;
        private final TextRange myRangeInNameElement;
        private final AndroidFacet facet;
        private final String myBaseClassQName;
        private final boolean myStartTag;

        private final boolean isParentContainer() {
            Lazy lazy = this.isParentContainer$delegate;
            MyClassOrPackageReference myClassOrPackageReference = this;
            Object var3_3 = null;
            boolean bl = false;
            return (Boolean)lazy.getValue();
        }

        @Nullable
        public PsiElement resolve() {
            return (PsiElement)ResolveCache.getInstance((Project)this.project).resolveWithCaching((PsiReference)this, (ResolveCache.AbstractResolver)new ResolveCache.AbstractResolver<MyClassOrPackageReference, PsiElement>(this){
                final /* synthetic */ MyClassOrPackageReference this$0;

                @Nullable
                public final PsiElement resolve(@NotNull MyClassOrPackageReference $noName_0, boolean $noName_1) {
                    return MyClassOrPackageReference.access$resolveInner(this.this$0);
                }
                {
                    this.this$0 = myClassOrPackageReference;
                }
            }, false, false);
        }

        private final PsiElement resolveInner() {
            PsiElement psiElement;
            PsiElement psiElement2;
            int end = this.myRangeInNameElement.getEndOffset();
            String string = this.myNameElement.getText();
            int n = 0;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n, end);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String value2 = string3;
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.project);
            PsiClass psiClass = AndroidClassesForXmlUtilKt.findClassValidInXMLByName(this.facet, value2, this.myBaseClassQName);
            if (!(psiClass instanceof PsiElement)) {
                psiClass = null;
            }
            if ((psiElement2 = (PsiElement)psiClass) == null) {
                PsiPackage psiPackage = facade.findPackage(value2);
                if (!(psiPackage instanceof PsiElement)) {
                    psiPackage = null;
                }
                psiElement2 = psiElement = (PsiElement)psiPackage;
            }
            if (psiElement2 == null) {
                PsiClass psiClass2 = facade.findClass(value2, ProjectSystemUtil.getModuleSystem(this.facet.getModule()).getResolveScope(ScopeType.MAIN));
                bl = false;
                boolean bl2 = false;
                PsiClass it = psiClass2;
                boolean bl3 = false;
                psiElement = (PsiElement)(it instanceof MigrationClassImpl ? psiClass2 : null);
            }
            return psiElement;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public Object[] getVariants() {
            void $this$mapTo$iv$iv;
            String name;
            PsiClass psiClass;
            boolean bl;
            Map.Entry entry;
            Map.Entry $dstr$name$psiClass;
            Map $this$filterTo$iv$iv;
            if (!this.isParentContainer()) {
                return new Object[0];
            }
            if (!this.myStartTag) {
                return new Object[0];
            }
            int apiLevel = AndroidModuleInfo.getInstance(this.facet).getModuleMinApi();
            Map<String, PsiClass> $this$filter$iv = TagToClassMapper.getInstance(this.facet.getModule()).getClassMap(this.myBaseClassQName);
            boolean $i$f$filter = false;
            Map<String, PsiClass> map2 = $this$filter$iv;
            Object destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            void var7_7 = $this$filterTo$iv$iv;
            boolean bl2 = false;
            Iterator iterator = var7_7.entrySet().iterator();
            while (iterator.hasNext()) {
                boolean bl3;
                Map.Entry element$iv$iv;
                $dstr$name$psiClass = element$iv$iv = iterator.next();
                boolean bl4 = false;
                entry = $dstr$name$psiClass;
                bl = false;
                String string = (String)entry.getKey();
                entry = $dstr$name$psiClass;
                bl = false;
                psiClass = (PsiClass)entry.getValue();
                entry = this.packagePrefix;
                bl = false;
                if (entry.length() == 0 && Intrinsics.areEqual((Object)name, (Object)psiClass.getQualifiedName())) {
                    String string2 = psiClass.getQualifiedName();
                    if (string2 == null) {
                        Intrinsics.throwNpe();
                    }
                    bl3 = IdeResourcesUtil.isClassPackageNeeded(string2, psiClass, apiLevel, this.myBaseClassQName);
                } else {
                    bl3 = StringsKt.startsWith$default((String)name, (String)this.packagePrefix, (boolean)false, (int)2, null);
                }
                if (!bl3) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            Map $this$map$iv = destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            var7_7 = $this$mapTo$iv$iv;
            bl2 = false;
            for (Map.Entry item$iv$iv : var7_7.entrySet()) {
                $dstr$name$psiClass = item$iv$iv;
                Object object = destination$iv$iv;
                boolean bl5 = false;
                entry = $dstr$name$psiClass;
                bl = false;
                name = (String)entry.getKey();
                entry = $dstr$name$psiClass;
                bl = false;
                psiClass = (PsiClass)entry.getValue();
                LookupElement lookupElement = AndroidXmlReferenceProviderKt.createClassAsTagXmlElement(StringsKt.removePrefix((String)name, (CharSequence)this.packagePrefix), psiClass);
                object.add(lookupElement);
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
            if (objectArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            return objectArray;
        }

        @NotNull
        public PsiElement bindToElement(@NotNull PsiElement element2) {
            PsiElement psiElement = element2;
            if (psiElement == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiQualifiedNamedElement");
            }
            String newName2 = ((PsiQualifiedNamedElement)psiElement).getQualifiedName();
            TextRange range = new TextRange(0, this.myRangeInNameElement.getEndOffset());
            return ElementManipulators.handleContentChange((PsiElement)this.myNameElement.getPsi(), (TextRange)range, (String)newName2);
        }

        @Nullable
        public PsiElement handleElementRename(@NotNull String newElementName) {
            return ElementManipulators.handleContentChange((PsiElement)this.myNameElement.getPsi(), (TextRange)this.myRangeInNameElement, (String)newElementName);
        }

        @NotNull
        public TextRange getRangeInElement() {
            int parentOffset = this.myNameElement.getStartOffsetInParent();
            return new TextRange(parentOffset + this.myRangeInNameElement.getStartOffset(), parentOffset + this.myRangeInNameElement.getEndOffset());
        }

        public MyClassOrPackageReference(@NotNull XmlTag tag, @NotNull ASTNode myNameElement, @NotNull TextRange myRangeInNameElement, @NotNull AndroidFacet facet2, @NotNull String myBaseClassQName, boolean myStartTag) {
            super((PsiElement)tag, true);
            this.myNameElement = myNameElement;
            this.myRangeInNameElement = myRangeInNameElement;
            this.facet = facet2;
            this.myBaseClassQName = myBaseClassQName;
            this.myStartTag = myStartTag;
            this.project = tag.getProject();
            String string = this.myNameElement.getText();
            int n = 0;
            int n2 = this.myRangeInNameElement.getStartOffset();
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            this.packagePrefix = string3;
            this.isParentContainer$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(tag){
                final /* synthetic */ XmlTag $tag;

                public final boolean invoke() {
                    PsiElement psiElement = this.$tag.getParent();
                    if (!(psiElement instanceof XmlTag)) {
                        psiElement = null;
                    }
                    XmlTag xmlTag = (XmlTag)psiElement;
                    Object object = xmlTag != null ? xmlTag.getDescriptor() : null;
                    if (!(object instanceof TagFromClassDescriptor)) {
                        object = null;
                    }
                    TagFromClassDescriptor tagFromClassDescriptor = (TagFromClassDescriptor)object;
                    if (tagFromClassDescriptor == null) {
                        return true;
                    }
                    TagFromClassDescriptor parentTagFromClassDescriptor = tagFromClassDescriptor;
                    return parentTagFromClassDescriptor.isContainer();
                }
                {
                    this.$tag = xmlTag;
                    super(0);
                }
            }));
        }

        public static final /* synthetic */ PsiElement access$resolveInner(MyClassOrPackageReference $this) {
            return $this.resolveInner();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/android/dom/AndroidXmlReferenceProvider$Companion;", "", "()V", "addReferences", "", "tag", "Lcom/intellij/psi/xml/XmlTag;", "nameElement", "Lcom/intellij/lang/ASTNode;", "result", "", "Lcom/intellij/psi/PsiReference;", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "baseClassQName", "", "startTag", "", "computeBaseClass", "intellij.android.core"})
    public static final class Companion {
        private final void addReferences(XmlTag tag, ASTNode nameElement, List<PsiReference> result2, AndroidFacet facet2, String baseClassQName, boolean startTag) {
            String text2 = nameElement.getText();
            List nameParts = StringsKt.split$default((CharSequence)text2, (String[])new String[]{"."}, (boolean)false, (int)0, (int)6, null);
            int offset2 = 0;
            for (String name : nameParts) {
                CharSequence charSequence = name;
                boolean bl = false;
                if (charSequence.length() > 0) {
                    TextRange range = new TextRange((offset2 += name.length()) - name.length(), offset2);
                    result2.add((PsiReference)new MyClassOrPackageReference(tag, nameElement, range, facet2, baseClassQName, startTag));
                }
                ++offset2;
            }
        }

        private final String computeBaseClass(XmlTag tag) {
            String string;
            DomElement domElement = DomManager.getDomManager((Project)tag.getProject()).getDomElement(tag);
            if (domElement instanceof LayoutViewElement && !(domElement instanceof View)) {
                string = "android.view.View";
            } else if (domElement instanceof PreferenceElement) {
                AndroidFacet androidFacet = ModuleExtensionsKt.getAndroidFacet((PsiElement)((PsiElement)tag));
                if (androidFacet == null) {
                    return null;
                }
                AndroidFacet facet2 = androidFacet;
                string = AndroidXmlResourcesUtil.PreferenceSource.getPreferencesSource(tag, facet2).getQualifiedBaseClass();
            } else {
                string = null;
            }
            return string;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

