/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom;

import com.android.sdklib.SdkVersionInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.xml.XmlElementDescriptorProvider;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DefinesXml;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.impl.dom.DomElementXmlDescriptor;
import icons.StudioIcons;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.android.dom.AndroidDomElement;
import org.jetbrains.android.dom.AndroidXmlTagDescriptor;
import org.jetbrains.android.dom.layout.DataBindingElement;
import org.jetbrains.android.dom.layout.LayoutElement;
import org.jetbrains.android.dom.layout.LayoutElementDescriptor;
import org.jetbrains.android.dom.layout.LayoutViewElement;
import org.jetbrains.android.dom.layout.LayoutViewElementDescriptor;
import org.jetbrains.android.dom.layout.View;
import org.jetbrains.android.dom.xml.AndroidXmlResourcesUtil;
import org.jetbrains.android.dom.xml.PreferenceElement;
import org.jetbrains.android.dom.xml.PreferenceElementDescriptor;
import org.jetbrains.android.facet.AndroidClassesForXmlUtilKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidDomElementDescriptorProvider
implements XmlElementDescriptorProvider {
    private static final Map<String, Ref<Icon>> ourViewTagName2Icon = ContainerUtil.createSoftMap();

    @Nullable
    private static XmlElementDescriptor getDescriptor(@NotNull DomElement domElement, @NotNull XmlTag tag) {
        XmlElementDescriptor domDescriptor;
        XmlElementDescriptor parentDescriptor;
        AndroidFacet facet2 = AndroidFacet.getInstance((DomElement)domElement);
        if (facet2 == null) {
            return null;
        }
        DefinesXml definesXml = (DefinesXml)domElement.getAnnotation(DefinesXml.class);
        if (definesXml != null) {
            return new AndroidXmlTagDescriptor((XmlElementDescriptor)new DomElementXmlDescriptor(domElement));
        }
        PsiElement parent = tag.getParent();
        if (parent instanceof XmlTag && (parentDescriptor = ((XmlTag)parent).getDescriptor()) instanceof AndroidXmlTagDescriptor && (domDescriptor = parentDescriptor.getElementDescriptor(tag, (XmlTag)parent)) != null) {
            return new AndroidXmlTagDescriptor(domDescriptor);
        }
        return null;
    }

    public XmlElementDescriptor getDescriptor(XmlTag tag) {
        DomElement element2 = DomManager.getDomManager((Project)tag.getProject()).getDomElement(tag);
        if (element2 instanceof LayoutElement) {
            return AndroidDomElementDescriptorProvider.createLayoutElementDescriptor((LayoutElement)element2, tag);
        }
        if (element2 instanceof PreferenceElement) {
            return AndroidDomElementDescriptorProvider.createPreferenceElementDescriptor((PreferenceElement)element2, tag);
        }
        if (element2 instanceof DataBindingElement) {
            return null;
        }
        if (element2 instanceof AndroidDomElement) {
            return AndroidDomElementDescriptorProvider.getDescriptor(element2, tag);
        }
        return null;
    }

    @Nullable
    public static PreferenceElementDescriptor createPreferenceElementDescriptor(@NotNull PreferenceElement element2, @NotNull XmlTag tag) {
        AndroidFacet facet2 = AndroidFacet.getInstance((DomElement)element2);
        if (facet2 == null) {
            return null;
        }
        String baseClass = AndroidXmlResourcesUtil.PreferenceSource.getPreferencesSource(tag, facet2).getQualifiedBaseClass();
        String baseGroupClass = AndroidXmlResourcesUtil.PreferenceSource.getPreferencesSource(tag, facet2).getQualifiedGroupClass();
        PsiClass preferenceClass = AndroidClassesForXmlUtilKt.findClassValidInXMLByName(facet2, tag.getName(), baseClass);
        return new PreferenceElementDescriptor(preferenceClass, (XmlElementDescriptor)new DomElementXmlDescriptor((DomElement)element2), baseGroupClass);
    }

    @Nullable
    public static LayoutElementDescriptor createLayoutElementDescriptor(@NotNull LayoutElement element2, @NotNull XmlTag tag) {
        if (element2 instanceof View) {
            PsiClass viewClass = (PsiClass)((View)element2).getViewClass().getValue();
            return new LayoutViewElementDescriptor(viewClass, (View)element2);
        }
        if (element2 instanceof LayoutViewElement) {
            AndroidFacet facet2 = AndroidFacet.getInstance((DomElement)element2);
            if (facet2 == null) {
                return null;
            }
            PsiClass viewClass = AndroidClassesForXmlUtilKt.findViewValidInXMLByName(facet2, tag.getName());
            return new LayoutViewElementDescriptor(viewClass, (LayoutViewElement)element2);
        }
        return new LayoutElementDescriptor((XmlElementDescriptor)new DomElementXmlDescriptor((DomElement)element2));
    }

    @Nullable
    public static Icon getIconForViewTag(@NotNull String tagName) {
        return AndroidDomElementDescriptorProvider.getIconForView(tagName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Icon getIconForView(@NotNull String keyName) {
        Map<String, Ref<Icon>> map2 = ourViewTagName2Icon;
        synchronized (map2) {
            Ref iconRef;
            if (ourViewTagName2Icon.isEmpty()) {
                Map<String, Icon> map3 = AndroidDomElementDescriptorProvider.getInitialViewTagName2IconMap();
                for (Map.Entry<String, Icon> entry : map3.entrySet()) {
                    ourViewTagName2Icon.put(entry.getKey(), (Ref<Icon>)Ref.create((Object)entry.getValue()));
                }
            }
            if ((iconRef = ourViewTagName2Icon.get(keyName)) == null) {
                Icon icon2 = IconLoader.findIcon((String)("StudioIcons.LayoutEditor.Palette." + AndroidDomElementDescriptorProvider.convertToPaletteIconName(keyName)));
                if (icon2 == null) {
                    icon2 = IconLoader.findIcon((String)("AndroidIcons.Views." + keyName));
                }
                iconRef = Ref.create((Object)icon2);
                ourViewTagName2Icon.put(keyName, (Ref<Icon>)iconRef);
            }
            return (Icon)iconRef.get();
        }
    }

    @NotNull
    private static String convertToPaletteIconName(@NotNull String tagName) {
        return StringUtil.toUpperCase((String)SdkVersionInfo.camelCaseToUnderlines((String)tagName));
    }

    @NotNull
    private static Map<String, Icon> getInitialViewTagName2IconMap() {
        HashMap<String, Icon> map2 = new HashMap<String, Icon>();
        map2.put("LinearLayout", StudioIcons.LayoutEditor.Palette.LINEAR_LAYOUT_HORZ);
        map2.put("MotionLayout", StudioIcons.LayoutEditor.Motion.MOTION_LAYOUT);
        map2.put("ImageFilterView", StudioIcons.LayoutEditor.Palette.IMAGE_VIEW);
        map2.put("ImageFilterButton", StudioIcons.LayoutEditor.Palette.IMAGE_BUTTON);
        map2.put("MockView", StudioIcons.LayoutEditor.Palette.PLACEHOLDER);
        return map2;
    }
}

