/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.diagnostics.error;

import com.android.tools.idea.project.AndroidProjectInfo;
import com.intellij.errorreport.bean.ErrorBean;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class IdeaITNProxy {
    public static List<Pair<String, String>> getKeyValuePairs(@Nullable String login, @Nullable String password, ErrorBean error, Application application, ApplicationInfoEx appInfo, ApplicationNamesInfo namesInfo, UpdateSettings updateSettings) {
        ArrayList<Pair<String, String>> params = new ArrayList<Pair<String, String>>();
        params.add(Pair.create((Object)"protocol.version", (Object)"1"));
        if (login != null) {
            params.add(Pair.create((Object)"user.login", (Object)login));
            params.add(Pair.create((Object)"user.password", (Object)password));
        }
        params.add(Pair.create((Object)"os.name", (Object)SystemInfo.OS_NAME));
        params.add(Pair.create((Object)"java.version", (Object)SystemInfo.JAVA_VERSION));
        params.add(Pair.create((Object)"java.vm.vendor", (Object)SystemInfo.JAVA_VENDOR));
        params.add(Pair.create((Object)"app.name", (Object)namesInfo.getProductName()));
        params.add(Pair.create((Object)"app.name.full", (Object)namesInfo.getFullProductName()));
        params.add(Pair.create((Object)"app.name.version", (Object)appInfo.getVersionName()));
        params.add(Pair.create((Object)"app.eap", (Object)Boolean.toString(appInfo.isEAP())));
        params.add(Pair.create((Object)"app.internal", (Object)Boolean.toString(application.isInternal())));
        params.add(Pair.create((Object)"app.build", (Object)appInfo.getBuild().asString()));
        params.add(Pair.create((Object)"app.version.major", (Object)appInfo.getMajorVersion()));
        params.add(Pair.create((Object)"app.version.minor", (Object)appInfo.getMinorVersion()));
        params.add(Pair.create((Object)"app.build.date", (Object)IdeaITNProxy.format(appInfo.getBuildDate())));
        params.add(Pair.create((Object)"app.build.date.release", (Object)IdeaITNProxy.format(appInfo.getMajorReleaseBuildDate())));
        params.add(Pair.create((Object)"update.channel.status", (Object)updateSettings.getSelectedChannelStatus().getCode()));
        params.add(Pair.create((Object)"update.ignored.builds", (Object)StringUtil.join((Collection)updateSettings.getIgnoredBuildNumbers(), (String)",")));
        params.add(Pair.create((Object)"plugin.name", (Object)error.getPluginName()));
        params.add(Pair.create((Object)"plugin.version", (Object)error.getPluginVersion()));
        params.add(Pair.create((Object)"last.action", (Object)error.getLastAction()));
        params.add(Pair.create((Object)"previous.exception", error.getPreviousException() == null ? null : Integer.toString(error.getPreviousException())));
        params.add(Pair.create((Object)"error.message", (Object)error.getMessage()));
        params.add(Pair.create((Object)"error.stacktrace", (Object)error.getStackTrace()));
        params.add(Pair.create((Object)"error.description", (Object)error.getDescription()));
        params.add(Pair.create((Object)"assignee.id", error.getAssigneeId() == null ? null : Integer.toString(error.getAssigneeId())));
        for (Attachment attachment : error.getAttachments()) {
            params.add(Pair.create((Object)"attachment.name", (Object)attachment.getName()));
            params.add((Pair<String, String>)Pair.create((Object)"attachment.value", (Object)attachment.getEncodedBytes()));
        }
        Project[] projects2 = ProjectManager.getInstance().getOpenProjects();
        for (int i2 = 0; i2 < projects2.length; ++i2) {
            params.add((Pair<String, String>)Pair.create((Object)("is.gradle.project." + i2), (Object)Boolean.toString(AndroidProjectInfo.getInstance(projects2[i2]).requiresAndroidModel())));
        }
        return params;
    }

    private static String format(Calendar calendar) {
        return calendar == null ? "" : Long.toString(calendar.getTime().getTime());
    }
}

