/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler.artifact;

import com.intellij.facet.Facet;
import com.intellij.facet.pointers.FacetPointer;
import com.intellij.facet.pointers.FacetPointersManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.elements.FacetBasedPackagingElement;
import com.intellij.packaging.impl.elements.ModuleOutputPackagingElement;
import com.intellij.packaging.impl.ui.DelegatedPackagingElementPresentation;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingElementPresentation;
import com.intellij.packaging.ui.TreeNodePresentation;
import com.intellij.util.xmlb.annotations.Attribute;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.android.compiler.artifact.AndroidFinalPackageElementType;
import org.jetbrains.android.compiler.artifact.AndroidFinalPackagePresentation;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidFinalPackageElement
extends PackagingElement<AndroidFinalPackageElementState>
implements FacetBasedPackagingElement,
ModuleOutputPackagingElement {
    @NonNls
    static final String FACET_ATTRIBUTE = "facet";
    private FacetPointer<AndroidFacet> myFacetPointer;
    private final Project myProject;

    public AndroidFinalPackageElement(@NotNull Project project, @Nullable AndroidFacet facet2) {
        super((PackagingElementType)AndroidFinalPackageElementType.getInstance());
        this.myProject = project;
        this.myFacetPointer = facet2 != null ? FacetPointersManager.getInstance((Project)this.myProject).create((Facet)facet2) : null;
    }

    @NotNull
    public PackagingElementPresentation createPresentation(@NotNull ArtifactEditorContext context) {
        return new DelegatedPackagingElementPresentation((TreeNodePresentation)new AndroidFinalPackagePresentation(this.myFacetPointer));
    }

    @Nullable
    public AndroidFacet getFacet() {
        return this.myFacetPointer != null ? (AndroidFacet)this.myFacetPointer.getFacet() : null;
    }

    public boolean isEqualTo(@NotNull PackagingElement<?> element2) {
        if (!(element2 instanceof AndroidFinalPackageElement)) {
            return false;
        }
        AndroidFinalPackageElement packageElement = (AndroidFinalPackageElement)element2;
        return this.myFacetPointer == null ? packageElement.myFacetPointer == null : this.myFacetPointer.equals(packageElement.myFacetPointer);
    }

    public AndroidFinalPackageElementState getState() {
        AndroidFinalPackageElementState state = new AndroidFinalPackageElementState();
        state.myFacetPointer = this.myFacetPointer != null ? this.myFacetPointer.getId() : null;
        return state;
    }

    public AndroidFacet findFacet(@NotNull PackagingElementResolvingContext context) {
        return this.myFacetPointer != null ? (AndroidFacet)this.myFacetPointer.findFacet(context.getModulesProvider(), context.getFacetsProvider()) : null;
    }

    public void loadState(@NotNull AndroidFinalPackageElementState state) {
        this.myFacetPointer = state.myFacetPointer != null ? FacetPointersManager.getInstance((Project)this.myProject).create(state.myFacetPointer) : null;
    }

    public String getModuleName() {
        return this.myFacetPointer != null ? this.myFacetPointer.getModuleName() : null;
    }

    public Module findModule(PackagingElementResolvingContext context) {
        AndroidFacet facet2 = this.findFacet(context);
        return facet2 != null ? facet2.getModule() : null;
    }

    @NotNull
    public Collection<VirtualFile> getSourceRoots(PackagingElementResolvingContext context) {
        return Collections.emptyList();
    }

    public static class AndroidFinalPackageElementState {
        @Attribute(value="facet")
        public String myFacetPointer;
    }
}

