/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler.artifact;

import com.intellij.facet.FacetModel;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.LibrarySourceItem;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.ModuleOutputSourceItem;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactProperties;
import com.intellij.packaging.artifacts.ArtifactPropertiesProvider;
import com.intellij.packaging.artifacts.ArtifactTemplate;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementOutputKind;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.ui.PackagingSourceItem;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.android.compiler.artifact.AndroidApplicationArtifactProperties;
import org.jetbrains.android.compiler.artifact.AndroidArtifactPropertiesProvider;
import org.jetbrains.android.compiler.artifact.AndroidArtifactUtil;
import org.jetbrains.android.compiler.artifact.AndroidFinalPackageElement;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NotNull;

public class AndroidApplicationArtifactType
extends ArtifactType {
    public AndroidApplicationArtifactType() {
        super("apk", "Android Application");
    }

    @NotNull
    public Icon getIcon() {
        return AllIcons.Nodes.Artifact;
    }

    public String getDefaultPathFor(@NotNull PackagingElementOutputKind kind) {
        return "/";
    }

    public boolean isSuitableItem(@NotNull PackagingSourceItem item) {
        return !(item instanceof ModuleOutputSourceItem) && !(item instanceof LibrarySourceItem);
    }

    @NotNull
    public CompositePackagingElement<?> createRootElement(@NotNull String artifactName) {
        return PackagingElementFactory.getInstance().createArchive(ArtifactUtil.suggestArtifactFileName((String)artifactName) + ".apk");
    }

    @NotNull
    public List<? extends ArtifactTemplate> getNewArtifactTemplates(@NotNull PackagingElementResolvingContext context) {
        ArrayList<AndroidFacet> facets = new ArrayList<AndroidFacet>();
        for (Module module2 : context.getModulesProvider().getModules()) {
            FacetModel facetModel = context.getModulesProvider().getFacetModel(module2);
            AndroidFacet facet2 = (AndroidFacet)facetModel.getFacetByType(AndroidFacet.ID);
            if (facet2 == null || !((AndroidFacetConfiguration)facet2.getConfiguration()).isAppProject()) continue;
            facets.add(facet2);
        }
        if (facets.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new MyTemplate(context.getProject(), facets));
    }

    public static ArtifactType getInstance() {
        return (ArtifactType)ContainerUtil.findInstance((Object[])AndroidApplicationArtifactType.getAllTypes(), AndroidApplicationArtifactType.class);
    }

    private class MyTemplate
    extends ArtifactTemplate {
        private final Project myProject;
        private final List<AndroidFacet> myFacets;

        private MyTemplate(@NotNull Project project, List<AndroidFacet> facets) {
            assert (!facets.isEmpty());
            this.myProject = project;
            this.myFacets = facets;
        }

        public String getPresentableName() {
            return this.myFacets.size() == 1 ? "From module '" + this.myFacets.get(0).getModule().getName() + "'" : "From module...";
        }

        public ArtifactTemplate.NewArtifactConfiguration createArtifact() {
            AndroidFacet facet2;
            AndroidFacet androidFacet = facet2 = this.myFacets.size() == 1 ? this.myFacets.get(0) : AndroidArtifactUtil.chooseAndroidApplicationModule(this.myProject, this.myFacets);
            if (facet2 == null) {
                return null;
            }
            CompositePackagingElement<?> rootElement = AndroidApplicationArtifactType.this.createRootElement(facet2.getModule().getName());
            rootElement.addFirstChild((PackagingElement)new AndroidFinalPackageElement(this.myProject, facet2));
            return new ArtifactTemplate.NewArtifactConfiguration(rootElement, facet2.getModule().getName(), (ArtifactType)AndroidApplicationArtifactType.this);
        }

        public void setUpArtifact(@NotNull Artifact artifact, @NotNull ArtifactTemplate.NewArtifactConfiguration configuration) {
            ArtifactProperties properties2;
            AndroidFacet facet2 = AndroidArtifactUtil.getPackagedFacet(this.myProject, artifact);
            if (facet2 != null && (properties2 = artifact.getProperties((ArtifactPropertiesProvider)AndroidArtifactPropertiesProvider.getInstance())) instanceof AndroidApplicationArtifactProperties) {
                AndroidApplicationArtifactProperties p = (AndroidApplicationArtifactProperties)properties2;
                p.setProGuardCfgFiles(facet2.getProperties().myProGuardCfgFiles);
            }
        }
    }
}

