/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler;

import com.intellij.compiler.CompilerIOUtil;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.compiler.ValidityState;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class ClassesAndJarsValidityState
implements ValidityState {
    private Map<String, Long> myFiles = new HashMap<String, Long>();

    private void fillMap(VirtualFile file2, Set<VirtualFile> visited) {
        if (file2.isDirectory() && visited.add(file2)) {
            for (VirtualFile child : file2.getChildren()) {
                this.fillMap(child, visited);
            }
        } else if ((JavaClassFileType.INSTANCE.equals(file2.getFileType()) || file2.getFileType() instanceof ArchiveFileType) && file2.isValid()) {
            this.myFiles.put(file2.getPath(), file2.getTimeStamp());
        }
    }

    public ClassesAndJarsValidityState(@NotNull Collection<VirtualFile> files2) {
        HashSet<VirtualFile> visited = new HashSet<VirtualFile>();
        for (VirtualFile file2 : files2) {
            this.fillMap(file2, visited);
        }
    }

    public ClassesAndJarsValidityState(@NotNull DataInput in) throws IOException {
        int size = in.readInt();
        while (size-- > 0) {
            String path2 = CompilerIOUtil.readString((DataInput)in);
            long timestamp = in.readLong();
            this.myFiles.put(path2, timestamp);
        }
    }

    public boolean equalsTo(ValidityState otherState) {
        return otherState instanceof ClassesAndJarsValidityState && this.myFiles.equals(((ClassesAndJarsValidityState)otherState).myFiles);
    }

    public void save(DataOutput out) throws IOException {
        out.writeInt(this.myFiles.size());
        for (String dependency : this.myFiles.keySet()) {
            CompilerIOUtil.writeString((String)dependency, (DataOutput)out);
            out.writeLong(this.myFiles.get(dependency));
        }
    }
}

