/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler;

import com.android.SdkConstants;
import com.android.sdklib.IAndroidTarget;
import com.intellij.facet.FacetManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.ClassPostProcessingCompiler;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.FileProcessingCompiler;
import com.intellij.openapi.compiler.ValidityState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.compiler.AndroidCompileUtil;
import org.jetbrains.android.compiler.AndroidDexCompilerConfiguration;
import org.jetbrains.android.compiler.ClassesAndJarsValidityState;
import org.jetbrains.android.compiler.tools.AndroidDxWrapper;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidDexCompiler
implements ClassPostProcessingCompiler {
    @NotNull
    public FileProcessingCompiler.ProcessingItem[] getProcessingItems(CompileContext context) {
        return (FileProcessingCompiler.ProcessingItem[])ApplicationManager.getApplication().runReadAction((Computable)new PrepareAction(context));
    }

    public FileProcessingCompiler.ProcessingItem[] process(CompileContext context, FileProcessingCompiler.ProcessingItem[] items2) {
        if (!AndroidCompileUtil.isFullBuild(context)) {
            return FileProcessingCompiler.ProcessingItem.EMPTY_ARRAY;
        }
        if (items2 != null && items2.length > 0) {
            context.getProgressIndicator().setText("Generating classes.dex...");
            return new ProcessAction(context, items2).compute();
        }
        return FileProcessingCompiler.ProcessingItem.EMPTY_ARRAY;
    }

    @NotNull
    public String getDescription() {
        return FileUtil.getNameWithoutExtension((String)SdkConstants.FN_DX);
    }

    public boolean validateConfiguration(CompileScope scope2) {
        return true;
    }

    public ValidityState createValidityState(DataInput in) throws IOException {
        return new MyValidityState(in);
    }

    public static VirtualFile getOutputDirectoryForDex(@NotNull Module module2) {
        return CompilerModuleExtension.getInstance((Module)module2).getCompilerOutputPath();
    }

    static void addModuleOutputDir(Collection<VirtualFile> files2, VirtualFile dir) {
        for (VirtualFile child : dir.getChildren()) {
            if (!child.isDirectory()) continue;
            files2.add(child);
        }
    }

    private static class MyValidityState
    extends ClassesAndJarsValidityState {
        private final String myAdditionalVmParams;
        private final int myMaxHeapSize;
        private final boolean myOptimize;

        public MyValidityState(@NotNull Collection<VirtualFile> files2, @NotNull String additionalVmParams, int maxHeapSize, boolean optimize) {
            super(files2);
            this.myAdditionalVmParams = additionalVmParams;
            this.myMaxHeapSize = maxHeapSize;
            this.myOptimize = optimize;
        }

        public MyValidityState(@NotNull DataInput in) throws IOException {
            super(in);
            this.myAdditionalVmParams = in.readUTF();
            this.myMaxHeapSize = in.readInt();
            this.myOptimize = in.readBoolean();
        }

        @Override
        public void save(DataOutput out) throws IOException {
            super.save(out);
            out.writeUTF(this.myAdditionalVmParams);
            out.writeInt(this.myMaxHeapSize);
            out.writeBoolean(this.myOptimize);
        }

        @Override
        public boolean equalsTo(ValidityState otherState) {
            if (!super.equalsTo(otherState)) {
                return false;
            }
            if (!(otherState instanceof MyValidityState)) {
                return false;
            }
            MyValidityState state = (MyValidityState)otherState;
            return state.myAdditionalVmParams.equals(this.myAdditionalVmParams) && state.myMaxHeapSize == this.myMaxHeapSize && state.myOptimize == this.myOptimize;
        }
    }

    private static final class DexItem
    implements FileProcessingCompiler.ProcessingItem {
        final Module myModule;
        final VirtualFile myClassDir;
        final IAndroidTarget myAndroidTarget;
        final Collection<VirtualFile> myFiles;
        final String myAdditionalVmParams;
        final int myMaxHeapSize;
        final boolean myOptimize;

        public DexItem(@NotNull Module module2, @NotNull VirtualFile classDir, @NotNull IAndroidTarget target, Collection<VirtualFile> files2, @NotNull String additionalVmParams, int maxHeapSize, boolean optimize) {
            this.myModule = module2;
            this.myClassDir = classDir;
            this.myAndroidTarget = target;
            this.myFiles = files2;
            this.myAdditionalVmParams = additionalVmParams;
            this.myMaxHeapSize = maxHeapSize;
            this.myOptimize = optimize;
        }

        @NotNull
        public VirtualFile getFile() {
            return this.myClassDir;
        }

        @Nullable
        public ValidityState getValidityState() {
            return new MyValidityState(this.myFiles, this.myAdditionalVmParams, this.myMaxHeapSize, this.myOptimize);
        }
    }

    private static final class ProcessAction
    implements Computable<FileProcessingCompiler.ProcessingItem[]> {
        private final CompileContext myContext;
        private final FileProcessingCompiler.ProcessingItem[] myItems;

        public ProcessAction(CompileContext context, FileProcessingCompiler.ProcessingItem[] items2) {
            this.myContext = context;
            this.myItems = items2;
        }

        public FileProcessingCompiler.ProcessingItem[] compute() {
            ArrayList<DexItem> results = new ArrayList<DexItem>(this.myItems.length);
            for (FileProcessingCompiler.ProcessingItem item : this.myItems) {
                if (!(item instanceof DexItem)) continue;
                DexItem dexItem = (DexItem)item;
                if (!AndroidCompileUtil.isModuleAffected(this.myContext, dexItem.myModule)) continue;
                String outputDirPath = FileUtil.toSystemDependentName((String)dexItem.myClassDir.getPath());
                String[] files2 = new String[dexItem.myFiles.size()];
                int i2 = 0;
                for (VirtualFile file2 : dexItem.myFiles) {
                    files2[i2++] = FileUtil.toSystemDependentName((String)file2.getPath());
                }
                Map<CompilerMessageCategory, List<String>> messages = AndroidCompileUtil.toCompilerMessageCategoryKeys(AndroidDxWrapper.execute(dexItem.myModule, dexItem.myAndroidTarget, outputDirPath, files2, dexItem.myAdditionalVmParams, dexItem.myMaxHeapSize, dexItem.myOptimize));
                this.addMessages(messages, dexItem.myModule);
                if (!messages.get(CompilerMessageCategory.ERROR).isEmpty()) continue;
                results.add(dexItem);
            }
            return results.toArray(FileProcessingCompiler.ProcessingItem.EMPTY_ARRAY);
        }

        private void addMessages(Map<CompilerMessageCategory, List<String>> messages, Module module2) {
            for (CompilerMessageCategory category : messages.keySet()) {
                List<String> messageList = messages.get(category);
                for (String message2 : messageList) {
                    this.myContext.addMessage(category, '[' + module2.getName() + "] " + message2, null, -1, -1);
                }
            }
        }
    }

    private static final class PrepareAction
    implements Computable<FileProcessingCompiler.ProcessingItem[]> {
        private final CompileContext myContext;

        public PrepareAction(CompileContext context) {
            this.myContext = context;
        }

        public FileProcessingCompiler.ProcessingItem[] compute() {
            AndroidDexCompilerConfiguration dexConfig = AndroidDexCompilerConfiguration.getInstance(this.myContext.getProject());
            Module[] modules = ModuleManager.getInstance((Project)this.myContext.getProject()).getModules();
            ArrayList<DexItem> items2 = new ArrayList<DexItem>();
            for (Module module2 : modules) {
                Set<VirtualFile> files2;
                boolean shouldRunProguard;
                AndroidFacet facet2 = (AndroidFacet)FacetManager.getInstance((Module)module2).getFacetByType(AndroidFacet.ID);
                if (facet2 == null || !((AndroidFacetConfiguration)facet2.getConfiguration()).isAppProject()) continue;
                VirtualFile dexOutputDir = AndroidDexCompiler.getOutputDirectoryForDex(module2);
                boolean bl = shouldRunProguard = AndroidCompileUtil.getProguardConfigFilePathIfShouldRun(facet2, this.myContext) != null;
                if (shouldRunProguard) {
                    VirtualFile obfuscatedSourcesJar = dexOutputDir.findChild("obfuscated_sources.jar");
                    if (obfuscatedSourcesJar == null) {
                        this.myContext.addMessage(CompilerMessageCategory.INFORMATION, "Dex won't be launched for module " + module2.getName() + " because file " + "obfuscated_sources.jar" + " doesn't exist", null, -1, -1);
                        continue;
                    }
                    files2 = Collections.singleton(obfuscatedSourcesJar);
                } else {
                    VirtualFile outputDirForTests;
                    CompilerModuleExtension extension = CompilerModuleExtension.getInstance((Module)module2);
                    VirtualFile outputDir = extension.getCompilerOutputPath();
                    if (outputDir == null) {
                        this.myContext.addMessage(CompilerMessageCategory.INFORMATION, "Dex won't be launched for module " + module2.getName() + " because it doesn't contain compiled files", null, -1, -1);
                        continue;
                    }
                    files2 = new HashSet<VirtualFile>();
                    AndroidDexCompiler.addModuleOutputDir(files2, outputDir);
                    files2.addAll(AndroidRootUtil.getExternalLibraries(module2));
                    for (VirtualFile file2 : AndroidRootUtil.getDependentModules(module2, outputDir)) {
                        if (file2.isDirectory()) {
                            AndroidDexCompiler.addModuleOutputDir(files2, file2);
                            continue;
                        }
                        files2.add(file2);
                    }
                    if (facet2.getProperties().PACK_TEST_CODE && (outputDirForTests = extension.getCompilerOutputPathForTests()) != null) {
                        AndroidDexCompiler.addModuleOutputDir(files2, outputDirForTests);
                    }
                }
                AndroidPlatform platform = AndroidPlatform.getInstance(module2);
                if (platform == null) {
                    this.myContext.addMessage(CompilerMessageCategory.ERROR, AndroidBundle.message("android.compilation.error.specify.platform", module2.getName()), null, -1, -1);
                    continue;
                }
                StringBuilder options2 = new StringBuilder(dexConfig.VM_OPTIONS);
                items2.add(new DexItem(module2, dexOutputDir, platform.getTarget(), files2, options2.toString(), dexConfig.MAX_HEAP_SIZE, dexConfig.OPTIMIZE));
            }
            return items2.toArray(FileProcessingCompiler.ProcessingItem.EMPTY_ARRAY);
        }
    }
}

