/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.augment;

import com.google.common.collect.ImmutableSet;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import org.jetbrains.android.augment.AndroidLightClassBase;
import org.jetbrains.annotations.NotNull;

public abstract class AndroidLightInnerClassBase
extends AndroidLightClassBase {
    @NotNull
    private final PsiClass myContainingClass;
    @NotNull
    protected final String myName;

    protected AndroidLightInnerClassBase(@NotNull PsiClass context, @NotNull String name) {
        super(context.getManager(), (Collection<String>)ImmutableSet.of((Object)"public", (Object)"static", (Object)"final"));
        this.myContainingClass = context;
        this.myName = name;
    }

    @Override
    public void checkAdd(@NotNull PsiElement element2) throws IncorrectOperationException {
        throw new IncorrectOperationException("Cannot add elements to R class");
    }

    @Override
    public PsiElement add(@NotNull PsiElement element2) throws IncorrectOperationException {
        return this.myContainingClass.add(element2);
    }

    @Override
    public PsiElement addBefore(@NotNull PsiElement element2, PsiElement anchor) throws IncorrectOperationException {
        return this.myContainingClass.addBefore(element2, anchor);
    }

    @Override
    public PsiElement addAfter(@NotNull PsiElement element2, PsiElement anchor) throws IncorrectOperationException {
        return this.myContainingClass.addAfter(element2, anchor);
    }

    public String getQualifiedName() {
        return this.myContainingClass.getQualifiedName() + '.' + this.myName;
    }

    @NotNull
    public PsiElement getNavigationElement() {
        return this.myContainingClass;
    }

    @NotNull
    public PsiClass getContainingClass() {
        return this.myContainingClass;
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    public PsiElement getParent() {
        return this.myContainingClass;
    }
}

