/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.AndroidStartupActivity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.util.Alarm;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.android.compiler.AndroidAutogeneratorMode;
import org.jetbrains.android.compiler.AndroidCompileUtil;
import org.jetbrains.android.compiler.ModuleSourceAutogenerating;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

class CreateAlarmForAutoGenerationAndroidStartupActivity
implements AndroidStartupActivity {
    CreateAlarmForAutoGenerationAndroidStartupActivity() {
    }

    @Override
    @UiThread
    public void runActivity(@NotNull Project project, @NotNull Disposable disposable2) {
        this.createAlarmForAutogeneration(project, disposable2);
    }

    private void createAlarmForAutogeneration(final Project project, Disposable rootDisposable) {
        final Alarm alarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, rootDisposable);
        alarm.addRequest(new Runnable(){

            @Override
            public void run() {
                if (!project.isOpen()) {
                    return;
                }
                DumbService service = DumbService.getInstance((Project)project);
                Map facetsToProcess = (Map)service.runReadActionInSmartMode(() -> CreateAlarmForAutoGenerationAndroidStartupActivity.this.checkGenerate(project));
                if (!facetsToProcess.isEmpty()) {
                    CreateAlarmForAutoGenerationAndroidStartupActivity.this.generate(project, facetsToProcess);
                }
                if (!alarm.isDisposed()) {
                    alarm.addRequest((Runnable)this, 2000);
                }
            }
        }, 2000);
    }

    private Map<AndroidFacet, Collection<AndroidAutogeneratorMode>> checkGenerate(@NotNull Project project) {
        if (project.isDisposed()) {
            return Collections.emptyMap();
        }
        HashMap<AndroidFacet, Collection<AndroidAutogeneratorMode>> facetsToProcess = new HashMap<AndroidFacet, Collection<AndroidAutogeneratorMode>>();
        for (Module module2 : ModuleManager.getInstance((Project)project).getModules()) {
            AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
            if (facet2 == null || !ModuleSourceAutogenerating.requiresAutoSourceGeneration(facet2)) continue;
            ModuleSourceAutogenerating autogenerator = ModuleSourceAutogenerating.getInstance(facet2);
            assert (autogenerator != null);
            EnumSet<AndroidAutogeneratorMode> modes = EnumSet.noneOf(AndroidAutogeneratorMode.class);
            for (AndroidAutogeneratorMode mode : AndroidAutogeneratorMode.values()) {
                if (!autogenerator.cleanRegeneratingState(mode) && !autogenerator.isGeneratedFileRemoved(mode)) continue;
                modes.add(mode);
            }
            if (modes.isEmpty()) continue;
            facetsToProcess.put(facet2, modes);
        }
        return facetsToProcess;
    }

    private void generate(@NotNull Project project, Map<AndroidFacet, Collection<AndroidAutogeneratorMode>> facetsToProcess) {
        TransactionGuard.getInstance().submitTransactionAndWait(() -> AndroidCompileUtil.createGenModulesAndSourceRoots(project, facetsToProcess.keySet()));
        for (Map.Entry<AndroidFacet, Collection<AndroidAutogeneratorMode>> entry : facetsToProcess.entrySet()) {
            AndroidFacet facet2 = entry.getKey();
            Collection<AndroidAutogeneratorMode> modes = entry.getValue();
            for (AndroidAutogeneratorMode mode : modes) {
                AndroidCompileUtil.doGenerate(facet2, mode);
            }
        }
    }
}

