/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.rendering.GutterIconCache;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.AndroidAnnotatorUtil;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AndroidResourceExternalAnnotatorBase
extends ExternalAnnotator<FileAnnotationInfo, Map<PsiElement, GutterIconRenderer>> {
    private static final Logger LOG = Logger.getInstance(AndroidResourceExternalAnnotatorBase.class);

    @Nullable
    public final FileAnnotationInfo collectInformation(@NotNull PsiFile file2, @NotNull Editor editor2, boolean hasErrors) {
        return this.collectInformation(file2, editor2);
    }

    @Nullable
    protected abstract FileAnnotationInfo collectInformation(@NotNull PsiFile var1, @NotNull Editor var2);

    @Nullable
    public final FileAnnotationInfo collectInformation(@NotNull PsiFile file2) {
        return null;
    }

    @Nullable
    public Map<PsiElement, GutterIconRenderer> doAnnotate(@NotNull FileAnnotationInfo fileAnnotationsInfo) {
        AndroidFacet facet2 = fileAnnotationsInfo.getFacet();
        Editor editor2 = fileAnnotationsInfo.getEditor();
        long timestamp = fileAnnotationsInfo.getTimestamp();
        Document document = editor2.getDocument();
        HashMap<PsiElement, GutterIconRenderer> rendererMap = new HashMap<PsiElement, GutterIconRenderer>();
        Configuration configuration = AndroidAnnotatorUtil.pickConfiguration(fileAnnotationsInfo.getFile(), facet2);
        if (configuration == null) {
            return null;
        }
        ResourceResolver resolver = configuration.getResourceResolver();
        for (FileAnnotationInfo.AnnotatableElement element2 : fileAnnotationsInfo.getElements()) {
            GutterIconRenderer gutterIconRenderer;
            ProgressManager.checkCanceled();
            if (editor2.isDisposed() || document.getModificationStamp() > timestamp) {
                return null;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Rendering icon for %s in %s.", element2.getResource(), fileAnnotationsInfo.getFile()));
            }
            if (element2.getResource() != null) {
                gutterIconRenderer = AndroidResourceExternalAnnotatorBase.getResourceGutterIconRender(element2.getResource(), element2.getPsiElement(), resolver, facet2, configuration);
            } else {
                assert (element2.getColor() != null);
                Color color = element2.getColor();
                gutterIconRenderer = new AndroidAnnotatorUtil.ColorRenderer(element2.getPsiElement(), color, resolver, null, true, configuration);
            }
            if (gutterIconRenderer == null) continue;
            rendererMap.put(element2.getPsiElement(), gutterIconRenderer);
        }
        return rendererMap;
    }

    @Nullable
    private static GutterIconRenderer getResourceGutterIconRender(@NotNull ResourceReference reference2, @NotNull PsiElement element2, @NotNull ResourceResolver resolver, @NotNull AndroidFacet facet2, @NotNull Configuration configuration) {
        ResourceType type = reference2.getResourceType();
        if (type == ResourceType.COLOR) {
            return AndroidResourceExternalAnnotatorBase.getColorGutterIconRenderer(resolver, reference2, facet2, element2, configuration);
        }
        assert (type == ResourceType.DRAWABLE || type == ResourceType.MIPMAP || type == ResourceType.ATTR);
        return AndroidResourceExternalAnnotatorBase.getDrawableGutterIconRenderer(element2, resolver, reference2, facet2, configuration);
    }

    @Nullable
    private static GutterIconRenderer getDrawableGutterIconRenderer(@NotNull PsiElement element2, @NotNull ResourceResolver resourceResolver2, @NotNull ResourceReference reference2, @NotNull AndroidFacet facet2, @NotNull Configuration configuration) {
        ResourceValue drawable = null;
        if (reference2.getResourceType() == ResourceType.ATTR) {
            ResourceValue resolvedAttribute = resourceResolver2.findItemInTheme(reference2);
            if (resolvedAttribute == null || resolvedAttribute.getValue() == null) {
                return null;
            }
            ResourceUrl resolvedAttributeUrl = ResourceUrl.parse((String)resolvedAttribute.getValue());
            if (resolvedAttributeUrl == null) {
                return null;
            }
            ResourceType resolvedAttributeType = resolvedAttributeUrl.type;
            if (resolvedAttributeType == ResourceType.DRAWABLE || resolvedAttributeType == ResourceType.MIPMAP) {
                drawable = resolvedAttribute;
            }
        } else if (reference2.getResourceType() == ResourceType.DRAWABLE || reference2.getResourceType() == ResourceType.MIPMAP) {
            drawable = resourceResolver2.getResolvedResource(reference2);
        }
        if (drawable == null) {
            return null;
        }
        VirtualFile bitmap = AndroidAnnotatorUtil.resolveDrawableFile(drawable, resourceResolver2, facet2);
        if ((bitmap = AndroidAnnotatorUtil.pickBestBitmap(bitmap)) != null) {
            GutterIconCache.getInstance().getIcon(bitmap, (RenderResources)resourceResolver2, facet2);
        }
        return new com.android.tools.idea.rendering.GutterIconRenderer(element2, resourceResolver2, facet2, bitmap, configuration);
    }

    @Nullable
    private static GutterIconRenderer getColorGutterIconRenderer(@NotNull ResourceResolver resourceResolver2, @NotNull ResourceReference reference2, @NotNull AndroidFacet facet2, @NotNull PsiElement element2, @NotNull Configuration configuration) {
        ResourceValue colorValue = resourceResolver2.getResolvedResource(reference2);
        Color color = IdeResourcesUtil.resolveColor((RenderResources)resourceResolver2, colorValue, facet2.getModule().getProject());
        if (color == null) {
            return null;
        }
        boolean withCustomColorPalette = AndroidAnnotatorUtil.getFileType(element2) == XmlFileType.INSTANCE;
        return new AndroidAnnotatorUtil.ColorRenderer(element2, color, resourceResolver2, reference2, withCustomColorPalette, configuration);
    }

    public void apply(@NotNull PsiFile file2, @NotNull Map<PsiElement, GutterIconRenderer> iconRendererMap, @NotNull AnnotationHolder holder) {
        iconRendererMap.forEach((k, v) -> {
            if (k.isValid()) {
                holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(k).gutterIconRenderer(v).create();
            }
        });
    }

    protected static class FileAnnotationInfo {
        @NotNull
        private final AndroidFacet myFacet;
        @NotNull
        private final PsiFile myFile;
        @NotNull
        private final Editor myEditor;
        private final long myTimestamp;
        @NotNull
        private final List<AnnotatableElement> myElements;

        public FileAnnotationInfo(@NotNull AndroidFacet facet2, @NotNull PsiFile file2, @NotNull Editor editor2) {
            this.myFacet = facet2;
            this.myFile = file2;
            this.myEditor = editor2;
            this.myTimestamp = this.myEditor.getDocument().getModificationStamp();
            this.myElements = new ArrayList<AnnotatableElement>();
        }

        @NotNull
        public AndroidFacet getFacet() {
            return this.myFacet;
        }

        @NotNull
        public PsiFile getFile() {
            return this.myFile;
        }

        @NotNull
        public List<AnnotatableElement> getElements() {
            return this.myElements;
        }

        @NotNull
        public Editor getEditor() {
            return this.myEditor;
        }

        public long getTimestamp() {
            return this.myTimestamp;
        }

        public static class AnnotatableElement {
            @Nullable
            private final ResourceReference myReference;
            @NotNull
            private final PsiElement myPsiElement;
            @Nullable
            private final Color myColor;

            public AnnotatableElement(@NotNull ResourceReference reference2, @NotNull PsiElement element2) {
                this.myReference = reference2;
                this.myPsiElement = element2;
                this.myColor = null;
            }

            AnnotatableElement(@NotNull Color color, @NotNull PsiElement element2) {
                this.myReference = null;
                this.myPsiElement = element2;
                this.myColor = color;
            }

            @Nullable
            public ResourceReference getResource() {
                return this.myReference;
            }

            @NotNull
            public PsiElement getPsiElement() {
                return this.myPsiElement;
            }

            @Nullable
            public Color getColor() {
                return this.myColor;
            }
        }
    }
}

