/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.whatsnew.assistant.actions;

import com.android.build.attribution.BuildAttributionStateReporter;
import com.android.build.attribution.ui.BuildAttributionUiManager;
import com.android.build.attribution.ui.analytics.BuildAttributionUiAnalytics;
import com.android.tools.idea.assistant.AssistActionHandler;
import com.android.tools.idea.assistant.datamodel.ActionData;
import com.android.tools.idea.gradle.project.ProjectStructure;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.project.build.invoker.TestCompileType;
import com.android.tools.idea.whatsnew.assistant.WhatsNewMetricsTracker;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.UtilKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/whatsnew/assistant/actions/BuildAnalyzerShowAction;", "Lcom/android/tools/idea/assistant/AssistActionHandler;", "()V", "getId", "", "handleAction", "", "actionData", "Lcom/android/tools/idea/assistant/datamodel/ActionData;", "project", "Lcom/intellij/openapi/project/Project;", "invokeProjectBuild", "Companion", "whats-new-assistant"})
public final class BuildAnalyzerShowAction
implements AssistActionHandler {
    @NotNull
    public static final String ACTION_KEY = "build.analyzer.show";
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public String getId() {
        return ACTION_KEY;
    }

    @Override
    public void handleAction(@NotNull ActionData actionData, @NotNull Project project) {
        WhatsNewMetricsTracker.getInstance().clickActionButton(project, ACTION_KEY);
        BuildAttributionUiManager buildAttributionUiManager = BuildAttributionUiManager.Companion.getInstance(project);
        if (buildAttributionUiManager.getStateReporter().currentState() == BuildAttributionStateReporter.State.REPORT_DATA_READY) {
            buildAttributionUiManager.openTab(BuildAttributionUiAnalytics.TabOpenEventSource.WNA_BUTTON);
        } else {
            this.invokeProjectBuild(project);
            buildAttributionUiManager.requestOpenTabWhenDataReady(BuildAttributionUiAnalytics.TabOpenEventSource.WNA_BUTTON);
        }
    }

    private final void invokeProjectBuild(Project project) {
        List modules = (List)ProjectStructure.getInstance(project).getLeafModules();
        GradleBuildInvoker.getInstance(project).assemble((Module[])UtilKt.toArray((Collection)modules, (Object[])Module.EMPTY_ARRAY), TestCompileType.ALL);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/idea/whatsnew/assistant/actions/BuildAnalyzerShowAction$Companion;", "", "()V", "ACTION_KEY", "", "whats-new-assistant"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

