/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.repository.Revision;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.repository.impl.meta.TypeDetails;
import com.android.repository.io.FileOpUtils;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.SdkVersionInfo;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.welcome.install.ComponentCategory;
import com.android.tools.idea.welcome.install.ComponentTreeNode;
import com.android.tools.idea.welcome.install.InstallContext;
import com.android.tools.idea.welcome.install.InstallableComponent;
import com.android.tools.idea.welcome.wizard.deprecated.InstallComponentsPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0003H\u0002J\b\u0010\u0016\u001a\u00020\bH\u0016J\b\u0010\u0017\u001a\u00020\bH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/idea/welcome/install/Platform;", "Lcom/android/tools/idea/welcome/install/InstallableComponent;", "name", "", "description", "myVersion", "Lcom/android/sdklib/AndroidVersion;", "myIsDefaultPlatform", "", "installUpdates", "(Ljava/lang/String;Ljava/lang/String;Lcom/android/sdklib/AndroidVersion;ZZ)V", "requiredSdkPackages", "", "getRequiredSdkPackages", "()Ljava/util/Collection;", "configure", "", "installContext", "Lcom/android/tools/idea/welcome/install/InstallContext;", "sdkHandler", "Lcom/android/sdklib/repository/AndroidSdkHandler;", "findLatestCompatibleBuildTool", "isOptionalForSdkLocation", "isSelectedByDefault", "Companion", "intellij.android.core"})
public final class Platform
extends InstallableComponent {
    private final AndroidVersion myVersion;
    private final boolean myIsDefaultPlatform;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    protected Collection<String> getRequiredSdkPackages() {
        List requests;
        block0: {
            requests = CollectionsKt.mutableListOf((Object[])new String[]{DetailsTypes.getPlatformPath((AndroidVersion)this.myVersion), DetailsTypes.getSourcesPath((AndroidVersion)this.myVersion)});
            String string = this.findLatestCompatibleBuildTool();
            if (string == null) break block0;
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            requests.add(it);
        }
        return requests;
    }

    private final String findLatestCompatibleBuildTool() {
        Revision revision = null;
        String path2 = null;
        for (RemotePackage remote : this.getRepositoryPackages().getRemotePackages().values()) {
            Revision testRevision;
            if (!StringsKt.startsWith$default((String)remote.getPath(), (String)"build-tools", (boolean)false, (int)2, null) || (testRevision = remote.getVersion()).getMajor() != this.myVersion.getApiLevel() || revision != null && testRevision.compareTo(revision) <= 0) continue;
            revision = testRevision;
            path2 = remote.getPath();
        }
        return path2;
    }

    @Override
    public void configure(@NotNull InstallContext installContext, @NotNull AndroidSdkHandler sdkHandler) {
    }

    @Override
    public boolean isOptionalForSdkLocation() {
        List locals = Platform.Companion.getInstalledPlatformVersions(this.sdkHandler);
        if (locals.isEmpty()) {
            return !this.myIsDefaultPlatform;
        }
        for (AndroidVersion androidVersion : locals) {
            int apiLevel = androidVersion.getApiLevel();
            if (this.myVersion.getFeatureLevel() != apiLevel) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSelectedByDefault() {
        return false;
    }

    public Platform(@NotNull String name, @NotNull String description2, @NotNull AndroidVersion myVersion, boolean myIsDefaultPlatform, boolean installUpdates) {
        super(name, description2, installUpdates, FileOpUtils.create());
        this.myVersion = myVersion;
        this.myIsDefaultPlatform = myIsDefaultPlatform;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0016\u0010\u0005\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J*\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0016\u0010\u0005\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/welcome/install/Platform$Companion;", "", "()V", "createSubtree", "Lcom/android/tools/idea/welcome/install/ComponentTreeNode;", "remotePackages", "", "", "Lcom/android/repository/api/RemotePackage;", "installUpdates", "", "getInstalledPlatformVersions", "", "Lcom/android/sdklib/AndroidVersion;", "handler", "Lcom/android/sdklib/repository/AndroidSdkHandler;", "getLatestPlatform", "Lcom/android/tools/idea/welcome/install/Platform;", "intellij.android.core"})
    public static final class Companion {
        private final Platform getLatestPlatform(Map<String, ? extends RemotePackage> remotePackages, boolean installUpdates) {
            RemotePackage latest = InstallComponentsPath.findLatestPlatform(remotePackages);
            if (latest != null) {
                TypeDetails typeDetails = latest.getTypeDetails();
                if (typeDetails == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.android.sdklib.repository.meta.DetailsTypes.PlatformDetailsType");
                }
                AndroidVersion version2 = ((DetailsTypes.PlatformDetailsType)typeDetails).getAndroidVersion();
                String versionName2 = SdkVersionInfo.getAndroidName((int)version2.getFeatureLevel());
                String description2 = "Android platform libraries for targeting " + versionName2 + " platform";
                return new Platform(versionName2, description2, version2, !version2.isPreview(), installUpdates);
            }
            return null;
        }

        private final List<AndroidVersion> getInstalledPlatformVersions(AndroidSdkHandler handler2) {
            boolean bl = false;
            List result2 = new ArrayList();
            if (handler2 != null) {
                RepositoryPackages packages = handler2.getSdkManager((ProgressIndicator)new StudioLoggerProgressIndicator(Platform.class)).getPackages();
                for (LocalPackage p : packages.getLocalPackages().values()) {
                    if (!(p.getTypeDetails() instanceof DetailsTypes.PlatformDetailsType)) continue;
                    TypeDetails typeDetails = p.getTypeDetails();
                    if (typeDetails == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.android.sdklib.repository.meta.DetailsTypes.PlatformDetailsType");
                    }
                    result2.add(((DetailsTypes.PlatformDetailsType)typeDetails).getAndroidVersion());
                }
            }
            return result2;
        }

        @Nullable
        public final ComponentTreeNode createSubtree(@Nullable Map<String, ? extends RemotePackage> remotePackages, boolean installUpdates) {
            Platform platform = this.getLatestPlatform(remotePackages, installUpdates);
            if (platform == null) {
                return null;
            }
            Platform latestPlatform = platform;
            return new ComponentCategory("Android SDK Platform", "SDK components for creating applications for different Android platforms", CollectionsKt.listOf((Object)latestPlatform));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

