/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.tools.idea.welcome.install.InstallationCancelledException;
import com.android.tools.idea.welcome.wizard.deprecated.ProgressStep;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.util.ThrowableComputable;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class InstallContext {
    @NotNull
    private final ProgressStep myProgressStep;

    public InstallContext(@NotNull File tempDirectory, @NotNull ProgressStep progressStep) {
        this.myProgressStep = progressStep;
    }

    public void checkCanceled() throws InstallationCancelledException {
        if (this.myProgressStep.isCanceled()) {
            throw new InstallationCancelledException();
        }
    }

    public void print(String message2, ConsoleViewContentType contentType) {
        this.myProgressStep.print(message2, contentType);
    }

    public <R, E extends Exception> R run(ThrowableComputable<R, E> operation, double progressRatio) throws E {
        Wrapper<R, E> wrapper = new Wrapper<R, E>(operation);
        this.myProgressStep.run(wrapper, progressRatio);
        return (R)((Wrapper)wrapper).getResult();
    }

    private static class Wrapper<R, E extends Exception>
    implements Runnable {
        private final ThrowableComputable<R, E> myRunnable;
        private volatile R myResult;
        private volatile E myException;

        public Wrapper(ThrowableComputable<R, E> runnable2) {
            this.myRunnable = runnable2;
        }

        @Override
        public void run() {
            try {
                this.myResult = this.myRunnable.compute();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                this.myException = e;
            }
        }

        private R getResult() throws E {
            if (this.myException != null) {
                throw this.myException;
            }
            return this.myResult;
        }
    }
}

