/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.impl.meta.TypeDetails;
import com.android.repository.io.FileOp;
import com.android.resources.Density;
import com.android.resources.ScreenOrientation;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.devices.Abi;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Storage;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.EmulatedProperties;
import com.android.sdklib.internal.avd.GpuMode;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.IdDisplay;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.sdklib.repository.targets.SystemImageManager;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.avdmanager.AvdOptionsModel;
import com.android.tools.idea.avdmanager.AvdWizardUtils;
import com.android.tools.idea.avdmanager.DeviceManagerConnection;
import com.android.tools.idea.avdmanager.SystemImageDescription;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.welcome.install.InstallContext;
import com.android.tools.idea.welcome.install.InstallableComponent;
import com.android.tools.idea.welcome.install.WizardException;
import com.android.tools.idea.welcome.wizard.deprecated.InstallComponentsPath;
import com.android.tools.idea.welcome.wizard.deprecated.ProgressStep;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \"2\u00020\u0001:\u0001\"B+\u0012\u0014\u0010\u0002\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u000eH\u0016J\b\u0010!\u001a\u00020\u0007H\u0016R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u00108TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006#"}, d2={"Lcom/android/tools/idea/welcome/install/AndroidVirtualDevice;", "Lcom/android/tools/idea/welcome/install/InstallableComponent;", "remotePackages", "", "", "Lcom/android/repository/api/RemotePackage;", "installUpdates", "", "fop", "Lcom/android/repository/io/FileOp;", "(Ljava/util/Map;ZLcom/android/repository/io/FileOp;)V", "myLatestVersion", "Lcom/android/sdklib/AndroidVersion;", "myProgressStep", "Lcom/android/tools/idea/welcome/wizard/deprecated/ProgressStep;", "requiredSdkPackages", "", "getRequiredSdkPackages", "()Ljava/util/Collection;", "configure", "", "installContext", "Lcom/android/tools/idea/welcome/install/InstallContext;", "sdkHandler", "Lcom/android/sdklib/repository/AndroidSdkHandler;", "createAvd", "Lcom/android/sdklib/internal/avd/AvdInfo;", "connection", "Lcom/android/tools/idea/avdmanager/AvdManagerConnection;", "getSystemImageDescription", "Lcom/android/tools/idea/avdmanager/SystemImageDescription;", "init", "progressStep", "isSelectedByDefault", "Companion", "intellij.android.core"})
public final class AndroidVirtualDevice
extends InstallableComponent {
    private ProgressStep myProgressStep;
    private AndroidVersion myLatestVersion;
    @NotNull
    private static final Logger LOG;
    private static final String DEFAULT_DEVICE_ID = "pixel_3a";
    private static final IdDisplay ID_ADDON_GOOGLE_API_IMG;
    private static final IdDisplay ID_VENDOR_GOOGLE;
    private static final Storage DEFAULT_RAM_SIZE;
    private static final Storage DEFAULT_HEAP_SIZE;
    private static final Set<String> ENABLED_HARDWARE;
    private static final Set<String> DISABLED_HARDWARE;
    public static final Companion Companion;

    private final SystemImageDescription getSystemImageDescription(AndroidSdkHandler sdkHandler) throws WizardException {
        Collection systemImages;
        StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(this.getClass());
        if (this.myLatestVersion == null) {
            throw (Throwable)new WizardException("Missing system image required for an AVD setup");
        }
        SystemImageManager systemImageManager = sdkHandler.getSystemImageManager((ProgressIndicator)progress);
        AndroidVersion androidVersion = this.myLatestVersion;
        if (androidVersion == null) {
            Intrinsics.throwNpe();
        }
        if ((systemImages = systemImageManager.lookup(ID_ADDON_GOOGLE_API_IMG, androidVersion, ID_VENDOR_GOOGLE)).isEmpty()) {
            throw (Throwable)new WizardException("Missing system image required for an AVD setup");
        }
        return new SystemImageDescription((ISystemImage)systemImages.iterator().next());
    }

    @VisibleForTesting
    @Nullable
    public final AvdInfo createAvd(@NotNull AvdManagerConnection connection, @NotNull AndroidSdkHandler sdkHandler) throws WizardException {
        File file2 = sdkHandler.getLocation();
        if (file2 == null) {
            Intrinsics.throwNpe();
        }
        Device d = AndroidVirtualDevice.Companion.getDevice(file2);
        SystemImageDescription systemImageDescription = this.getSystemImageDescription(sdkHandler);
        String cardSize = EmulatedProperties.DEFAULT_INTERNAL_STORAGE.toIniString();
        File hardwareSkinPath = AvdWizardUtils.pathToUpdatedSkins(d.getDefaultHardware().getSkinFile(), systemImageDescription, this.fileOp);
        String displayName = connection.uniquifyDisplayName(d.getDisplayName() + " " + systemImageDescription.getVersion() + " " + systemImageDescription.getAbiType());
        String internalName = AvdWizardUtils.cleanAvdName(connection, displayName, true);
        Abi abi = Abi.getEnum((String)systemImageDescription.getAbiType());
        boolean useRanchu = AvdManagerConnection.doesSystemImageSupportQemu2(systemImageDescription, this.fileOp);
        boolean supportsSmp = abi != null && abi.supportsMultipleCpuCores() && AvdWizardUtils.getMaxCpuCores() > 1;
        Map settings = AndroidVirtualDevice.Companion.getAvdSettings(internalName, d);
        if (useRanchu) {
            String string = "1";
            boolean bl = false;
            boolean bl2 = false;
            String string2 = string;
            String string3 = "hw.cpu.ncore";
            Map map2 = settings;
            boolean bl3 = false;
            boolean bl4 = supportsSmp;
            String string4 = !bl4 ? string : null;
            if (string4 == null) {
                string4 = String.valueOf(AvdWizardUtils.getMaxCpuCores());
            }
            map2.put(string3, string4);
        }
        return connection.createOrUpdateAvd(null, internalName, d, systemImageDescription, ScreenOrientation.PORTRAIT, false, cardSize, hardwareSkinPath, settings, true);
    }

    @Override
    @NotNull
    protected Collection<String> getRequiredSdkPackages() {
        boolean bl = false;
        List result2 = new ArrayList();
        if (this.myLatestVersion != null) {
            result2.add(DetailsTypes.getAddonPath((IdDisplay)ID_VENDOR_GOOGLE, (AndroidVersion)this.myLatestVersion, (IdDisplay)ID_ADDON_GOOGLE_API_IMG));
            result2.add(DetailsTypes.getSysImgPath((IdDisplay)ID_VENDOR_GOOGLE, (AndroidVersion)this.myLatestVersion, (IdDisplay)ID_ADDON_GOOGLE_API_IMG, (String)"x86"));
        }
        return result2;
    }

    @Override
    public void init(@NotNull ProgressStep progressStep) {
        this.myProgressStep = progressStep;
    }

    @Override
    public void configure(@NotNull InstallContext installContext, @NotNull AndroidSdkHandler sdkHandler) {
        ProgressStep progressStep = this.myProgressStep;
        if (progressStep == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myProgressStep");
        }
        if (progressStep == null) {
            Intrinsics.throwNpe();
        }
        progressStep.getProgressIndicator().setIndeterminate(true);
        ProgressStep progressStep2 = this.myProgressStep;
        if (progressStep2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myProgressStep");
        }
        if (progressStep2 == null) {
            Intrinsics.throwNpe();
        }
        progressStep2.getProgressIndicator().setText("Creating Android virtual device");
        installContext.print("Creating Android virtual device\n", ConsoleViewContentType.SYSTEM_OUTPUT);
        try {
            AvdInfo avdInfo = this.createAvd(AvdManagerConnection.getAvdManagerConnection(sdkHandler), sdkHandler);
            if (avdInfo == null) {
                throw (Throwable)new WizardException("Unable to create Android virtual device");
            }
            AvdInfo avd = avdInfo;
            String successMessage = "Android virtual device " + avd.getName() + " was successfully created\n";
            installContext.print(successMessage, ConsoleViewContentType.SYSTEM_OUTPUT);
        }
        catch (WizardException e) {
            LOG.error((Throwable)e);
            String failureMessage = "Unable to create a virtual device: " + e.getMessage() + '\n';
            installContext.print(failureMessage, ConsoleViewContentType.ERROR_OUTPUT);
        }
    }

    @Override
    public boolean isSelectedByDefault() {
        SystemImageDescription systemImageDescription;
        if (this.sdkHandler == null) {
            return false;
        }
        try {
            AndroidSdkHandler androidSdkHandler = this.sdkHandler;
            if (androidSdkHandler == null) {
                Intrinsics.throwNpe();
            }
            systemImageDescription = this.getSystemImageDescription(androidSdkHandler);
        }
        catch (WizardException e) {
            return true;
        }
        SystemImageDescription desired = systemImageDescription;
        AndroidSdkHandler androidSdkHandler = this.sdkHandler;
        if (androidSdkHandler == null) {
            Intrinsics.throwNpe();
        }
        AvdManagerConnection connection = AvdManagerConnection.getAvdManagerConnection(androidSdkHandler);
        List<AvdInfo> avds = connection.getAvds(false);
        for (AvdInfo avd : avds) {
            if (!Intrinsics.areEqual((Object)avd.getAbiType(), (Object)desired.getAbiType()) || !Intrinsics.areEqual((Object)avd.getAndroidVersion(), (Object)desired.getVersion())) continue;
            return false;
        }
        return true;
    }

    public AndroidVirtualDevice(@NotNull Map<String, ? extends RemotePackage> remotePackages, boolean installUpdates, @NotNull FileOp fop) {
        super("Android Virtual Device", "A preconfigured and optimized Android Virtual Device for app testing on the emulator. (Recommended)", installUpdates, fop);
        AndroidVersion androidVersion;
        RemotePackage latestInfo = InstallComponentsPath.findLatestPlatform(remotePackages);
        if (latestInfo != null) {
            TypeDetails typeDetails = latestInfo.getTypeDetails();
            if (typeDetails == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.android.sdklib.repository.meta.DetailsTypes.PlatformDetailsType");
            }
            androidVersion = ((DetailsTypes.PlatformDetailsType)typeDetails).getAndroidVersion();
        } else {
            androidVersion = null;
        }
        this.myLatestVersion = androidVersion;
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance(AndroidVirtualDevice.class);
        ID_ADDON_GOOGLE_API_IMG = IdDisplay.create((String)"google_apis", (String)"Google APIs");
        ID_VENDOR_GOOGLE = IdDisplay.create((String)"google", (String)"Google LLC");
        DEFAULT_RAM_SIZE = new Storage(1536L, Storage.Unit.MiB);
        DEFAULT_HEAP_SIZE = new Storage(256L, Storage.Unit.MiB);
        ENABLED_HARDWARE = (Set)ImmutableSet.of((Object)"hw.accelerometer", (Object)"hw.audioInput", (Object)"hw.battery", (Object)"hw.gps", (Object)"hw.keyboard", (Object)"hw.sensors.orientation", (Object[])new String[]{"hw.sensors.proximity", "hw.sdCard", "hw.gpu.enabled"});
        DISABLED_HARDWARE = SetsKt.setOf((Object[])new String[]{"hw.dPad", "hw.mainKeys", "hw.trackBall", "snapshot.present"});
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00152\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J4\u0010\u001c\u001a\u00020\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00152\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\"H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006#"}, d2={"Lcom/android/tools/idea/welcome/install/AndroidVirtualDevice$Companion;", "", "()V", "DEFAULT_DEVICE_ID", "", "DEFAULT_HEAP_SIZE", "Lcom/android/sdklib/devices/Storage;", "DEFAULT_RAM_SIZE", "DISABLED_HARDWARE", "", "ENABLED_HARDWARE", "ID_ADDON_GOOGLE_API_IMG", "Lcom/android/sdklib/repository/IdDisplay;", "kotlin.jvm.PlatformType", "ID_VENDOR_GOOGLE", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "getAvdSettings", "", "internalName", "device", "Lcom/android/sdklib/devices/Device;", "getDevice", "sdkPath", "Ljava/io/File;", "setStorageSizeKey", "", "result", "key", "size", "convertToMb", "", "intellij.android.core"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private final Device getDevice(File sdkPath) throws WizardException {
            List<Device> devices2 = DeviceManagerConnection.getDeviceManagerConnection(sdkPath).getDevices();
            for (Device device : devices2) {
                if (!Objects.equal((Object)device.getId(), (Object)AndroidVirtualDevice.DEFAULT_DEVICE_ID)) continue;
                return device;
            }
            throw (Throwable)new WizardException("No device definition with \"pixel_3a\" ID found");
        }

        private final Map<String, String> getAvdSettings(String internalName, Device device) {
            boolean bl = false;
            Map result2 = new HashMap();
            result2.put("hw.gpu.mode", GpuMode.AUTO.getGpuSetting());
            for (String key : ENABLED_HARDWARE) {
                result2.put(key, "yes");
            }
            for (String key : DISABLED_HARDWARE) {
                result2.put(key, "no");
            }
            for (String key : ImmutableSet.of((Object)"hw.camera.back", (Object)"hw.camera.front")) {
                result2.put(key, "emulated");
            }
            result2.put("hw.device.name", device.getId());
            result2.put("hw.device.manufacturer", device.getManufacturer());
            result2.put("runtime.network.latency", EmulatedProperties.DEFAULT_NETWORK_LATENCY.getAsParameter());
            result2.put("runtime.network.speed", EmulatedProperties.DEFAULT_NETWORK_SPEED.getAsParameter());
            result2.put("AvdId", internalName);
            result2.put("avd.ini.displayname", internalName);
            result2.put("hw.lcd.density", String.valueOf(Density.XXHIGH.getDpiValue()));
            this.setStorageSizeKey(result2, "hw.ramSize", DEFAULT_RAM_SIZE, true);
            this.setStorageSizeKey(result2, "vm.heapSize", DEFAULT_HEAP_SIZE, true);
            this.setStorageSizeKey(result2, "disk.dataPartition.size", EmulatedProperties.DEFAULT_INTERNAL_STORAGE, false);
            return result2;
        }

        private final void setStorageSizeKey(Map<String, String> result2, String key, Storage size, boolean convertToMb) {
            result2.put(key, AvdOptionsModel.toIniString(size, convertToMb));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

