/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.tools.adtui.common.AdtUiCursorType;
import com.android.tools.adtui.common.AdtUiCursorsProvider;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.Interaction;
import com.android.tools.idea.common.surface.InteractionEvent;
import com.android.tools.idea.common.surface.InteractionInputEvent;
import com.android.tools.idea.common.surface.MouseDraggedEvent;
import com.android.tools.idea.common.surface.MouseMovedEvent;
import com.android.tools.idea.common.surface.MousePressedEvent;
import com.android.tools.idea.common.surface.MouseReleasedEvent;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J \u0010\u0012\u001a\u00020\u000b\"\b\b\u0000\u0010\u0013*\u00020\u00142\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u0017\u001a\u00020\u000b\"\b\b\u0000\u0010\u0013*\u00020\u00142\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0015H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/uibuilder/surface/PanInteraction;", "Lcom/android/tools/idea/common/surface/Interaction;", "surface", "Lcom/android/tools/idea/common/surface/DesignSurface;", "(Lcom/android/tools/idea/common/surface/DesignSurface;)V", "isGrabbing", "", "startPoint", "Ljava/awt/Point;", "surfaceOriginalPosition", "begin", "", "event", "Lcom/android/tools/idea/common/surface/InteractionEvent;", "cancel", "commit", "getCursor", "Ljava/awt/Cursor;", "setupOriginalPoint", "T", "Ljava/awt/event/MouseEvent;", "Lcom/android/tools/idea/common/surface/InteractionInputEvent;", "update", "updateMouseScrollEvent", "intellij.android.designer"})
public final class PanInteraction
extends Interaction {
    private boolean isGrabbing;
    private Point surfaceOriginalPosition;
    private final Point startPoint;
    private final DesignSurface surface;

    @Override
    public void begin(@NotNull InteractionEvent event) {
        this.begin(event.getInfo().getX(), event.getInfo().getY(), event.getInfo().getModifiersEx());
        if (event instanceof MousePressedEvent) {
            this.setupOriginalPoint((InteractionInputEvent)event);
            this.isGrabbing = (event.getInfo().getModifiersEx() & 0xC00) > 0;
        }
    }

    private final <T extends MouseEvent> void setupOriginalPoint(InteractionInputEvent<? extends T> event) {
        MouseEvent mouseEvent = (MouseEvent)event.getEventObject();
        Point point = this.surface.getScrollPosition();
        if (point == null || (point = point.getLocation()) == null) {
            return;
        }
        this.surfaceOriginalPosition = point;
        this.startPoint.setLocation(mouseEvent.getXOnScreen(), mouseEvent.getYOnScreen());
    }

    @Override
    public void update(@NotNull InteractionEvent event) {
        block1: {
            InteractionEvent interactionEvent;
            block3: {
                block2: {
                    block0: {
                        interactionEvent = event;
                        if (!(interactionEvent instanceof MousePressedEvent)) break block0;
                        if ((event.getInfo().getModifiersEx() & 0xC00) <= 0) break block1;
                        this.setupOriginalPoint((InteractionInputEvent)event);
                        this.isGrabbing = true;
                        break block1;
                    }
                    if (!(interactionEvent instanceof MouseMovedEvent)) break block2;
                    this.updateMouseScrollEvent((InteractionInputEvent)event);
                    break block1;
                }
                if (!(interactionEvent instanceof MouseDraggedEvent)) break block3;
                this.updateMouseScrollEvent((InteractionInputEvent)event);
                break block1;
            }
            if (!(interactionEvent instanceof MouseReleasedEvent)) break block1;
            this.updateMouseScrollEvent((InteractionInputEvent)event);
        }
    }

    private final <T extends MouseEvent> void updateMouseScrollEvent(InteractionInputEvent<? extends T> event) {
        MouseEvent mouseEvent = (MouseEvent)event.getEventObject();
        if ((mouseEvent.getModifiersEx() & 0xC00) > 0) {
            this.isGrabbing = true;
            Point point = this.surfaceOriginalPosition;
            if (point == null) {
                return;
            }
            Point point2 = point;
            boolean bl = false;
            boolean bl2 = false;
            Point it = point2;
            boolean bl3 = false;
            Point newPosition = new Point(it);
            int screenX = mouseEvent.getXOnScreen();
            int screenY = mouseEvent.getYOnScreen();
            newPosition.translate(this.startPoint.x - screenX, this.startPoint.y - screenY);
            this.surface.setScrollPosition(newPosition);
        } else {
            this.isGrabbing = false;
        }
    }

    @Override
    public void commit(@NotNull InteractionEvent event) {
        this.end(event.getInfo().getX(), event.getInfo().getY(), event.getInfo().getModifiersEx());
    }

    @Override
    public void cancel(@NotNull InteractionEvent event) {
        this.cancel(event.getInfo().getX(), event.getInfo().getY(), event.getInfo().getModifiersEx());
    }

    @Override
    @Nullable
    public Cursor getCursor() {
        return AdtUiCursorsProvider.Companion.getInstance().getCursor(this.isGrabbing ? AdtUiCursorType.GRABBING : AdtUiCursorType.GRAB);
    }

    public PanInteraction(@NotNull DesignSurface surface2) {
        this.surface = surface2;
        this.surfaceOriginalPosition = new Point();
        this.startPoint = new Point();
    }
}

