/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.internal.annotations.VisibleForTesting;
import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.ui.designer.overlays.OverlayConfiguration;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import org.jetbrains.annotations.NotNull;

public class OverlayLayer
extends Layer {
    private static final String PLACEHOLDER_TEXT = "Loading Overlay...";
    private static final float PLACEHOLDER_ALPHA = 0.7f;
    private final SceneView mySceneView;
    private Dimension myScreenViewSize = new Dimension();

    public OverlayLayer(SceneView sceneView) {
        this.mySceneView = sceneView;
    }

    @VisibleForTesting
    static float getPlaceholderAlpha() {
        return 0.7f;
    }

    @VisibleForTesting
    static String getPlaceholderText() {
        return PLACEHOLDER_TEXT;
    }

    private void paintPlaceholder(Graphics2D g) {
        g.setComposite(AlphaComposite.SrcOver.derive(0.7f));
        g.setPaint((Paint)JBColor.WHITE);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        if (this.mySceneView.getScreenShape() != null) {
            g.fill(this.mySceneView.getScreenShape());
        } else {
            g.fillRect(this.mySceneView.getX(), this.mySceneView.getY(), this.myScreenViewSize.width, this.myScreenViewSize.height);
        }
        g.setFont(UIUtil.getFont((UIUtil.FontSize)UIUtil.FontSize.NORMAL, null));
        g.setPaint((Paint)JBColor.BLACK);
        TextLayout textLayout = new TextLayout(PLACEHOLDER_TEXT, g.getFont(), g.getFontRenderContext());
        double textHeight = textLayout.getBounds().getHeight();
        double textWidth = textLayout.getBounds().getWidth();
        g.drawString(PLACEHOLDER_TEXT, this.mySceneView.getX() + this.myScreenViewSize.width / 2 - (int)textWidth / 2, this.mySceneView.getY() + this.myScreenViewSize.height / 2 + (int)textHeight / 2);
    }

    private void paintOverlay(Graphics2D g, BufferedImage image) {
        OverlayConfiguration overlayConfiguration = this.mySceneView.getSurface().getOverlayConfiguration();
        if (image == null) {
            return;
        }
        g.setComposite(AlphaComposite.SrcOver.derive(overlayConfiguration.getOverlayAlpha()));
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.drawImage(image, this.mySceneView.getX(), this.mySceneView.getY(), this.myScreenViewSize.width, this.myScreenViewSize.height, null);
    }

    @Override
    public void paint(@NotNull Graphics2D g) {
        OverlayConfiguration overlayConfiguration = this.mySceneView.getSurface().getOverlayConfiguration();
        if (overlayConfiguration.getOverlayVisibility()) {
            this.myScreenViewSize = this.mySceneView.getScaledContentSize(this.myScreenViewSize);
            if (overlayConfiguration.isPlaceholderVisible()) {
                this.paintPlaceholder(g);
            } else {
                this.paintOverlay(g, overlayConfiguration.getOverlayImage());
            }
        }
    }
}

