/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.uibuilder.surface.ScreenViewBase;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import org.jetbrains.annotations.NotNull;

public class BorderLayer
extends Layer {
    private final ScreenViewBase myScreenView;

    public BorderLayer(@NotNull ScreenViewBase screenView) {
        this.myScreenView = screenView;
    }

    @Override
    public void paint(@NotNull Graphics2D g2d) {
        Shape screenShape = this.myScreenView.getScreenShape();
        if (screenShape != null) {
            g2d.draw(screenShape);
            return;
        }
        BorderPainter.paint(g2d, this.myScreenView);
    }

    private static class BorderPainter {
        private static final int SHADOW_SIZE = JBUI.scale((int)4);
        private static final Color COLOR_OUTSIDE = UIUtil.TRANSPARENT_COLOR;
        private static final Color COLOR_INSIDE = JBColor.namedColor((String)"ScreenView.borderColor", (Color)new JBColor(new Color(0, 0, 0, 40), new Color(0, 0, 0, 80)));
        private static final Paint GRAD_LEFT = new GradientPaint(0.0f, 0.0f, COLOR_OUTSIDE, SHADOW_SIZE, 0.0f, COLOR_INSIDE);
        private static final Paint GRAD_TOP = new GradientPaint(0.0f, 0.0f, COLOR_OUTSIDE, 0.0f, SHADOW_SIZE, COLOR_INSIDE);
        private static final Paint GRAD_RIGHT = new GradientPaint(0.0f, 0.0f, COLOR_INSIDE, SHADOW_SIZE, 0.0f, COLOR_OUTSIDE);
        private static final Paint GRAD_BOTTOM = new GradientPaint(0.0f, 0.0f, COLOR_INSIDE, 0.0f, SHADOW_SIZE, COLOR_OUTSIDE);
        private static final Paint GRAD_CORNER = new RadialGradientPaint(SHADOW_SIZE, (float)SHADOW_SIZE, SHADOW_SIZE, new float[]{0.0f, 1.0f}, new Color[]{COLOR_INSIDE, COLOR_OUTSIDE});

        private BorderPainter() {
        }

        public static void paint(@NotNull Graphics2D g2d, @NotNull SceneView screenView) {
            Dimension size = screenView.getScaledContentSize();
            int x = screenView.getX();
            int y = screenView.getY();
            RenderingHints hints = g2d.getRenderingHints();
            AffineTransform tx = g2d.getTransform();
            Paint paint = g2d.getPaint();
            g2d.translate(x - SHADOW_SIZE, y);
            g2d.scale(1.0, (double)size.height / (double)SHADOW_SIZE);
            g2d.setPaint(GRAD_LEFT);
            g2d.fillRect(0, 0, SHADOW_SIZE, SHADOW_SIZE);
            g2d.translate(size.width + SHADOW_SIZE, 0);
            g2d.setPaint(GRAD_RIGHT);
            g2d.fillRect(0, 0, SHADOW_SIZE, SHADOW_SIZE);
            g2d.translate(-size.width, 0);
            g2d.scale(1.0, (double)SHADOW_SIZE / (double)size.height);
            g2d.translate(0, -SHADOW_SIZE);
            g2d.scale((double)size.width / (double)SHADOW_SIZE, 1.0);
            g2d.setPaint(GRAD_TOP);
            g2d.fillRect(0, 0, SHADOW_SIZE, SHADOW_SIZE);
            g2d.translate(0, size.height + SHADOW_SIZE);
            g2d.setPaint(GRAD_BOTTOM);
            g2d.fillRect(0, 0, SHADOW_SIZE, SHADOW_SIZE);
            g2d.setTransform(tx);
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setPaint(GRAD_CORNER);
            g2d.translate(x - SHADOW_SIZE, y - SHADOW_SIZE);
            g2d.fillArc(0, 0, SHADOW_SIZE * 2, SHADOW_SIZE * 2, 90, 90);
            g2d.translate(size.width, 0);
            g2d.fillArc(0, 0, SHADOW_SIZE * 2, SHADOW_SIZE * 2, 0, 90);
            g2d.translate(0, size.height);
            g2d.fillArc(0, 0, SHADOW_SIZE * 2, SHADOW_SIZE * 2, 270, 90);
            g2d.translate(-size.width, 0);
            g2d.fillArc(0, 0, SHADOW_SIZE * 2, SHADOW_SIZE * 2, 180, 90);
            g2d.setTransform(tx);
            g2d.setRenderingHints(hints);
            g2d.setPaint(paint);
        }
    }
}

