/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.structure;

import com.android.tools.idea.common.editor.ActionUtils;
import com.android.tools.idea.common.model.ModelListener;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.SelectionListener;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.DesignSurfaceListener;
import com.android.tools.idea.uibuilder.actions.ComponentHelpAction;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.graphics.NlConstants;
import com.android.tools.idea.uibuilder.handlers.motion.MotionUtils;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.structure.DelegatedTreeEvent;
import com.android.tools.idea.uibuilder.structure.NlComponentTreeModel;
import com.android.tools.idea.uibuilder.structure.NlDropListener;
import com.android.tools.idea.uibuilder.structure.NlTreeBadgeHandler;
import com.android.tools.idea.uibuilder.structure.NlTreeCellRenderer;
import com.android.tools.idea.uibuilder.structure.NlTreeReferencedItemHelperKt;
import com.android.tools.idea.uibuilder.structure.NlTreeUtil;
import com.android.tools.idea.uibuilder.structure.NlVisibilityGutterPanel;
import com.android.tools.idea.uibuilder.structure.SelectedComponent;
import com.android.tools.idea.uibuilder.structure.TreeSearchUtil;
import com.android.tools.idea.uibuilder.structure.TreeTransferHandler;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.ui.laf.darcula.ui.DarculaTreeUI;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Alarm;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.dnd.DropTarget;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.TreeUI;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlComponentTree
extends Tree
implements DesignSurfaceListener,
ModelListener,
SelectionListener,
Disposable,
DataProvider {
    private static final int UPDATE_DELAY_MSECS = 250;
    private final AtomicBoolean mySelectionIsUpdating;
    private final MergingUpdateQueue myUpdateQueue;
    private final NlTreeBadgeHandler myBadgeHandler;
    private final NlVisibilityGutterPanel myVisibilityGutterPanel;
    @Nullable
    private NlModel myModel;
    private boolean mySkipWait;
    private int myInsertAfterRow = -1;
    private int myRelativeDepthToInsertionRow = 0;
    private Color lineColor = ColorUtil.brighter((Color)UIUtil.getTreeSelectionBackground((boolean)true), (int)10);
    @Nullable
    private Rectangle myInsertionRowBounds;
    @Nullable
    private Rectangle myInsertionReceiverBounds;
    @Nullable
    private NlDesignSurface mySurface;

    public NlComponentTree(@NotNull Project project, @Nullable NlDesignSurface designSurface, NlVisibilityGutterPanel visibilityGutter) {
        this.mySelectionIsUpdating = new AtomicBoolean(false);
        this.myUpdateQueue = new MergingUpdateQueue("android.layout.structure-pane", 250, true, null, null, null, Alarm.ThreadToUse.SWING_THREAD);
        this.myBadgeHandler = new NlTreeBadgeHandler();
        this.setUI((TreeUI)((Object)new MyUI()));
        this.setModel(new NlComponentTreeModel());
        this.setDesignSurface(designSurface);
        this.setName("componentTree");
        this.setRootVisible(true);
        this.setToggleClickCount(2);
        this.setCellRenderer(new NlTreeCellRenderer(this.myBadgeHandler));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                NlComponentTree.this.invalidateUI();
            }
        });
        this.getSelectionModel().setSelectionMode(4);
        ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this));
        TreeUtil.installActions((JTree)((Object)this));
        this.addTreeSelectionListener(new StructurePaneSelectionListener());
        new StructureSpeedSearch(this);
        this.enableDnD();
        this.addMouseListener(new StructurePaneMouseListener());
        this.addMouseListener(this.myBadgeHandler.getBadgeMouseAdapter());
        this.addMouseMotionListener(this.myBadgeHandler.getBadgeMouseAdapter());
        ComponentHelpAction help2 = new ComponentHelpAction(project, () -> {
            List<NlComponent> components = this.getSelectedComponents();
            return !components.isEmpty() ? components.get(0).getTagName() : null;
        });
        help2.registerCustomShortcutSet(112, 1, (JComponent)((Object)this));
        this.myVisibilityGutterPanel = visibilityGutter;
        this.addTreeExpansionListener(this.myVisibilityGutterPanel);
    }

    private void enableDnD() {
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            this.setDragEnabled(true);
            this.setTransferHandler(new TreeTransferHandler());
            this.setDropTarget(new DropTarget((Component)((Object)this), new NlDropListener(this)));
        }
    }

    public void setDesignSurface(@Nullable NlDesignSurface designSurface) {
        if (this.mySurface != null) {
            this.mySurface.getSelectionModel().removeListener(this);
            this.mySurface.removeListener(this);
        }
        this.mySurface = designSurface;
        if (this.mySurface != null) {
            this.mySurface.getSelectionModel().addListener(this);
            this.mySurface.getActionManager().registerActionsShortcuts((JComponent)((Object)this));
            this.mySurface.addListener(this);
            this.overrideCtrlClick();
        }
        this.setModel(designSurface != null ? designSurface.getModel() : null);
        this.myBadgeHandler.setIssueModel(designSurface != null ? designSurface.getIssueModel() : null);
        this.myBadgeHandler.setIssuePanel(designSurface != null ? designSurface.getIssuePanel() : null);
    }

    private void overrideCtrlClick() {
        int modifier2 = SystemInfo.isMac ? 4 : 2;
        MouseShortcut ctrlClickShortcut = new MouseShortcut(1, modifier2, 1);
        ImmutableList actions2 = ImmutableList.copyOf((Collection)ActionUtil.getActions((JComponent)((Object)this)));
        for (AnAction action2 : actions2) {
            Shortcut[] shortcuts = action2.getShortcutSet().getShortcuts();
            Shortcut existingShortcut = null;
            for (Shortcut shortcut : shortcuts) {
                if (!shortcut.equals(ctrlClickShortcut)) continue;
                existingShortcut = shortcut;
                action2.unregisterCustomShortcutSet((JComponent)((Object)this));
                break;
            }
            if (existingShortcut == null) continue;
            ArrayList<Shortcut> newShortcuts = new ArrayList<Shortcut>(shortcuts.length - 1);
            for (Shortcut shortcut : shortcuts) {
                if (shortcut == existingShortcut) continue;
                newShortcuts.add(shortcut);
            }
            action2.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(newShortcuts.toArray(Shortcut.EMPTY_ARRAY)), (JComponent)((Object)this));
        }
    }

    @NotNull
    @VisibleForTesting
    public MergingUpdateQueue getUpdateQueue() {
        return this.myUpdateQueue;
    }

    @Nullable
    public Scene getScene() {
        return this.mySurface != null ? this.mySurface.getScene() : null;
    }

    private void setModel(@Nullable NlModel model2, boolean forceUpdate) {
        if (!forceUpdate && model2 == this.myModel) {
            return;
        }
        if (this.myModel != null) {
            this.myModel.removeListener(this);
        }
        this.myModel = model2;
        this.myBadgeHandler.setNlModel(this.myModel);
        if (this.myModel != null) {
            this.myModel.addListener(this);
        }
        this.updateHierarchy();
    }

    private void setModel(@Nullable NlModel model2) {
        this.setModel(model2, false);
    }

    @Nullable
    public NlModel getDesignerModel() {
        return this.myModel;
    }

    public void dispose() {
        this.setDesignSurface(null);
        if (this.myModel != null) {
            this.myModel.removeListener(this);
            this.myModel = null;
        }
        ToolTipManager.sharedInstance().unregisterComponent((JComponent)((Object)this));
        Disposer.dispose((Disposable)this.myUpdateQueue);
    }

    public void updateUI() {
        this.setUI((TreeUI)((Object)new MyUI()));
        this.setBorder(new EmptyBorder((Insets)new JBInsets(0, 6, 0, 6)));
        this.lineColor = ColorUtil.brighter((Color)UIUtil.getTreeSelectionBackground((boolean)true), (int)10);
        if (this.myBadgeHandler != null) {
            this.setCellRenderer(new NlTreeCellRenderer(this.myBadgeHandler));
        }
    }

    private void invalidateUI() {
        ((MyUI)((Object)this.ui)).invalidateNodeSize();
        this.repaint();
    }

    private void updateHierarchy() {
        this.clearInsertionPoint();
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myUpdateQueue.queue(new Update("updateComponentStructure"){

            public void run() {
                try {
                    if (NlComponentTree.this.myModel == null) {
                        return;
                    }
                    NlComponentTree.this.mySelectionIsUpdating.set(true);
                    NlComponentTree.this.getSelectionModel().setSelectionMode(MotionUtils.getTreeSelectionModel(NlComponentTree.this.myModel));
                    List expandedPaths = TreeUtil.collectExpandedPaths((JTree)((Object)NlComponentTree.this));
                    Object oldRoot = NlComponentTree.this.treeModel.getRoot();
                    NlComponentTree.this.setModel(new NlComponentTreeModel(NlComponentTree.this.myModel));
                    if (oldRoot == NlComponentTree.this.treeModel.getRoot()) {
                        TreeUtil.restoreExpandedPaths((JTree)((Object)NlComponentTree.this), (List)expandedPaths);
                    } else {
                        TreeUtil.expandAll((JTree)((Object)NlComponentTree.this));
                    }
                    NlComponentTree.this.invalidateUI();
                }
                finally {
                    NlComponentTree.this.mySelectionIsUpdating.set(false);
                }
                NlComponentTree.this.updateSelection();
            }
        });
        if (this.mySkipWait) {
            this.mySkipWait = false;
            this.myUpdateQueue.flush();
        }
    }

    void skipNextUpdateDelay() {
        this.mySkipWait = true;
    }

    private void updateSelection() {
        this.myVisibilityGutterPanel.update((JTree)((Object)this));
        if (!this.mySelectionIsUpdating.compareAndSet(false, true)) {
            return;
        }
        try {
            this.clearSelection();
            if (this.mySurface != null) {
                for (NlComponent component : this.mySurface.getSelectionModel().getSelection()) {
                    this.addSelectionPath(NlComponentTree.newTreePath(component));
                }
            }
        }
        finally {
            this.mySelectionIsUpdating.set(false);
        }
    }

    @NotNull
    private static TreePath newTreePath(@NotNull NlComponent component) {
        ArrayList<NlComponent> components = new ArrayList<NlComponent>();
        components.add(component);
        for (NlComponent parent = component.getParent(); parent != null; parent = parent.getParent()) {
            components.add(parent);
        }
        Collections.reverse(components);
        return new TreePath(components.toArray());
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.myInsertAfterRow >= 0) {
            this.paintInsertionPoint((Graphics2D)g);
        }
        this.myBadgeHandler.paintBadges((Graphics2D)g, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintInsertionPoint(@NotNull Graphics2D g2D) {
        if (this.myInsertionReceiverBounds == null || this.myInsertionRowBounds == null) {
            return;
        }
        RenderingHints savedHints = g2D.getRenderingHints();
        Color savedColor = g2D.getColor();
        try {
            g2D.setColor(this.lineColor);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            NlComponentTree.paintInsertionRectangle(g2D, this.getX(), this.myInsertionReceiverBounds.y, this.getWidth(), this.myInsertionReceiverBounds.height);
            NlComponentTree.paintColumnLine(g2D, this.myInsertionReceiverBounds.x, this.myInsertionReceiverBounds.y + this.myInsertionReceiverBounds.height, this.myInsertionRowBounds.y + this.myInsertionRowBounds.height);
            NlComponentTree.paintInsertionLine(g2D, this.myInsertionReceiverBounds.x, this.myInsertionRowBounds.y + this.myInsertionRowBounds.height, this.getWidth());
        }
        finally {
            g2D.setRenderingHints(savedHints);
            g2D.setColor(savedColor);
        }
    }

    private static void paintInsertionLine(@NotNull Graphics2D g, int x, int y, int width) {
        Polygon triangle = new Polygon();
        int indicatorSize = JBUI.scale((int)6);
        triangle.addPoint((x += JBUI.scale((int)6)) + indicatorSize, y);
        triangle.addPoint(x, y + indicatorSize / 2);
        triangle.addPoint(x, y - indicatorSize / 2);
        Stroke stroke = g.getStroke();
        g.drawLine(x, y, x + width, y);
        g.setStroke(stroke);
        g.drawPolygon(triangle);
        g.fillPolygon(triangle);
    }

    private static void paintColumnLine(@NotNull Graphics2D g, int x, int y1, int y2) {
        Stroke stroke = g.getStroke();
        g.setStroke(NlConstants.DASHED_STROKE);
        g.drawLine(x, y1, x, y2);
        g.drawLine(x, y2, x, y2);
        g.setStroke(stroke);
    }

    private static void paintInsertionRectangle(@NotNull Graphics2D g, int x, int y, int width, int height) {
        g.drawRect(x += JBUI.scale((int)1), y += JBUI.scale((int)1), width -= JBUI.scale((int)3), height -= JBUI.scale((int)4));
    }

    public void markInsertionPoint(int row, int relativeDepth) {
        if (row == this.myInsertAfterRow && relativeDepth == this.myRelativeDepthToInsertionRow) {
            return;
        }
        if (row < 0) {
            this.clearInsertionPoint();
            return;
        }
        this.myInsertAfterRow = row;
        this.myRelativeDepthToInsertionRow = relativeDepth;
        this.myInsertionReceiverBounds = this.myInsertionRowBounds = this.getRowBounds(this.myInsertAfterRow);
        if (this.myRelativeDepthToInsertionRow < 1) {
            TreePath receiverPath = this.getPathForRow(this.myInsertAfterRow);
            for (int i2 = this.myRelativeDepthToInsertionRow; i2 < 1 && receiverPath != null; receiverPath = receiverPath.getParentPath(), ++i2) {
            }
            if (receiverPath != null) {
                this.myInsertionReceiverBounds = this.getPathBounds(receiverPath);
            }
        }
        this.repaint();
    }

    public void clearInsertionPoint() {
        this.myInsertionReceiverBounds = null;
        this.myInsertionRowBounds = null;
        this.myInsertAfterRow = -1;
        this.myRelativeDepthToInsertionRow = 0;
        this.repaint();
    }

    protected void clearToggledPaths() {
        super.clearToggledPaths();
    }

    @NotNull
    public List<NlComponent> getSelectedComponents() {
        ArrayList<NlComponent> selected = new ArrayList<NlComponent>();
        TreePath[] paths = this.getSelectionPaths();
        if (paths != null) {
            for (TreePath path2 : paths) {
                Object last = path2.getLastPathComponent();
                if (!(last instanceof NlComponent)) continue;
                selected.add((NlComponent)last);
            }
        }
        return selected;
    }

    @Override
    public void selectionChanged(@NotNull SelectionModel model2, @NotNull List<NlComponent> selection) {
        UIUtil.invokeLaterIfNeeded(() -> {
            this.updateSelection();
            this.scrollPathToVisible(this.getSelectionPath());
        });
    }

    @Override
    public void modelDerivedDataChanged(@NotNull NlModel model2) {
        UIUtil.invokeLaterIfNeeded(this::updateHierarchy);
    }

    @Override
    public void modelChangedOnLayout(@NotNull NlModel model2, boolean animate) {
    }

    @Override
    public void modelChanged(@NotNull DesignSurface surface2, @Nullable NlModel model2) {
        this.setModel(model2, true);
    }

    @Override
    public boolean activatePreferredEditor(@NotNull DesignSurface surface2, @NotNull NlComponent component) {
        return false;
    }

    public Object getData(@NotNull @NonNls String dataId) {
        TreePath path2 = this.getSelectionPath();
        if (path2 != null && !(path2.getLastPathComponent() instanceof NlComponent) && PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            return this.createNonNlComponentDeleteProvider();
        }
        return this.mySurface == null ? null : this.mySurface.getData(dataId);
    }

    @NotNull
    private DeleteProvider createNonNlComponentDeleteProvider() {
        return new DeleteProvider(){

            public void deleteElement(@NotNull DataContext dataContext) {
                NlComponentTree.this.deleteNonNlComponent(NlComponentTree.this.getSelectionPaths());
            }

            public boolean canDeleteElement(@NotNull DataContext dataContext) {
                return true;
            }
        };
    }

    private void deleteNonNlComponent(TreePath[] selectedPath) {
        Object component;
        TreePath parent = NlTreeUtil.getUniqueParent(selectedPath);
        if (parent != null && (component = parent.getLastPathComponent()) instanceof NlComponent) {
            NlTreeUtil.delegateEvent(DelegatedTreeEvent.Type.DELETE, this, (NlComponent)component, -1);
        }
    }

    boolean shouldDisplayFittedText(int index2) {
        return !UIUtil.isClientPropertyTrue((Object)this, (Object)ExpandableItemsHandler.EXPANDED_RENDERER) && !this.getExpandableItemsHandler().getExpandedItems().contains(index2);
    }

    public boolean getShowsRootHandles() {
        return false;
    }

    protected void setExpandedState(TreePath path2, boolean state) {
        boolean isRoot = this.getRowForPath(path2) == 0;
        super.setExpandedState(path2, isRoot || state);
    }

    private static class MyUI
    extends DarculaTreeUI {
        private MyUI() {
        }

        public void invalidateNodeSize() {
            this.treeState.invalidateSizes();
        }
    }

    private static final class StructureSpeedSearch
    extends TreeSpeedSearch {
        StructureSpeedSearch(@NotNull NlComponentTree tree) {
            super((JTree)((Object)tree));
        }

        protected boolean isMatchingElement(Object element2, String pattern) {
            if (pattern == null) {
                return false;
            }
            Object component = ((TreePath)element2).getLastPathComponent();
            return this.compare(component instanceof NlComponent ? TreeSearchUtil.toString((NlComponent)component) : "", pattern);
        }
    }

    private class StructurePaneSelectionListener
    implements TreeSelectionListener {
        private StructurePaneSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            if (!NlComponentTree.this.mySelectionIsUpdating.compareAndSet(false, true)) {
                return;
            }
            try {
                if (NlComponentTree.this.mySurface != null) {
                    SelectedComponent selected = NlTreeReferencedItemHelperKt.getSelectedComponents(NlComponentTree.this, NlComponentTree.this.myModel);
                    NlComponentTree.this.mySurface.getSelectionModel().setHighlightSelection(selected.getReferenced(), selected.getComponents());
                }
            }
            finally {
                NlComponentTree.this.mySelectionIsUpdating.set(false);
            }
        }
    }

    private class StructurePaneMouseListener
    extends MouseAdapter {
        private StructurePaneMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                this.handleDoubleClick(e);
            } else {
                this.handlePopup(e);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (NlComponentTree.this.mySurface != null) {
                NlComponentTree.this.mySurface.getSelectionModel().clearSecondary();
            }
            this.handlePopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.handlePopup(e);
        }

        private void handlePopup(MouseEvent e) {
            TreePath path2;
            if (e.isPopupTrigger() && (path2 = NlComponentTree.this.getPathForLocation(e.getX(), e.getY())) != null && NlComponentTree.this.mySurface != null) {
                Object component = path2.getLastPathComponent();
                if (component instanceof NlComponent) {
                    ActionUtils.showPopup(NlComponentTree.this.mySurface, e, (ActionGroup)NlComponentTree.this.mySurface.getActionManager().getPopupMenuActions((NlComponent)component), "LayoutEditor");
                } else {
                    ActionManager actionManager = ActionManager.getInstance();
                    actionManager.createActionPopupMenu("EditorPopup", (ActionGroup)new DefaultActionGroup(new AnAction[]{actionManager.getAction("$Delete")})).getComponent().show(e.getComponent(), e.getX(), e.getY());
                }
            }
        }

        private void handleDoubleClick(@NotNull MouseEvent event) {
            int y;
            int x = event.getX();
            TreePath path2 = NlComponentTree.this.getPathForLocation(x, y = event.getY());
            if (path2 == null || NlComponentTree.this.mySurface == null) {
                return;
            }
            Object component = path2.getLastPathComponent();
            if (component instanceof String) {
                NlComponent clicked = NlTreeReferencedItemHelperKt.findComponent((String)component, NlComponentTree.this.myModel);
                NlComponentTree.this.mySurface.getSelectionModel().setSelection(Arrays.asList(clicked));
                return;
            }
            if (!(component instanceof NlComponent)) {
                return;
            }
            ViewHandler handler2 = NlComponentHelperKt.getViewHandler((NlComponent)component);
            if (handler2 != null) {
                handler2.onActivateInComponentTree((NlComponent)component, NlComponentTree.this.mySurface.getSceneManager().getViewEditor());
            }
        }
    }
}

