/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.statelist;

import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.statelist.State;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ItemHandler
extends ViewHandler {
    @Override
    public boolean onCreate(@NotNull ViewEditor editor2, @Nullable NlComponent parent, @NotNull NlComponent newChild, @NotNull InsertType type) {
        newChild.removeAndroidAttribute("layout_width");
        newChild.removeAndroidAttribute("layout_height");
        return true;
    }

    @Override
    @NotNull
    public String getTitleAttributes(@NotNull NlComponent item) {
        String drawable = Strings.nullToEmpty((String)item.getAndroidAttribute("drawable"));
        String states = item.getAttributes().stream().filter(attribute -> State.valueOfString(attribute.name) != null).filter(attribute -> Boolean.valueOf(attribute.value)).map(attribute -> attribute.name).collect(Collectors.joining(", "));
        return states.isEmpty() ? drawable : drawable + " " + states;
    }

    @Override
    @NotNull
    public List<String> getInspectorProperties() {
        State[] states = State.values();
        ArrayList<String> attributes = new ArrayList<String>(1 + states.length);
        attributes.add("drawable");
        Arrays.stream(states).map(State::toString).forEach(attributes::add);
        return attributes;
    }
}

