/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene.target;

import com.android.tools.adtui.common.AdtUiCursorType;
import com.android.tools.adtui.common.AdtUiCursorsProvider;
import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.NlAttributesHolder;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.ScenePicker;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.target.BaseTarget;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.uibuilder.handlers.constraint.ComponentModification;
import com.android.tools.idea.uibuilder.scene.draw.DrawResize;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Cursor;
import java.util.List;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;

public abstract class ResizeBaseTarget
extends BaseTarget {
    protected final Type myType;
    protected int myStartX1;
    protected int myStartY1;
    protected int myStartX2;
    protected int myStartY2;

    public Type getType() {
        return this.myType;
    }

    public ResizeBaseTarget(@NotNull Type type) {
        this.myType = type;
    }

    @Override
    public boolean layout(@NotNull SceneContext sceneTransform, int l, int t, int r, int b) {
        int width = r - l;
        int height = b - t;
        int horizontalCenter = l + width / 2;
        int verticalCenter = t + height / 2;
        switch (this.myType) {
            case LEFT: {
                this.myLeft = l;
                this.myTop = verticalCenter;
                break;
            }
            case TOP: {
                this.myLeft = horizontalCenter;
                this.myTop = t;
                break;
            }
            case RIGHT: {
                this.myLeft = r;
                this.myTop = verticalCenter;
                break;
            }
            case BOTTOM: {
                this.myLeft = horizontalCenter;
                this.myTop = b;
                break;
            }
            case LEFT_TOP: {
                this.myLeft = l;
                this.myTop = t;
                break;
            }
            case LEFT_BOTTOM: {
                this.myLeft = l;
                this.myTop = b;
                break;
            }
            case RIGHT_TOP: {
                this.myLeft = r;
                this.myTop = t;
                break;
            }
            case RIGHT_BOTTOM: {
                this.myLeft = r;
                this.myTop = b;
            }
        }
        this.myRight = this.myLeft;
        this.myBottom = this.myTop;
        return false;
    }

    @Override
    public Cursor getMouseCursor(@JdkConstants.InputEventMask int modifiersEx) {
        switch (this.myType) {
            case LEFT: {
                return AdtUiCursorsProvider.getInstance().getCursor(AdtUiCursorType.W_RESIZE);
            }
            case RIGHT: {
                return AdtUiCursorsProvider.getInstance().getCursor(AdtUiCursorType.E_RESIZE);
            }
            case TOP: {
                return AdtUiCursorsProvider.getInstance().getCursor(AdtUiCursorType.N_RESIZE);
            }
            case BOTTOM: {
                return AdtUiCursorsProvider.getInstance().getCursor(AdtUiCursorType.S_RESIZE);
            }
            case LEFT_TOP: {
                return AdtUiCursorsProvider.getInstance().getCursor(AdtUiCursorType.NW_RESIZE);
            }
            case LEFT_BOTTOM: {
                return AdtUiCursorsProvider.getInstance().getCursor(AdtUiCursorType.SW_RESIZE);
            }
            case RIGHT_TOP: {
                return AdtUiCursorsProvider.getInstance().getCursor(AdtUiCursorType.NE_RESIZE);
            }
            case RIGHT_BOTTOM: {
                return AdtUiCursorsProvider.getInstance().getCursor(AdtUiCursorType.SE_RESIZE);
            }
        }
        return Cursor.getPredefinedCursor(0);
    }

    @Override
    public void render(@NotNull DisplayList list, @NotNull SceneContext sceneContext) {
        if (this.isHittable()) {
            DrawResize.add(list, sceneContext, this.myLeft, this.myTop, this.mIsOver ? 1 : 0);
        }
    }

    @Override
    public void addHit(@NotNull SceneContext transform, @NotNull ScenePicker picker, @JdkConstants.InputEventMask int modifiersEx) {
        if (this.isHittable()) {
            int halfSize = DrawResize.SIZE / 2;
            picker.addRect(this, 0, transform.getSwingXDip(this.myLeft) - halfSize, transform.getSwingYDip(this.myTop) - halfSize, transform.getSwingXDip(this.myRight) + halfSize, transform.getSwingYDip(this.myBottom) + halfSize);
        }
    }

    @Override
    protected boolean isHittable() {
        SceneComponent component = this.getComponent();
        if (component.getScene().getSelection().size() > 1) {
            return false;
        }
        if (component.isSelected()) {
            if (component.canShowBaseline()) {
                return true;
            }
            return !component.isDragging();
        }
        Scene.FilterType filterType = component.getScene().getFilterType();
        return filterType == Scene.FilterType.RESIZE || filterType == Scene.FilterType.ALL;
    }

    protected abstract void updateAttributes(@NotNull NlAttributesHolder var1, int var2, int var3);

    @Override
    public int getPreferenceLevel() {
        return 60;
    }

    @Override
    public void mouseDown(int x, int y) {
        this.myStartX1 = this.myComponent.getDrawX();
        this.myStartY1 = this.myComponent.getDrawY();
        this.myStartX2 = this.myComponent.getDrawX() + this.myComponent.getDrawWidth();
        this.myStartY2 = this.myComponent.getDrawY() + this.myComponent.getDrawHeight();
    }

    @Override
    public void mouseDrag(int x, int y, @NotNull List<Target> closestTargets, @NotNull SceneContext ignored) {
        NlComponent component = this.myComponent.getAuthoritativeNlComponent();
        AttributesTransaction attributes = component.startAttributeTransaction();
        this.updateAttributes(attributes, x, y);
        attributes.apply();
        this.myComponent.getScene().markNeedsLayout(1);
    }

    @Override
    public void mouseRelease(int x, int y, @NotNull List<Target> closestTargets) {
        NlComponent component = this.myComponent.getAuthoritativeNlComponent();
        ComponentModification modification = new ComponentModification(component, "Resize " + StringUtil.getShortName((String)component.getTagName()));
        this.updateAttributes(modification, x, y);
        modification.commit();
        this.myComponent.getScene().markNeedsLayout(1);
    }

    @Override
    public void mouseCancel() {
        this.myComponent.setPosition(this.myStartX1, this.myStartY1);
        NlComponent component = this.myComponent.getAuthoritativeNlComponent();
        AttributesTransaction transaction = component.startAttributeTransaction();
        transaction.rollback();
        component.fireLiveChangeEvent();
        this.myComponent.setDragging(false);
        this.myComponent.getScene().markNeedsLayout(1);
    }

    @Override
    public String getToolTipText() {
        return "Resize View";
    }

    public static enum Type {
        LEFT,
        LEFT_TOP,
        LEFT_BOTTOM,
        TOP,
        BOTTOM,
        RIGHT,
        RIGHT_TOP,
        RIGHT_BOTTOM;

    }
}

