/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene.decorator;

import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.decorator.SceneDecorator;
import com.android.tools.idea.common.scene.draw.ColorSet;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.draw.DrawTextRegion;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintUtilities;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import org.jetbrains.annotations.NotNull;

public class RadioButtonDecorator
extends SceneDecorator {
    @Override
    public void addContent(@NotNull DisplayList list, long time2, @NotNull SceneContext sceneContext, @NotNull SceneComponent component) {
        super.addContent(list, time2, sceneContext, component);
        Rectangle rect = new Rectangle();
        component.fillDrawRect(time2, rect);
        int l = sceneContext.getSwingXDip(rect.x);
        int t = sceneContext.getSwingYDip(rect.y);
        int w = sceneContext.getSwingDimensionDip(rect.width);
        int h = sceneContext.getSwingDimensionDip(rect.height);
        String text2 = ConstraintUtilities.getResolvedText(component.getNlComponent());
        int baseLineOffset = sceneContext.getSwingDimensionDip(component.getBaseline());
        float scale = (float)sceneContext.getScale();
        int mode = component.isSelected() ? 2 : 0;
        list.add(new DrawRadioButton(l, t, w, h, mode, baseLineOffset, scale, text2));
    }

    public static class DrawRadioButton
    extends DrawTextRegion {
        int[] xp = new int[3];
        int[] yp = new int[3];

        @Override
        public int getLevel() {
            return 20;
        }

        DrawRadioButton(int x, int y, int width, int height, int mode, int baselineOffset, float scale, String text2) {
            super(x, y, width, height, mode, baselineOffset, text2, true, false, 5, 4, 32, scale);
        }

        @NotNull
        public static DrawRadioButton createFromString(@NotNull String s) {
            String[] sp = s.split(",");
            int c = 0;
            int x = Integer.parseInt(sp[c++]);
            int y = Integer.parseInt(sp[c++]);
            int width = Integer.parseInt(sp[c++]);
            int height = Integer.parseInt(sp[c++]);
            int mode = Integer.parseInt(sp[c++]);
            int baseLineOffset = Integer.parseInt(sp[c++]);
            float scale = Float.parseFloat(sp[c++]);
            String text2 = s.substring(s.indexOf(34) + 1, s.lastIndexOf(34));
            return new DrawRadioButton(x, y, width, height, mode, baseLineOffset, scale, text2);
        }

        @Override
        public String serialize() {
            return this.getClass().getSimpleName() + "," + this.x + "," + this.y + "," + this.width + "," + this.height + "," + this.mMode + "," + this.myBaseLineOffset + "," + this.mScale + ",\"" + this.mText + "\"";
        }

        @Override
        public void paint(Graphics2D g, SceneContext sceneContext) {
            int margin = this.height / 5;
            this.mHorizontalPadding = this.height;
            super.paint(g, sceneContext);
            ColorSet colorSet = sceneContext.getColorSet();
            if (colorSet.drawBackground()) {
                Shape original = g.getClip();
                g.clipRect(this.x, this.y, this.width, this.height);
                Stroke stroke = g.getStroke();
                g.setStroke(new BasicStroke(2.0f));
                g.setColor(colorSet.getFakeUI());
                int side = this.height - margin * 2;
                g.drawRoundRect(this.x + margin, this.y + margin, side, side, side, side);
                g.setStroke(stroke);
                g.setClip(original);
            }
        }
    }
}

