/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.palette;

import com.android.SdkConstants;
import com.android.annotations.concurrency.Slow;
import com.android.tools.idea.project.AndroidProjectBuildNotifications;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.handlers.ActionMenuViewHandler;
import com.android.tools.idea.uibuilder.handlers.BuiltinViewHandlerProvider;
import com.android.tools.idea.uibuilder.handlers.CustomViewGroupHandler;
import com.android.tools.idea.uibuilder.handlers.CustomViewHandler;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintHelperHandler;
import com.android.tools.idea.uibuilder.handlers.preference.PreferenceCategoryHandler;
import com.android.tools.idea.uibuilder.handlers.preference.PreferenceHandler;
import com.android.tools.idea.uibuilder.menu.MenuHandler;
import com.android.tools.idea.uibuilder.model.NlComponentHelper;
import com.android.tools.idea.uibuilder.palette.Palette;
import com.android.tools.idea.uibuilder.type.LayoutEditorFileType;
import com.android.tools.idea.uibuilder.type.LayoutFileType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.util.EmptyQuery;
import com.intellij.util.Query;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import icons.StudioIcons;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Function;
import javax.swing.Icon;
import javax.xml.bind.JAXBException;
import org.intellij.lang.annotations.Language;
import org.jetbrains.android.dom.converters.PackageClassConverter;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlPaletteModel
implements Disposable {
    private boolean myDisposed;
    @VisibleForTesting
    static final String PROJECT_GROUP = "Project";
    private static final Function<Project, Query<PsiClass>> VIEW_CLASSES_QUERY = project -> {
        PsiClass viewClass = JavaPsiFacade.getInstance((Project)project).findClass("android.view.View", GlobalSearchScope.allScope((Project)project));
        if (viewClass == null) {
            return EmptyQuery.getEmptyQuery();
        }
        return ClassInheritorsSearch.search((PsiClass)viewClass, (SearchScope)ProjectScope.getProjectScope((Project)project), (boolean)true);
    };
    private final Map<LayoutEditorFileType, Palette> myTypeToPalette;
    private final Module myModule;
    private final List<UpdateListener> myListeners = ContainerUtil.createConcurrentList();

    public void dispose() {
        this.myListeners.clear();
        this.myTypeToPalette.clear();
        this.myDisposed = true;
    }

    public List<UpdateListener> getUpdateListeners() {
        return this.myListeners;
    }

    public static NlPaletteModel get(@NotNull AndroidFacet facet2) {
        return (NlPaletteModel)facet2.getModule().getComponent(NlPaletteModel.class);
    }

    private NlPaletteModel(@NotNull Module module2) {
        this.myTypeToPalette = Collections.synchronizedMap(new HashMap());
        this.myModule = module2;
        Disposer.register((Disposable)module2, (Disposable)this);
    }

    @NotNull
    public Module getModule() {
        return this.myModule;
    }

    @Slow
    @NotNull
    public Palette getPalette(@NotNull LayoutEditorFileType type) {
        Palette palette = this.myTypeToPalette.get(type);
        if (palette == null) {
            palette = this.loadPalette(type);
            this.myTypeToPalette.put(type, palette);
            this.registerAdditionalComponents(type);
        }
        return palette;
    }

    private void registerAdditionalComponents(@NotNull LayoutEditorFileType type) {
        this.loadAdditionalComponents(type, VIEW_CLASSES_QUERY);
        AndroidProjectBuildNotifications.subscribe(this.myModule.getProject(), this, context -> this.loadAdditionalComponents(type, VIEW_CLASSES_QUERY));
    }

    public void addUpdateListener(@Nullable UpdateListener updateListener) {
        this.myListeners.add(updateListener);
    }

    public void removeUpdateListener(@Nullable UpdateListener updateListener) {
        this.myListeners.remove(updateListener);
    }

    private void notifyUpdateListener(@NotNull LayoutEditorFileType layoutType) {
        if (!this.myListeners.isEmpty()) {
            this.myListeners.forEach(listener2 -> ApplicationManager.getApplication().invokeLater(() -> {
                if (!this.myDisposed) {
                    listener2.update(this, layoutType);
                }
            }));
        }
    }

    @VisibleForTesting
    @NotNull
    public static String getPaletteFileNameFromId(@NotNull String id) {
        return id + "_palette.xml";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Slow
    @NotNull
    private Palette loadPalette(@NotNull LayoutEditorFileType type) {
        try {
            String id = type.getPaletteId();
            if (id == null) {
                Logger.getInstance(NlPaletteModel.class).warn(type + " has no palette id. No palette will be used.");
                return Palette.EMPTY;
            }
            URL url = NlPaletteModel.class.getResource(NlPaletteModel.getPaletteFileNameFromId(id));
            URLConnection connection = url.openConnection();
            try (InputStreamReader reader = new InputStreamReader(connection.getInputStream(), Charsets.UTF_8);){
                Palette palette = Palette.parse(reader, ViewHandlerManager.get(this.myModule.getProject()));
                return palette;
            }
        }
        catch (IOException | JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    void loadAdditionalComponents(@NotNull LayoutEditorFileType type, @NotNull Function<Project, Query<PsiClass>> viewClasses) {
        Application application = ApplicationManager.getApplication();
        Project project = this.myModule.getProject();
        ReadAction.nonBlocking(() -> CustomViewInfo.fromPsiClasses((Query<PsiClass>)((Query)viewClasses.apply(project)))).expireWhen(() -> Disposer.isDisposed((Disposable)this)).inSmartMode(project).submit((Executor)AppExecutorUtil.getAppExecutorService()).onSuccess(viewInfos -> application.executeOnPooledThread(() -> this.replaceProjectComponents(type, (Collection<CustomViewInfo>)viewInfos))).onError(error -> NlPaletteModel.getLogger().error(error));
    }

    @Slow
    private void replaceProjectComponents(@NotNull LayoutEditorFileType type, Collection<CustomViewInfo> viewInfos) {
        Palette palette = this.loadPalette(type);
        viewInfos.forEach(viewInfo -> this.addAdditionalComponent(type, PROJECT_GROUP, palette, StudioIcons.LayoutEditor.Palette.CUSTOM_VIEW, viewInfo.tagName, viewInfo.className, null, null, "", null, Collections.emptyList(), Collections.emptyList()));
        this.myTypeToPalette.put(type, palette);
        this.notifyUpdateListener(type);
    }

    @VisibleForTesting
    boolean addAdditionalComponent(@NotNull LayoutEditorFileType type, @NotNull String groupName, @NotNull Palette palette, @Nullable Icon icon16, @NotNull String tagName, @NotNull String className2, @Nullable @Language(value="XML") String xml, @Nullable @Language(value="XML") String previewXml, @NotNull String libraryCoordinate, @Nullable String preferredProperty, @NotNull List<String> properties2, @NotNull List<String> layoutProperties) {
        if (tagName.indexOf(46) < 0 || !NlComponentHelper.INSTANCE.viewClassToTag(tagName).equals(tagName) || SdkConstants.CONSTRAINT_LAYOUT.isEquals(tagName)) {
            return false;
        }
        ViewHandler handler2 = this.findOrCreateCustomHandler(tagName, icon16, className2, xml, previewXml, libraryCoordinate, preferredProperty, properties2, layoutProperties);
        if (type != LayoutFileType.INSTANCE || handler2 == null || handler2 instanceof PreferenceHandler || handler2 instanceof PreferenceCategoryHandler || handler2 instanceof MenuHandler || handler2 instanceof ActionMenuViewHandler) {
            return false;
        }
        List<Palette.BaseItem> groups = palette.getItems();
        Palette.Group group2 = groups.stream().filter(Palette.Group.class::isInstance).map(Palette.Group.class::cast).filter(g -> groupName.equals(g.getName())).findFirst().orElse(null);
        if (group2 == null) {
            group2 = new Palette.Group(groupName);
            groups.add(group2);
        }
        ViewHandlerManager manager = ViewHandlerManager.get(this.myModule.getProject());
        Palette.Item item = new Palette.Item(tagName, handler2);
        group2.getItems().add(item);
        item.setUp(palette, manager);
        item.setParent(group2);
        return true;
    }

    @Nullable
    private ViewHandler findOrCreateCustomHandler(@NotNull String tagName, @Nullable Icon icon16, @NotNull String className2, @Nullable @Language(value="XML") String xml, @Nullable @Language(value="XML") String previewXml, @NotNull String libraryCoordinate, @Nullable String preferredProperty, @NotNull List<String> properties2, @NotNull List<String> layoutProperties) {
        ViewHandler handler2 = BuiltinViewHandlerProvider.INSTANCE.findHandler(tagName);
        if (handler2 != null) {
            return handler2;
        }
        ViewHandlerManager manager = ViewHandlerManager.get(this.myModule.getProject());
        handler2 = manager.getHandlerOrDefault(tagName);
        if (handler2 instanceof ConstraintHelperHandler) {
            return null;
        }
        if (handler2 instanceof CustomViewGroupHandler && ((CustomViewGroupHandler)handler2).getTagName().equals(tagName)) {
            return handler2;
        }
        if (handler2 instanceof CustomViewHandler && ((CustomViewHandler)handler2).getTagName().equals(tagName)) {
            return handler2;
        }
        handler2 = handler2 instanceof ViewGroupHandler ? new CustomViewGroupHandler((ViewGroupHandler)handler2, icon16, tagName, className2, xml, previewXml, libraryCoordinate, preferredProperty, properties2, layoutProperties) : new CustomViewHandler(handler2, icon16, tagName, className2, xml, previewXml, libraryCoordinate, preferredProperty, properties2);
        manager.registerHandler(tagName, handler2);
        return handler2;
    }

    private static Logger getLogger() {
        return Logger.getInstance(NlPaletteModel.class);
    }

    public static interface UpdateListener {
        public void update(@NotNull NlPaletteModel var1, @NotNull LayoutEditorFileType var2);
    }

    private static class CustomViewInfo {
        public final String description;
        public final String tagName;
        public final String className;

        CustomViewInfo(String description2, String tagName, String className2) {
            this.description = description2;
            this.tagName = tagName;
            this.className = className2;
        }

        static Collection<CustomViewInfo> fromPsiClasses(Query<PsiClass> psiClasses) {
            ArrayList<CustomViewInfo> componentInfos = new ArrayList<CustomViewInfo>();
            psiClasses.forEach(psiClass -> {
                String description2 = psiClass.getName();
                String tagName = psiClass.getQualifiedName();
                String className2 = PackageClassConverter.getQualifiedName(psiClass);
                if (description2 == null || tagName == null || className2 == null) {
                    return;
                }
                componentInfos.add(new CustomViewInfo(description2, tagName, className2));
            });
            return componentInfos;
        }
    }
}

