/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.mockup.editor.creators;

import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.uibuilder.mockup.Mockup;
import com.android.tools.idea.uibuilder.mockup.editor.creators.SimpleViewCreator;
import com.android.tools.idea.uibuilder.mockup.editor.creators.WidgetCreator;
import com.android.tools.idea.uibuilder.mockup.editor.creators.forms.ViewAndColorForm;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewWithBackgroundCreator
extends SimpleViewCreator {
    protected WidgetCreator.ColorResourceHolder myColor;

    public ViewWithBackgroundCreator(@NotNull Mockup mockup, @NotNull NlModel model2, @NotNull SceneView screenView, @NotNull Rectangle selection) {
        super(mockup, model2, screenView, selection);
    }

    @Override
    public boolean hasOptionsComponent() {
        return true;
    }

    @Override
    @Nullable
    public JComponent getOptionsComponent(@NotNull WidgetCreator.DoneCallback doneCallback) {
        ViewAndColorForm viewAndColorForm = new ViewAndColorForm("Extract Background color", this.createColorSelectedListener(doneCallback));
        BufferedImage image = this.getMockup().getImage();
        if (image == null) {
            return null;
        }
        this.extractColor(viewAndColorForm, image);
        return viewAndColorForm.getComponent();
    }

    @NotNull
    protected ViewAndColorForm.ColorSelectedListener createColorSelectedListener(@NotNull WidgetCreator.DoneCallback doneCallback) {
        return colorHolder -> {
            this.myColor = colorHolder;
            if (this.myColor != null) {
                if (this.myColor.name != null && !this.myColor.name.isEmpty() && this.myColor.value != null) {
                    ViewWithBackgroundCreator.createColorResource(this.myColor.name, this.myColor.value, this.getModel());
                }
                doneCallback.done(1);
            } else {
                doneCallback.done(0);
            }
        };
    }

    @Override
    protected void addAttributes(@NotNull AttributesTransaction transaction) {
        super.addAttributes(transaction);
        if (this.myColor != null && this.myColor.value != null) {
            if (this.myColor.name != null && !this.myColor.name.isEmpty()) {
                transaction.setAttribute(null, "android:background", "@color/" + this.myColor.name);
            } else {
                transaction.setAttribute(null, "android:background", String.format("#%06X", this.myColor.value.getRGB()));
            }
        }
    }
}

