/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.mockup.colorextractor;

import com.android.tools.idea.uibuilder.mockup.Mockup;
import com.android.tools.idea.uibuilder.mockup.colorextractor.Clusterer;
import com.android.tools.idea.uibuilder.mockup.colorextractor.DBSCANClusterer;
import com.android.tools.idea.uibuilder.mockup.colorextractor.DoublesColorExtractor;
import com.android.tools.idea.uibuilder.mockup.colorextractor.ExtractedColor;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DBSCANColorExtractor
extends DoublesColorExtractor {
    public static final float DEFAULT_EPS = 1.3f;
    private float myEps;
    private int myMinClusterSize;

    public DBSCANColorExtractor(Mockup mockup) {
        super(mockup);
        this.myEps = 1.3f;
        this.myMinClusterSize = DBSCANColorExtractor.getMinClusterSize(this.myImage);
    }

    public DBSCANColorExtractor(BufferedImage image, float eps, int minClusterSize) {
        super(image);
        this.myEps = eps;
        this.myMinClusterSize = minClusterSize;
    }

    @NotNull
    private static List<ExtractedColor> getMainColorPerCluster(HashMap<Integer, Integer> LAB_RGB, List<List<double[]>> clusters) {
        ArrayList<ExtractedColor> colors = new ArrayList<ExtractedColor>(clusters.size());
        for (int clusterIndex = 0; clusterIndex < clusters.size(); ++clusterIndex) {
            List<double[]> cluster = clusters.get(clusterIndex);
            HashMap<Integer, Integer> occurrences = new HashMap<Integer, Integer>();
            int maxOccurrence = 0;
            int mostPresentColor = 0;
            for (int colorIndex = 0; colorIndex < cluster.size(); ++colorIndex) {
                int colorOccurrence;
                double[] LAB2 = cluster.get(colorIndex);
                int rgb = LAB_RGB.get(Arrays.hashCode(LAB2));
                if (occurrences.containsKey(rgb)) {
                    colorOccurrence = (Integer)occurrences.get(rgb) + 1;
                    occurrences.replace(rgb, colorOccurrence);
                } else {
                    occurrences.put(rgb, 1);
                    colorOccurrence = 1;
                }
                if (colorOccurrence <= maxOccurrence) continue;
                maxOccurrence = colorOccurrence;
                mostPresentColor = rgb;
            }
            HashSet<Integer> clusterColorSet = new HashSet<Integer>();
            for (int i2 = 0; i2 < cluster.size(); ++i2) {
                clusterColorSet.add(LAB_RGB.get(Arrays.hashCode(cluster.get(i2))));
            }
            colors.add(new ExtractedColor(mostPresentColor, cluster.size(), clusterColorSet));
        }
        Collections.sort(colors);
        return colors;
    }

    @Override
    List<ExtractedColor> runClustering(HashMap<Integer, Integer> labToRgb, List<double[]> clusterInput, Clusterer.ProgressListener listener2) {
        DBSCANClusterer dbscanClusterer = new DBSCANClusterer(this.myEps, this.myMinClusterSize, listener2);
        List<List<double[]>> clusters = dbscanClusterer.cluster((double[][])clusterInput.toArray((T[])new double[clusterInput.size()][3]));
        List<ExtractedColor> extractedColors = DBSCANColorExtractor.getMainColorPerCluster(labToRgb, clusters);
        return extractedColors;
    }

    public static int getMinClusterSize(BufferedImage image) {
        int imageSize = Math.max(image.getWidth(), image.getHeight());
        int minClusterSize = imageSize < 16 ? 0 : (int)Math.round(Math.pow(imageSize, 0.25));
        return minClusterSize;
    }
}

