/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.menu;

import com.android.resources.ResourceType;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.command.NlWriteCommandActionUtil;
import com.android.tools.idea.common.model.NlAttributesHolder;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.DesignSurfaceHelper;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.menu.MenuHandler;
import icons.StudioIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SearchItemHandler
extends MenuHandler {
    private static final String SEARCH_ICON = "ic_search_black_24dp";

    static boolean handles(@NotNull NlAttributesHolder item) {
        return "@drawable/ic_search_black_24dp".equals(item.getAndroidAttribute("icon"));
    }

    static void onChildInserted(@NotNull ViewEditor editor2) {
        if (!DesignSurfaceHelper.moduleContainsResource(editor2.getModel().getFacet(), ResourceType.DRAWABLE, SEARCH_ICON)) {
            NlModel model2 = editor2.getModel();
            DesignSurfaceHelper.copyVectorAssetToMainModuleSourceSet(model2.getProject(), model2.getFacet(), SEARCH_ICON);
        }
    }

    @Override
    public boolean onCreate(@NotNull ViewEditor editor2, @Nullable NlComponent parent, @NotNull NlComponent newChild, @NotNull InsertType type) {
        if (!super.onCreate(editor2, parent, newChild, type)) {
            return false;
        }
        if (!type.equals((Object)InsertType.CREATE)) {
            return true;
        }
        NlWriteCommandActionUtil.run(newChild, "", () -> {
            String value2 = editor2.getMinSdkVersion().getApiLevel() < 11 ? "android.support.v7.widget.SearchView" : "android.widget.SearchView";
            String namespace = editor2.moduleDependsOnAppCompat() ? "http://schemas.android.com/apk/res-auto" : "http://schemas.android.com/apk/res/android";
            newChild.setAttribute(namespace, "actionViewClass", value2);
        });
        return true;
    }

    @Override
    @NotNull
    public Icon getIcon(@NotNull NlComponent component) {
        return StudioIcons.LayoutEditor.Menu.SEARCH;
    }
}

