/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.menu;

import com.android.tools.idea.common.api.DragType;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.command.NlWriteCommandActionUtil;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.uibuilder.api.DragHandler;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.graphics.NlDrawingStyle;
import com.android.tools.idea.uibuilder.graphics.NlGraphics;
import com.android.tools.idea.uibuilder.menu.ActionBar;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.primitives.Ints;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class GroupDragHandler
extends DragHandler {
    private final SceneComponent myGroup;
    private final List<NlComponent> myItems;
    private final ActionBar myActionBar;
    private SceneComponent myActiveItem;

    GroupDragHandler(@NotNull ViewEditor editor2, @NotNull ViewGroupHandler handler2, @NotNull SceneComponent group2, @NotNull List<NlComponent> items2, @NotNull DragType type) {
        super(editor2, handler2, group2, items2, type);
        assert (!items2.isEmpty());
        this.myGroup = group2;
        this.myItems = items2;
        this.myActionBar = new ActionBar(group2);
    }

    @Override
    public void commit(int x, int y, int modifiers, @NotNull InsertType insertType) {
        NlComponent groupComponent = this.myGroup.getNlComponent();
        int insertIndex = this.getInsertIndex();
        NlWriteCommandActionUtil.run(this.myItems.get(0), "menu item addition", () -> {
            this.updateOrderInCategoryAttributes();
            this.updateShowAsActionAttribute();
        });
        this.editor.insertChildren(groupComponent, this.myItems, insertIndex, insertType);
    }

    private void updateOrderInCategoryAttributes() {
        if (this.myActiveItem == null || this.myActiveItem == this.layout.getSceneComponent(this.myItems.get(0))) {
            return;
        }
        Integer order = GroupDragHandler.getOrderInCategory(this.myActiveItem.getNlComponent());
        if (order == null) {
            return;
        }
        if (this.isActionBarGroupActive()) {
            this.updateActionBarGroupOrderInCategoryAttributes(order);
        } else {
            this.updateOverflowGroupOrderInCategoryAttributes(order);
        }
    }

    private void updateActionBarGroupOrderInCategoryAttributes(int order) {
        if (this.lastX >= this.myActiveItem.getCenterX()) {
            ++order;
        }
        GroupDragHandler.incrementOrderInCategoryAttributes(this.createOrderToItemMultimap(this.myActionBar.getItems()), order);
        this.myItems.get(0).setAndroidAttribute("orderInCategory", Integer.toString(order));
    }

    private void updateOverflowGroupOrderInCategoryAttributes(int order) {
        if (this.lastY >= this.myActiveItem.getCenterY()) {
            ++order;
        }
        GroupDragHandler.incrementOrderInCategoryAttributes(this.createOrderToItemMultimap(this.myActionBar.getOverflowItems()), order);
        this.myItems.get(0).setAndroidAttribute("orderInCategory", Integer.toString(order));
    }

    private static void incrementOrderInCategoryAttributes(@NotNull Multimap<Integer, SceneComponent> orderToItemMultimap, int order) {
        Collection items2 = orderToItemMultimap.get((Object)order);
        if (!items2.isEmpty()) {
            items2.forEach(item -> item.getNlComponent().setAndroidAttribute("orderInCategory", Integer.toString(order + 1)));
            GroupDragHandler.incrementOrderInCategoryAttributes(orderToItemMultimap, order + 1);
        }
    }

    @NotNull
    private Multimap<Integer, SceneComponent> createOrderToItemMultimap(@NotNull Iterable<SceneComponent> group2) {
        SceneComponent draggedItem = this.layout.getSceneComponent(this.myItems.get(0));
        ArrayListMultimap orderToItemMultimap = ArrayListMultimap.create();
        for (SceneComponent item : group2) {
            Integer order;
            if (item == draggedItem || (order = GroupDragHandler.getOrderInCategory(item.getNlComponent())) == null) continue;
            orderToItemMultimap.put((Object)order, (Object)item);
        }
        return orderToItemMultimap;
    }

    @Nullable
    private static Integer getOrderInCategory(@NotNull NlComponent item) {
        String order = item.getAndroidAttribute("orderInCategory");
        return order == null ? null : Ints.tryParse((String)order);
    }

    private void updateShowAsActionAttribute() {
        String namespace;
        String string = namespace = this.editor.moduleDependsOnAppCompat() ? "http://schemas.android.com/apk/res-auto" : "http://schemas.android.com/apk/res/android";
        if (this.isActionBarGroupActive()) {
            this.myItems.get(0).setAttribute(namespace, "showAsAction", "always");
        } else {
            this.myItems.get(0).removeAttribute(namespace, "showAsAction");
        }
    }

    @Override
    @Nullable
    public String update(int x, int y, int modifiers, @NotNull SceneContext sceneContext) {
        String message2 = super.update(x, y, modifiers, sceneContext);
        if (message2 != null) {
            this.myActiveItem = null;
            return message2;
        }
        if (this.isActionBarGroupActive()) {
            this.updateUsingActionBarGroup();
        } else if (this.isOverflowGroupActive()) {
            this.updateUsingOverflowGroup();
        } else {
            this.myActiveItem = null;
        }
        return null;
    }

    private void updateUsingActionBarGroup() {
        SceneComponent component;
        List<SceneComponent> items2 = this.myActionBar.getItems();
        if (this.lastX < items2.get(0).getDrawX()) {
            component = items2.get(0);
        } else {
            Optional<SceneComponent> activeItem = items2.stream().filter(item -> item.containsX(this.lastX)).findFirst();
            component = activeItem.orElse(items2.get(items2.size() - 1));
        }
        this.myActiveItem = component;
    }

    private void updateUsingOverflowGroup() {
        SceneComponent component;
        List<SceneComponent> overflowItems = this.myActionBar.getOverflowItems();
        if (this.lastY < overflowItems.get(0).getDrawY()) {
            component = overflowItems.get(0);
        } else {
            Optional<SceneComponent> activeItem = overflowItems.stream().filter(item -> item.containsY(this.lastY)).findFirst();
            component = activeItem.orElse(overflowItems.get(overflowItems.size() - 1));
        }
        this.myActiveItem = component;
    }

    @Override
    public void paint(@NotNull NlGraphics graphics) {
        if (this.isActionBarGroupActive()) {
            this.drawActionBarGroupDropPreviewLine(graphics);
            this.drawActionBarGroupDropRecipientLines(graphics);
            this.drawActionBarGroupDropZoneLines(graphics);
        } else if (this.isOverflowGroupActive()) {
            this.drawOverflowGroupDropPreviewLine(graphics);
            this.drawOverflowGroupDropRecipientLines(graphics);
            this.drawOverflowGroupDropZoneLines(graphics);
        }
    }

    private void drawActionBarGroupDropPreviewLine(@NotNull NlGraphics graphics) {
        graphics.useStyle(NlDrawingStyle.DROP_PREVIEW);
        SceneComponent activeItem = this.myActiveItem;
        if (this.lastX < activeItem.getCenterX()) {
            graphics.drawLeft(this.myActiveItem.getNlComponent());
        } else {
            graphics.drawRight(this.myActiveItem.getNlComponent());
        }
    }

    private void drawActionBarGroupDropRecipientLines(@NotNull NlGraphics graphics) {
        Rectangle itemBounds = this.myActionBar.getItemBounds();
        assert (itemBounds != null);
        List<SceneComponent> items2 = this.myActionBar.getItems();
        graphics.useStyle(NlDrawingStyle.DROP_RECIPIENT);
        graphics.drawTopDp(itemBounds);
        if (this.lastX >= items2.get(0).getCenterX()) {
            graphics.drawLeftDp(itemBounds);
        }
        if (this.lastX < items2.get(items2.size() - 1).getCenterX()) {
            graphics.drawRightDp(itemBounds);
        }
        graphics.drawBottomDp(itemBounds);
    }

    private void drawActionBarGroupDropZoneLines(@NotNull NlGraphics graphics) {
        List<SceneComponent> items2 = this.myActionBar.getItems();
        int midpointX = this.myActiveItem.getCenterX();
        graphics.useStyle(NlDrawingStyle.DROP_ZONE);
        int size = items2.size();
        for (int i2 = 1; i2 < size; ++i2) {
            SceneComponent item = items2.get(i2);
            if (this.myActiveItem == items2.get(i2 - 1)) {
                if (this.lastX >= midpointX) continue;
                graphics.drawLeft(item.getNlComponent());
                continue;
            }
            if (this.myActiveItem == item) {
                if (this.lastX < midpointX) continue;
                graphics.drawLeft(item.getNlComponent());
                continue;
            }
            graphics.drawLeft(item.getNlComponent());
        }
    }

    private void drawOverflowGroupDropPreviewLine(@NotNull NlGraphics graphics) {
        graphics.useStyle(NlDrawingStyle.DROP_PREVIEW);
        if (this.lastY < this.myActiveItem.getCenterY()) {
            graphics.drawTop(this.myActiveItem.getNlComponent());
        } else {
            graphics.drawBottom(this.myActiveItem.getNlComponent());
        }
    }

    private void drawOverflowGroupDropRecipientLines(@NotNull NlGraphics graphics) {
        List<SceneComponent> overflowItems = this.myActionBar.getOverflowItems();
        Rectangle overflowItemBounds = this.myActionBar.getOverflowItemBounds();
        assert (overflowItemBounds != null);
        graphics.useStyle(NlDrawingStyle.DROP_RECIPIENT);
        if (this.lastY >= overflowItems.get(0).getCenterX()) {
            graphics.drawTopDp(overflowItemBounds);
        }
        graphics.drawLeftDp(overflowItemBounds);
        graphics.drawRightDp(overflowItemBounds);
        if (this.lastY < overflowItems.get(overflowItems.size() - 1).getCenterY()) {
            graphics.drawBottomDp(overflowItemBounds);
        }
    }

    private void drawOverflowGroupDropZoneLines(@NotNull NlGraphics graphics) {
        List<SceneComponent> overflowItems = this.myActionBar.getOverflowItems();
        int midpointY = this.myActiveItem.getCenterY();
        graphics.useStyle(NlDrawingStyle.DROP_ZONE);
        int size = overflowItems.size();
        for (int i2 = 1; i2 < size; ++i2) {
            SceneComponent item = overflowItems.get(i2);
            if (this.myActiveItem == overflowItems.get(i2 - 1)) {
                if (this.lastY >= midpointY) continue;
                graphics.drawTop(item.getNlComponent());
                continue;
            }
            if (this.myActiveItem == item) {
                if (this.lastY < midpointY) continue;
                graphics.drawTop(item.getNlComponent());
                continue;
            }
            graphics.drawTop(item.getNlComponent());
        }
    }

    @VisibleForTesting
    int getInsertIndex() {
        if (this.isActionBarGroupActive()) {
            return this.getInsertIndexUsingActionBarGroup();
        }
        if (this.isOverflowGroupActive()) {
            return this.getInsertIndexUsingOverflowGroup();
        }
        return -1;
    }

    private int getInsertIndexUsingActionBarGroup() {
        Rectangle itemBounds = this.myActionBar.getItemBounds();
        assert (itemBounds != null);
        if (this.lastX < itemBounds.x) {
            return 0;
        }
        if (this.lastX >= itemBounds.x + itemBounds.width) {
            return -1;
        }
        int i2 = this.myGroup.getChildren().indexOf(this.myActiveItem);
        assert (i2 != -1);
        if (this.lastX >= this.myActiveItem.getCenterX()) {
            ++i2;
        }
        return i2 == this.myGroup.getChildCount() ? -1 : i2;
    }

    private int getInsertIndexUsingOverflowGroup() {
        Rectangle overflowItemBounds = this.myActionBar.getOverflowItemBounds();
        assert (overflowItemBounds != null);
        if (this.lastY < overflowItemBounds.y) {
            return 0;
        }
        if (this.lastY >= overflowItemBounds.y + overflowItemBounds.height) {
            return -1;
        }
        int i2 = this.myGroup.getChildren().indexOf(this.myActiveItem);
        assert (i2 != -1);
        if (this.lastY >= this.myActiveItem.getCenterY()) {
            ++i2;
        }
        return i2 == this.myGroup.getChildCount() ? -1 : i2;
    }

    private boolean isActionBarGroupActive() {
        Rectangle itemBounds = this.myActionBar.getItemBounds();
        return itemBounds != null && this.lastY < itemBounds.y + itemBounds.height;
    }

    private boolean isOverflowGroupActive() {
        return this.myActionBar.getOverflowItemBounds() != null;
    }
}

