/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.layout3d;

import com.android.tools.idea.uibuilder.layout3d.TriData;
import com.intellij.util.ui.ImageUtil;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;

public class Layout
extends TriData {
    BufferedImage mImage;
    public static final int CUBE_VERT_LENGTH = 24;
    public static final int CUBE_INDEX_LENGTH = 36;
    public static final int TRIANGLES_PER_CUBE = 12;

    public Layout(BufferedImage img, View view) {
        this.setUp(img, view);
    }

    public void setUp(BufferedImage img, View view) {
        int count = view.countCubes();
        this.myVert = new float[count * 24];
        this.myTexture_uv = new float[count * 24];
        this.myIndex = new int[count * 36];
        this.mySurfaceType = new int[count * 12];
        view.layout(this.myVert, this.myTexture_uv, 0, this.myIndex, this.mySurfaceType, 0, 0.0f);
        if (img != null && img.getType() != 2) {
            BufferedImage tmp = ImageUtil.createImage((int)img.getWidth(), (int)img.getHeight(), (int)2);
            tmp.createGraphics().drawImage((Image)img, 0, 0, null);
            img = tmp;
        }
        this.mImage = img;
        this.myTexture = ((DataBufferInt)img.getRaster().getDataBuffer()).getData();
        this.myTextureWidth = img.getWidth();
        this.myTextureHeight = img.getHeight();
    }

    public static class View
    extends Rectangle2D.Float {
        View parent;
        View child;
        View sister;
        public static final float DEPTH = 25.0f;

        public View(float x, float y, float width, float height) {
            super(x, y, width, height);
        }

        public View addChild(View ... v) {
            for (int i2 = 0; i2 < v.length; ++i2) {
                View view = v[i2];
                view.parent = this;
                if (this.child == null) {
                    this.child = view;
                    continue;
                }
                this.child.addSister(view);
            }
            return this;
        }

        public View addSister(View v) {
            if (this.sister == null) {
                v.parent = this.parent;
                this.sister = v;
            } else {
                this.sister.addSister(v);
            }
            return this;
        }

        float getDepth() {
            float d = 25.0f;
            if (this.sister != null) {
                d = Math.max(this.sister.getDepth(), d);
            }
            if (this.child != null) {
                d = Math.max(25.0f + this.child.getDepth(), d);
            }
            return d;
        }

        int countCubes() {
            int count = 1;
            if (this.sister != null) {
                count += this.sister.countCubes();
            }
            if (this.child != null) {
                View c = this.child;
                while (c != null) {
                    ++count;
                    c = c.sister;
                }
            }
            if (this.child != null) {
                count += this.child.countCubes();
            }
            return count;
        }

        int count() {
            int count = 1;
            if (this.sister != null) {
                count += this.sister.count();
            }
            if (this.child != null) {
                count += this.child.count();
            }
            return count;
        }

        public void fill(float[] vertices, float[] texture_uv, int voff, int[] index2, int[] stype, int ioff, float z, boolean blue) {
            float d = blue ? 1.0f : 25.0f;
            float[] v = new float[]{this.x, this.y, z, this.x + this.width, this.y, z, this.x + this.width, this.y + this.height, z, this.x, this.y + this.height, z, this.x, this.y, z - d, this.x + this.width, this.y, z - d, this.x + this.width, this.y + this.height, z - d, this.x, this.y + this.height, z - d};
            for (int i2 = 0; i2 < v.length; ++i2) {
                float f = v[i2];
                vertices[i2 + voff] = f;
                texture_uv[i2 + voff] = f;
                if (i2 % 3 != 2) continue;
                texture_uv[i2 + voff] = Float.NaN;
            }
            int[] ind = new int[]{2, 1, 0, 0, 3, 2, 7, 4, 5, 5, 6, 7, 1, 2, 6, 6, 5, 1, 4, 7, 3, 3, 0, 4, 2, 3, 7, 7, 6, 2, 0, 1, 5, 5, 4, 0};
            int[] type = new int[]{0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            for (int i3 = 0; i3 < ind.length; ++i3) {
                index2[i3 + ioff] = ind[i3] * 3 + voff;
                stype[(i3 + ioff) / 3] = blue ? 2 : type[i3 / 3];
            }
        }

        int layout(float[] vertices, float[] texture_uv, int voff, int[] index2, int[] stype, int ioff, float z) {
            int count = 1;
            this.fill(vertices, texture_uv, voff, index2, stype, ioff, z, false);
            voff += 24;
            ioff += 36;
            if (this.parent != null) {
                this.fill(vertices, texture_uv, voff, index2, stype, ioff, z + 25.0f, true);
                voff += 24;
                ioff += 36;
                ++count;
            }
            if (this.sister != null) {
                int sisters = this.sister.layout(vertices, texture_uv, voff, index2, stype, ioff, z);
                count += sisters;
                voff += sisters * 24;
                ioff += sisters * 36;
            }
            if (this.child != null) {
                count += this.child.layout(vertices, texture_uv, voff, index2, stype, ioff, z - 50.0f);
            }
            return count;
        }
    }
}

