/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.layout3d;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.AdbInitOptions;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.Log;
import com.android.ddmlib.MultiLineReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.tools.pixelprobe.Layer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LayerDisplay {
    public static void main(String[] str) {
        try {
            DeviceBridge.initDebugBridge();
            Thread.sleep(500L);
            IDevice d = DeviceBridge.getDevices()[0];
            for (IDevice device : DeviceBridge.getDevices()) {
                System.out.println(device.toString());
                System.out.println("getAvdName = " + device.getAvdName());
                System.out.println("getLanguage = " + device.getLanguage());
                System.out.println("getSerialNumber = " + device.getSerialNumber());
                System.out.println("getName = " + device.getName());
                System.out.println("getAvdName = " + device.getAvdName());
                System.out.println("getAvdName = " + device.getAvdName());
                System.out.println("getAvdName = " + device.getAvdName());
                System.out.println("getAvdName = " + device.getAvdName());
                System.out.println("getAvdName = " + device.getAvdName());
                System.out.println(device.isEmulator() ? "emulator" : "device");
            }
            if (d != null) {
                System.out.println(d.getAvdName());
            }
            DeviceBridge.terminate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void dump(List<Layer> layers, String str) {
        if (layers == null) {
            return;
        }
        for (Layer layer : layers) {
            System.out.println(str + layer.getBounds());
            LayerDisplay.dump(layer.getChildren(), " " + str);
        }
    }

    static class DeviceBridge {
        private static AndroidDebugBridge bridge;
        private static final HashMap<IDevice, Integer> devicePortMap;
        private static int nextLocalPort;

        DeviceBridge() {
        }

        public static void initDebugBridge() {
            if (bridge == null) {
                AndroidDebugBridge.init((AdbInitOptions)AdbInitOptions.DEFAULT);
            }
            if (bridge == null || !bridge.isConnected()) {
                String adbLocation = System.getProperty("hierarchyviewer.adb");
                adbLocation = adbLocation != null && !adbLocation.isEmpty() ? adbLocation + File.separator + "adb" : "adb";
                bridge = AndroidDebugBridge.createBridge((String)adbLocation, (boolean)true);
            }
        }

        public static void startListenForDevices(AndroidDebugBridge.IDeviceChangeListener listener2) {
            AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)listener2);
        }

        public static IDevice[] getDevices() {
            return bridge.getDevices();
        }

        public static boolean isViewServerRunning(IDevice device) {
            DeviceBridge.initDebugBridge();
            boolean[] result2 = new boolean[1];
            try {
                if (device.isOnline()) {
                    device.executeShellCommand(DeviceBridge.buildIsServerRunningShellCommand(), (IShellOutputReceiver)new BooleanResultReader(result2));
                    if (!result2[0] && VersionLoader.loadProtocolVersion(device) > 2) {
                        result2[0] = true;
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (TimeoutException e) {
                e.printStackTrace();
            }
            catch (AdbCommandRejectedException e) {
                e.printStackTrace();
            }
            catch (ShellCommandUnresponsiveException e) {
                e.printStackTrace();
            }
            return result2[0];
        }

        public static boolean startViewServer(IDevice device) {
            return DeviceBridge.startViewServer(device, 4939);
        }

        public static boolean startViewServer(IDevice device, int port) {
            DeviceBridge.initDebugBridge();
            boolean[] result2 = new boolean[1];
            try {
                if (device.isOnline()) {
                    device.executeShellCommand(DeviceBridge.buildStartServerShellCommand(port), (IShellOutputReceiver)new BooleanResultReader(result2));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (TimeoutException e) {
                e.printStackTrace();
            }
            catch (AdbCommandRejectedException e) {
                e.printStackTrace();
            }
            catch (ShellCommandUnresponsiveException e) {
                e.printStackTrace();
            }
            return result2[0];
        }

        public static boolean stopViewServer(IDevice device) {
            DeviceBridge.initDebugBridge();
            boolean[] result2 = new boolean[1];
            try {
                if (device.isOnline()) {
                    device.executeShellCommand(DeviceBridge.buildStopServerShellCommand(), (IShellOutputReceiver)new BooleanResultReader(result2));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (TimeoutException e) {
                e.printStackTrace();
            }
            catch (AdbCommandRejectedException e) {
                e.printStackTrace();
            }
            catch (ShellCommandUnresponsiveException e) {
                e.printStackTrace();
            }
            return result2[0];
        }

        public static void terminate() {
            AndroidDebugBridge.terminate();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void setupDeviceForward(IDevice device) {
            HashMap<IDevice, Integer> hashMap = devicePortMap;
            synchronized (hashMap) {
                if (device.getState() == IDevice.DeviceState.ONLINE) {
                    int localPort = nextLocalPort++;
                    try {
                        device.createForward(localPort, 4939);
                        devicePortMap.put(device, localPort);
                    }
                    catch (TimeoutException e) {
                        Log.e((String)"hierarchy", (String)("Timeout setting up port forwarding for " + device));
                    }
                    catch (AdbCommandRejectedException e) {
                        Log.e((String)"hierarchy", (String)String.format("Adb rejected forward command for device %1$s: %2$s", device, e.getMessage()));
                    }
                    catch (IOException e) {
                        Log.e((String)"hierarchy", (String)String.format("Failed to create forward for device %1$s: %2$s", device, e.getMessage()));
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void removeDeviceForward(IDevice device) {
            HashMap<IDevice, Integer> hashMap = devicePortMap;
            synchronized (hashMap) {
                Integer localPort = devicePortMap.get(device);
                if (localPort != null) {
                    try {
                        device.removeForward(localPort.intValue(), 4939);
                        devicePortMap.remove(device);
                    }
                    catch (TimeoutException e) {
                        Log.e((String)"hierarchy", (String)("Timeout removing port forwarding for " + device));
                    }
                    catch (AdbCommandRejectedException e) {
                        Log.e((String)"hierarchy", (String)String.format("Adb rejected remove-forward command for device %1$s: %2$s", device, e.getMessage()));
                    }
                    catch (IOException e) {
                        Log.e((String)"hierarchy", (String)String.format("Failed to remove forward for device %1$s: %2$s", device, e.getMessage()));
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static int getDeviceLocalPort(IDevice device) {
            HashMap<IDevice, Integer> hashMap = devicePortMap;
            synchronized (hashMap) {
                Integer port = devicePortMap.get(device);
                if (port != null) {
                    return port;
                }
                Log.e((String)"hierarchy", (String)("Missing forwarded port for " + device.getSerialNumber()));
                return -1;
            }
        }

        private static String buildStartServerShellCommand(int port) {
            return String.format("service call window %d i32 %d", 1, port);
        }

        private static String buildStopServerShellCommand() {
            return String.format("service call window %d", 2);
        }

        private static String buildIsServerRunningShellCommand() {
            return String.format("service call window %d", 3);
        }

        static {
            devicePortMap = new HashMap();
            nextLocalPort = 4939;
        }

        private static class BooleanResultReader
        extends MultiLineReceiver {
            private final boolean[] mResult;

            public BooleanResultReader(boolean[] result2) {
                this.mResult = result2;
            }

            public void processNewLines(String[] strings) {
                Pattern pattern;
                Matcher matcher;
                if (strings.length > 0 && (matcher = (pattern = Pattern.compile(".*?\\([0-9]{8} ([0-9]{8}).*")).matcher(strings[0])).matches() && Integer.parseInt(matcher.group(1)) == 1) {
                    this.mResult[0] = true;
                }
            }

            public boolean isCancelled() {
                return false;
            }
        }

        static class Window {
            public static final Window FOCUSED_WINDOW = new Window("<Focused Window>", -1);
            private String title;
            private int hashCode;

            public Window(String title, int hashCode) {
                this.title = title;
                this.hashCode = hashCode;
            }

            public String getTitle() {
                return this.title;
            }

            public int getHashCode() {
                return this.hashCode;
            }

            public String encode() {
                return Integer.toHexString(this.hashCode);
            }

            public String toString() {
                return this.title;
            }
        }

        public static class VersionLoader {
            public static int loadServerVersion(IDevice device) {
                return VersionLoader.loadVersion(device, "SERVER");
            }

            public static int loadProtocolVersion(IDevice device) {
                return VersionLoader.loadVersion(device, "PROTOCOL");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private static int loadVersion(IDevice device, String command) {
                Socket socket = null;
                BufferedReader in = null;
                BufferedWriter out = null;
                try {
                    socket = new Socket();
                    socket.connect(new InetSocketAddress("127.0.0.1", DeviceBridge.getDeviceLocalPort(device)));
                    out = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
                    in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                    out.write(command);
                    out.newLine();
                    out.flush();
                    int n = Integer.parseInt(in.readLine());
                    return n;
                }
                catch (Exception exception) {
                }
                finally {
                    try {
                        if (out != null) {
                            out.close();
                        }
                        if (in != null) {
                            in.close();
                        }
                        if (socket != null) {
                            socket.close();
                        }
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
                return 2;
            }
        }
    }

    static class Configuration {
        public static final int DEFAULT_SERVER_PORT = 4939;
        public static final int SERVICE_CODE_START_SERVER = 1;
        public static final int SERVICE_CODE_STOP_SERVER = 2;
        public static final int SERVICE_CODE_IS_SERVER_RUNNING = 3;

        Configuration() {
        }
    }
}

