/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.relative.draw;

import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DrawCommand;
import com.android.tools.idea.uibuilder.handlers.constraint.draw.DrawConnectionUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\n\b\u0002\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0017\u001a\u00020\u0005H\u0016J\u0018\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010\u001a\u001a\u00020\u000bH\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\rR \u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/idea/uibuilder/handlers/relative/draw/DrawVerticalArrowCommand;", "Lcom/android/tools/idea/common/scene/draw/DrawCommand;", "sceneContext", "Lcom/android/tools/idea/common/scene/SceneContext;", "x", "", "y1", "y2", "isReference", "", "text", "", "(Lcom/android/tools/idea/common/scene/SceneContext;IIIZLjava/lang/String;)V", "()Z", "paintImpl", "Lkotlin/Function2;", "Ljava/awt/Graphics2D;", "", "swingX", "swingY1", "swingY2", "getText", "()Ljava/lang/String;", "getLevel", "paint", "g", "serialize", "intellij.android.designer"})
final class DrawVerticalArrowCommand
implements DrawCommand {
    private final int swingX;
    private final int swingY1;
    private final int swingY2;
    private final Function2<Graphics2D, SceneContext, Unit> paintImpl;
    private final boolean isReference;
    @NotNull
    private final String text;

    @Override
    public void paint(@NotNull Graphics2D g, @NotNull SceneContext sceneContext) {
        this.paintImpl.invoke((Object)g, (Object)sceneContext);
    }

    @Override
    public int getLevel() {
        return 10;
    }

    @Override
    @NotNull
    public String serialize() {
        return this.getClass().getSimpleName() + " - (" + this.swingX + ", " + this.swingY1 + ", " + this.swingY2 + ')';
    }

    public final boolean isReference() {
        return this.isReference;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    public DrawVerticalArrowCommand(@NotNull SceneContext sceneContext, int x, int y1, int y2, boolean isReference, @NotNull String text2) {
        this.isReference = isReference;
        this.text = text2;
        this.swingX = sceneContext.getSwingXDip(x);
        this.swingY1 = sceneContext.getSwingYDip(y1);
        this.swingY2 = sceneContext.getSwingYDip(y2);
        if (y1 == y2) {
            this.paintImpl = 1.INSTANCE;
        } else {
            final int[] arrowX = new int[3];
            final int[] arrowY = new int[3];
            int direction = y1 < y2 ? 2 : 3;
            DrawConnectionUtils.getArrow(direction, this.swingX, this.swingY2, arrowX, arrowY);
            this.paintImpl = (Function2)new Function2<Graphics2D, SceneContext, Unit>(){

                public final void invoke(@NotNull Graphics2D g, @NotNull SceneContext context) {
                    Color originalColor = g.getColor();
                    g.setColor(context.getColorSet().getConstraints());
                    DrawConnectionUtils.drawVerticalMargin(g, this.getText(), this.isReference(), swingX, swingY1, swingY2);
                    g.fillPolygon(arrowX, arrowY, 3);
                    g.setColor(originalColor);
                }
            };
        }
    }
}

