/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.relative;

import com.android.tools.idea.uibuilder.model.SegmentType;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ConstraintType
extends Enum<ConstraintType> {
    public static final /* enum */ ConstraintType LAYOUT_ABOVE = new ConstraintType("layout_above", null, SegmentType.BOTTOM, null, SegmentType.TOP, false, true, false, true);
    public static final /* enum */ ConstraintType LAYOUT_BELOW = new ConstraintType("layout_below", null, SegmentType.TOP, null, SegmentType.BOTTOM, false, true, false, true);
    public static final /* enum */ ConstraintType ALIGN_TOP = new ConstraintType("layout_alignTop", null, SegmentType.TOP, null, SegmentType.TOP, false, true, false, false);
    public static final /* enum */ ConstraintType ALIGN_BOTTOM = new ConstraintType("layout_alignBottom", null, SegmentType.BOTTOM, null, SegmentType.BOTTOM, false, true, false, false);
    public static final /* enum */ ConstraintType ALIGN_LEFT = new ConstraintType("layout_alignLeft", SegmentType.LEFT, null, SegmentType.LEFT, null, false, false, true, false);
    public static final /* enum */ ConstraintType ALIGN_RIGHT = new ConstraintType("layout_alignRight", SegmentType.RIGHT, null, SegmentType.RIGHT, null, false, false, true, false);
    public static final /* enum */ ConstraintType LAYOUT_ALIGN_START = new ConstraintType("layout_alignStart", SegmentType.START, null, SegmentType.START, null, false, false, true, false);
    public static final /* enum */ ConstraintType LAYOUT_ALIGN_END = new ConstraintType("layout_alignEnd", SegmentType.END, null, SegmentType.END, null, false, false, true, false);
    public static final /* enum */ ConstraintType LAYOUT_LEFT_OF = new ConstraintType("layout_toLeftOf", SegmentType.RIGHT, null, SegmentType.LEFT, null, false, false, true, true);
    public static final /* enum */ ConstraintType LAYOUT_RIGHT_OF = new ConstraintType("layout_toRightOf", SegmentType.LEFT, null, SegmentType.RIGHT, null, false, false, true, true);
    public static final /* enum */ ConstraintType LAYOUT_ALIGN_START_OF = new ConstraintType("layout_toStartOf", SegmentType.START, null, SegmentType.START, null, false, false, true, false);
    public static final /* enum */ ConstraintType LAYOUT_ALIGN_END_OF = new ConstraintType("layout_toEndOf", SegmentType.END, null, SegmentType.END, null, false, false, true, false);
    public static final /* enum */ ConstraintType ALIGN_PARENT_TOP = new ConstraintType("layout_alignParentTop", null, SegmentType.TOP, null, SegmentType.TOP, true, true, false, false);
    public static final /* enum */ ConstraintType ALIGN_BASELINE = new ConstraintType("layout_alignBaseline", null, SegmentType.BASELINE, null, SegmentType.BASELINE, false, true, false, false);
    public static final /* enum */ ConstraintType ALIGN_PARENT_LEFT = new ConstraintType("layout_alignParentLeft", SegmentType.LEFT, null, SegmentType.LEFT, null, true, false, true, false);
    public static final /* enum */ ConstraintType ALIGN_PARENT_RIGHT = new ConstraintType("layout_alignParentRight", SegmentType.RIGHT, null, SegmentType.RIGHT, null, true, false, true, false);
    public static final /* enum */ ConstraintType ALIGN_PARENT_BOTTOM = new ConstraintType("layout_alignParentBottom", null, SegmentType.BOTTOM, null, SegmentType.BOTTOM, true, true, false, false);
    public static final /* enum */ ConstraintType LAYOUT_CENTER_HORIZONTAL = new ConstraintType("layout_centerHorizontal", SegmentType.CENTER_VERTICAL, null, SegmentType.CENTER_VERTICAL, null, true, true, false, false);
    public static final /* enum */ ConstraintType LAYOUT_CENTER_VERTICAL = new ConstraintType("layout_centerVertical", null, SegmentType.CENTER_HORIZONTAL, null, SegmentType.CENTER_HORIZONTAL, true, false, true, false);
    public static final /* enum */ ConstraintType LAYOUT_CENTER_IN_PARENT = new ConstraintType("layout_centerInParent", SegmentType.CENTER_VERTICAL, SegmentType.CENTER_HORIZONTAL, SegmentType.CENTER_VERTICAL, SegmentType.CENTER_HORIZONTAL, true, true, true, false);
    public final String name;
    public final SegmentType sourceSegmentTypeX;
    public final SegmentType sourceSegmentTypeY;
    public final SegmentType targetSegmentTypeX;
    public final SegmentType targetSegmentTypeY;
    public final boolean targetParent;
    public final boolean horizontalEdge;
    public final boolean verticalEdge;
    public final boolean relativeToMargin;
    private static Map<String, ConstraintType> ourSNameToType;
    private static final /* synthetic */ ConstraintType[] $VALUES;

    public static ConstraintType[] values() {
        return (ConstraintType[])$VALUES.clone();
    }

    public static ConstraintType valueOf(String name) {
        return Enum.valueOf(ConstraintType.class, name);
    }

    private ConstraintType(String name, SegmentType sourceSegmentTypeX, SegmentType sourceSegmentTypeY, SegmentType targetSegmentTypeX, SegmentType targetSegmentTypeY, boolean targetParent, boolean horizontalEdge, boolean verticalEdge, boolean relativeToMargin) {
        assert (horizontalEdge || verticalEdge);
        this.name = name;
        this.sourceSegmentTypeX = sourceSegmentTypeX != null ? sourceSegmentTypeX : SegmentType.UNKNOWN;
        this.sourceSegmentTypeY = sourceSegmentTypeY != null ? sourceSegmentTypeY : SegmentType.UNKNOWN;
        this.targetSegmentTypeX = targetSegmentTypeX != null ? targetSegmentTypeX : SegmentType.UNKNOWN;
        this.targetSegmentTypeY = targetSegmentTypeY != null ? targetSegmentTypeY : SegmentType.UNKNOWN;
        this.targetParent = targetParent;
        this.horizontalEdge = horizontalEdge;
        this.verticalEdge = verticalEdge;
        this.relativeToMargin = relativeToMargin;
    }

    @Nullable
    public static ConstraintType fromAttribute(@NotNull String attribute) {
        if (ourSNameToType == null) {
            ConstraintType[] types2 = ConstraintType.values();
            HashMap<String, ConstraintType> map2 = new HashMap<String, ConstraintType>(types2.length);
            for (ConstraintType type : types2) {
                map2.put(type.name, type);
            }
            ourSNameToType = map2;
        }
        return ourSNameToType.get(attribute);
    }

    public boolean isRelativeToParentEdge() {
        return this == ALIGN_PARENT_LEFT || this == ALIGN_PARENT_RIGHT || this == ALIGN_PARENT_TOP || this == ALIGN_PARENT_BOTTOM;
    }

    @Nullable
    public static ConstraintType forMatch(boolean withParent, SegmentType from, SegmentType to) {
        if (withParent) {
            switch (from) {
                case TOP: {
                    return ALIGN_PARENT_TOP;
                }
                case BOTTOM: {
                    return ALIGN_PARENT_BOTTOM;
                }
                case LEFT: {
                    return ALIGN_PARENT_LEFT;
                }
                case RIGHT: {
                    return ALIGN_PARENT_RIGHT;
                }
                case CENTER_HORIZONTAL: {
                    return LAYOUT_CENTER_VERTICAL;
                }
                case CENTER_VERTICAL: {
                    return LAYOUT_CENTER_HORIZONTAL;
                }
            }
            return null;
        }
        switch (from) {
            case TOP: {
                switch (to) {
                    case TOP: {
                        return ALIGN_TOP;
                    }
                    case BOTTOM: {
                        return LAYOUT_BELOW;
                    }
                    case BASELINE: {
                        return ALIGN_BASELINE;
                    }
                }
                return null;
            }
            case BOTTOM: {
                switch (to) {
                    case TOP: {
                        return LAYOUT_ABOVE;
                    }
                    case BOTTOM: {
                        return ALIGN_BOTTOM;
                    }
                    case BASELINE: {
                        return ALIGN_BASELINE;
                    }
                }
                return null;
            }
            case LEFT: {
                switch (to) {
                    case LEFT: {
                        return ALIGN_LEFT;
                    }
                    case RIGHT: {
                        return LAYOUT_RIGHT_OF;
                    }
                }
                return null;
            }
            case RIGHT: {
                switch (to) {
                    case LEFT: {
                        return LAYOUT_LEFT_OF;
                    }
                    case RIGHT: {
                        return ALIGN_RIGHT;
                    }
                }
                return null;
            }
            case BASELINE: {
                return ALIGN_BASELINE;
            }
            case START: {
                switch (to) {
                    case START: {
                        return LAYOUT_ALIGN_START;
                    }
                    case END: {
                        return LAYOUT_ALIGN_END_OF;
                    }
                }
                return null;
            }
            case END: {
                switch (to) {
                    case START: {
                        return LAYOUT_ALIGN_START_OF;
                    }
                    case END: {
                        return LAYOUT_ALIGN_END;
                    }
                }
                return null;
            }
        }
        return null;
    }

    static {
        $VALUES = new ConstraintType[]{LAYOUT_ABOVE, LAYOUT_BELOW, ALIGN_TOP, ALIGN_BOTTOM, ALIGN_LEFT, ALIGN_RIGHT, LAYOUT_ALIGN_START, LAYOUT_ALIGN_END, LAYOUT_LEFT_OF, LAYOUT_RIGHT_OF, LAYOUT_ALIGN_START_OF, LAYOUT_ALIGN_END_OF, ALIGN_PARENT_TOP, ALIGN_BASELINE, ALIGN_PARENT_LEFT, ALIGN_PARENT_RIGHT, ALIGN_PARENT_BOTTOM, LAYOUT_CENTER_HORIZONTAL, LAYOUT_CENTER_VERTICAL, LAYOUT_CENTER_IN_PARENT};
    }
}

