/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.property2.action;

import com.android.tools.idea.uibuilder.handlers.motion.editor.MotionSceneTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MTag;
import com.android.tools.idea.uibuilder.handlers.motion.property2.MotionLayoutAttributesModel;
import com.android.tools.idea.uibuilder.handlers.motion.property2.MotionSelection;
import com.android.tools.idea.uibuilder.handlers.motion.property2.action.DeleteMotionFieldAction;
import com.android.tools.idea.uibuilder.property2.NelePropertyItem;
import com.android.tools.property.panel.api.TableLineModel;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import icons.StudioIcons;
import org.jetbrains.annotations.NotNull;

public class DeleteCustomFieldAction
extends AnAction {
    private TableLineModel myLineModel;

    public DeleteCustomFieldAction() {
        super(null, "Remove selected attribute", StudioIcons.Common.REMOVE);
        ActionManager manager = ActionManager.getInstance();
        this.setShortcutSet(manager.getAction("$Delete").getShortcutSet());
    }

    public void setLineModel(@NotNull TableLineModel lineModel) {
        this.myLineModel = lineModel;
    }

    public void update(@NotNull AnActionEvent event) {
        boolean enabled = this.myLineModel != null && !this.myLineModel.getTableModel().getItems().isEmpty();
        event.getPresentation().setEnabled(enabled);
        this.getTemplatePresentation().setEnabled(enabled);
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        NelePropertyItem property2 = DeleteMotionFieldAction.getSelectedOrFirstItem(this.myLineModel);
        if (property2 == null) {
            return;
        }
        MotionSelection selection = MotionLayoutAttributesModel.getMotionSelection(property2);
        if (selection == null) {
            return;
        }
        MotionSceneTag tag = selection.getMotionSceneTag();
        if (tag == null) {
            return;
        }
        MTag customTag = MotionLayoutAttributesModel.findCustomTag(tag, property2.getName());
        if (customTag == null) {
            return;
        }
        MTag.TagWriter tagWriter = customTag.getTagWriter();
        tagWriter.deleteTag();
        tagWriter.commit("Delete " + property2.getName());
    }
}

