/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.property2;

import com.android.ide.common.rendering.api.AttributeFormat;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.resources.ResourceType;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.handlers.motion.editor.MotionSceneTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MotionSceneAttrs;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MotionAttributes;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MotionEditorSelector;
import com.android.tools.idea.uibuilder.handlers.motion.property2.MotionIdPropertyItem;
import com.android.tools.idea.uibuilder.handlers.motion.property2.MotionSelection;
import com.android.tools.idea.uibuilder.property2.NeleFlagsPropertyItem;
import com.android.tools.idea.uibuilder.property2.NelePropertiesModel;
import com.android.tools.idea.uibuilder.property2.NelePropertyItem;
import com.android.tools.idea.uibuilder.property2.NelePropertyType;
import com.android.tools.idea.uibuilder.property2.PropertiesProvider;
import com.android.tools.idea.uibuilder.property2.support.TypeResolver;
import com.android.tools.property.panel.api.PropertiesTable;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.impl.source.xml.XmlElementDescriptorProvider;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.NamespaceAwareXmlAttributeDescriptor;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import java.awt.EventQueue;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.android.dom.AndroidDomElementDescriptorProvider;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.dom.attrs.StyleableDefinition;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.FrameworkResourceManager;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MotionLayoutPropertyProvider
implements PropertiesProvider {
    private final AndroidFacet myFacet;
    private final Project myProject;
    private final XmlElementDescriptorProvider myDescriptorProvider;
    private final Table<String, String, NelePropertyItem> myEmptyTable;
    private static final int EXPECTED_ROWS = 3;
    private static final int EXPECTED_CELLS_PER_ROW = 10;
    private static final List<String> INCLUDE_SUB_TAGS_OF = ImmutableList.of((Object)"Constraint", (Object)"Transition");

    public MotionLayoutPropertyProvider(@NotNull AndroidFacet facet2) {
        this.myFacet = facet2;
        this.myProject = facet2.getModule().getProject();
        this.myDescriptorProvider = new AndroidDomElementDescriptorProvider();
        this.myEmptyTable = ImmutableTable.of();
    }

    @Override
    @NotNull
    public PropertiesTable<NelePropertyItem> getProperties(@NotNull NelePropertiesModel model2, @Nullable Object optionalValue, @NotNull List<? extends NlComponent> components) {
        return PropertiesTable.Companion.emptyTable();
    }

    @NotNull
    public Map<String, PropertiesTable<NelePropertyItem>> getAllProperties(@NotNull NelePropertiesModel model2, @NotNull MotionSelection selection) {
        assert (!EventQueue.isDispatchThread() || ApplicationManager.getApplication().isUnitTestMode());
        return (Map)DumbService.getInstance((Project)this.myProject).runReadActionInSmartMode(() -> this.getPropertiesImpl(model2, selection));
    }

    @Override
    @NotNull
    public PropertiesTable<NelePropertyItem> createEmptyTable() {
        return PropertiesTable.Companion.create(HashBasedTable.create((int)3, (int)10));
    }

    private Map<String, PropertiesTable<NelePropertyItem>> getPropertiesImpl(@NotNull NelePropertiesModel model2, @NotNull MotionSelection selection) {
        if (selection.getComponents().isEmpty()) {
            return Collections.emptyMap();
        }
        ModuleResourceManagers resourceManagers = ModuleResourceManagers.getInstance(this.myFacet);
        LocalResourceManager localResourceManager = resourceManagers.getLocalResourceManager();
        FrameworkResourceManager frameworkResourceManager = resourceManagers.getFrameworkResourceManager();
        if (frameworkResourceManager == null) {
            Logger.getInstance(MotionLayoutPropertyProvider.class).error("No system resource manager for module: " + this.myFacet.getModule().getName());
            return Collections.emptyMap();
        }
        AttributeDefinitions localAttrDefs = ((ResourceManager)localResourceManager).getAttributeDefinitions();
        AttributeDefinitions systemAttrDefs = ((ResourceManager)frameworkResourceManager).getAttributeDefinitions();
        if (localAttrDefs == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, PropertiesTable<NelePropertyItem>> allProperties = new LinkedHashMap<String, PropertiesTable<NelePropertyItem>>();
        MotionSceneTag motionSceneTag = selection.getMotionSceneTag();
        XmlTag tag = selection.getXmlTag(motionSceneTag);
        if (motionSceneTag != null && tag != null) {
            XmlElementDescriptor elementDescriptor = this.myDescriptorProvider.getDescriptor(tag);
            if (elementDescriptor == null) {
                return Collections.emptyMap();
            }
            XmlAttributeDescriptor[] descriptors = elementDescriptor.getAttributesDescriptors(tag);
            HashBasedTable properties2 = HashBasedTable.create((int)3, (int)descriptors.length);
            for (XmlAttributeDescriptor descriptor2 : descriptors) {
                String namespaceUri = MotionLayoutPropertyProvider.getNamespace(descriptor2, tag);
                String name = descriptor2.getName();
                AttributeDefinitions attrDefs = "http://schemas.android.com/apk/res/android" == namespaceUri ? systemAttrDefs : localAttrDefs;
                ResourceNamespace namespace = ResourceNamespace.fromNamespaceUri((String)namespaceUri);
                AttributeDefinition attrDef = namespace != null && attrDefs != null ? attrDefs.getAttrDefinition(ResourceReference.attr((ResourceNamespace)namespace, (String)name)) : null;
                NelePropertyItem property2 = MotionLayoutPropertyProvider.createProperty(namespaceUri, name, attrDef, model2, selection, null);
                properties2.put((Object)namespaceUri, (Object)name, (Object)property2);
            }
            allProperties.put(tag.getLocalName(), PropertiesTable.Companion.create(properties2));
            MotionLayoutPropertyProvider.loadCustomAttributes(model2, allProperties, motionSceneTag, selection);
            if (INCLUDE_SUB_TAGS_OF.contains(tag.getLocalName())) {
                XmlElementDescriptor[] subTagDescriptors;
                for (XmlElementDescriptor descriptor3 : subTagDescriptors = elementDescriptor.getElementsDescriptors(tag)) {
                    String subTagName = descriptor3.getName();
                    if (subTagName.equals("CustomAttribute")) continue;
                    Table<String, String, NelePropertyItem> subTagProperties = this.loadFromStyleableName(subTagName, localAttrDefs, model2, selection);
                    allProperties.put(subTagName, PropertiesTable.Companion.create(subTagProperties));
                }
            }
        } else if (selection.getType() == MotionEditorSelector.Type.CONSTRAINT) {
            Table<String, String, NelePropertyItem> constraintProperties = this.loadFromStyleableName("Constraint", localAttrDefs, model2, selection);
            NelePropertyItem id = MotionLayoutPropertyProvider.createProperty("http://schemas.android.com/apk/res/android", "id", null, model2, selection, null);
            constraintProperties.put((Object)id.getNamespace(), (Object)id.getName(), (Object)id);
            allProperties.put("Constraint", PropertiesTable.Companion.create(constraintProperties));
            MotionLayoutPropertyProvider.loadCustomAttributes(model2, allProperties, null, selection);
        }
        return allProperties;
    }

    private static void loadCustomAttributes(@NotNull NelePropertiesModel model2, @NotNull Map<String, PropertiesTable<NelePropertyItem>> allProperties, @Nullable MotionSceneTag motionSceneTag, @NotNull MotionSelection selection) {
        MTag[] customTags = motionSceneTag != null ? motionSceneTag.getChildTags("CustomAttribute") : new MTag[]{};
        List<MotionAttributes.DefinedAttribute> inheritedAttributes = Collections.emptyList();
        MotionAttributes attributes = selection.getMotionAttributes();
        if (attributes != null) {
            inheritedAttributes = attributes.getAttrMap().values().stream().filter(defined -> defined.isCustomAttribute()).collect(Collectors.toList());
        }
        if (customTags.length == 0 && inheritedAttributes.isEmpty()) {
            return;
        }
        HashBasedTable customProperties = HashBasedTable.create((int)3, (int)customTags.length);
        block0: for (MTag customTag : customTags) {
            String name = customTag.getAttributeValue("attributeName");
            if (name == null) continue;
            for (String customType : MotionSceneAttrs.ourCustomAttribute) {
                String customValue = customTag.getAttributeValue(customType);
                if (customValue == null) continue;
                NelePropertyItem item = MotionLayoutPropertyProvider.createCustomProperty(name, customType, selection, model2);
                customProperties.put((Object)item.getNamespace(), (Object)item.getName(), (Object)item);
                continue block0;
            }
        }
        inheritedAttributes.forEach(arg_0 -> MotionLayoutPropertyProvider.lambda$loadCustomAttributes$2(selection, model2, (Table)customProperties, arg_0));
        allProperties.put("CustomAttribute", PropertiesTable.Companion.create(customProperties));
    }

    private Table<String, String, NelePropertyItem> loadFromStyleableName(@NotNull String subTagName, @NotNull AttributeDefinitions attrDefs, @NotNull NelePropertiesModel model2, @NotNull MotionSelection selection) {
        ResourceReference reference2 = new ResourceReference(ResourceNamespace.TODO(), ResourceType.STYLEABLE, subTagName);
        StyleableDefinition styleable = attrDefs.getStyleableDefinition(reference2);
        if (styleable == null) {
            return this.myEmptyTable;
        }
        HashBasedTable properties2 = HashBasedTable.create((int)3, (int)styleable.getAttributes().size());
        styleable.getAttributes().forEach(arg_0 -> MotionLayoutPropertyProvider.lambda$loadFromStyleableName$3(model2, selection, subTagName, (Table)properties2, arg_0));
        return properties2;
    }

    public static NelePropertyItem createCustomProperty(@NotNull String name, @NotNull String customType, @NotNull MotionSelection selection, @NotNull NelePropertiesModel model2) {
        NelePropertyType type = MotionLayoutPropertyProvider.mapFromCustomType(customType);
        List<? extends NlComponent> components = selection.getComponents();
        return new NelePropertyItem("", name, type, null, "", "", model2, components, selection, "CustomAttribute");
    }

    private static NelePropertyItem createProperty(@NotNull String namespace, @NotNull String name, @Nullable AttributeDefinition attr, @NotNull NelePropertiesModel model2, @NotNull MotionSelection selection, @Nullable String subTag) {
        List<? extends NlComponent> components = selection.getComponents();
        NelePropertyType type = TypeResolver.INSTANCE.resolveType(name, attr);
        String libraryName = StringUtil.notNullize((String)(attr != null ? attr.getLibraryName() : null));
        if (namespace.equals("http://schemas.android.com/apk/res/android") && name.equals("id")) {
            return new MotionIdPropertyItem(model2, attr, "", components, selection, subTag);
        }
        if (attr != null && attr.getFormats().contains(AttributeFormat.FLAGS) && attr.getValues().length == 0) {
            return new NeleFlagsPropertyItem(namespace, name, type, attr, "", libraryName, model2, components, selection, subTag);
        }
        return new NelePropertyItem(namespace, name, type, attr, "", libraryName, model2, components, selection, subTag);
    }

    @NotNull
    private static String getNamespace(@NotNull XmlAttributeDescriptor descriptor2, @NotNull XmlTag context) {
        String namespace = null;
        if (descriptor2 instanceof NamespaceAwareXmlAttributeDescriptor) {
            namespace = ((NamespaceAwareXmlAttributeDescriptor)descriptor2).getNamespace(context);
        }
        return namespace != null ? namespace : "http://schemas.android.com/apk/res/android";
    }

    @NotNull
    static NelePropertyType mapFromCustomType(@NotNull String customType) {
        switch (customType) {
            case "customColorValue": {
                return NelePropertyType.COLOR;
            }
            case "customColorDrawableValue": {
                return NelePropertyType.COLOR_STATE_LIST;
            }
            case "customIntegerValue": {
                return NelePropertyType.INTEGER;
            }
            case "customFloatValue": {
                return NelePropertyType.FLOAT;
            }
            case "customDimension": {
                return NelePropertyType.DIMENSION;
            }
            case "customPixelDimension": {
                return NelePropertyType.DIMENSION_PIXEL;
            }
            case "customBoolean": {
                return NelePropertyType.BOOLEAN;
            }
        }
        return NelePropertyType.STRING;
    }

    @NotNull
    static String mapToCustomType(@NotNull NelePropertyType type) {
        switch (type) {
            case COLOR: {
                return "customColorValue";
            }
            case COLOR_STATE_LIST: {
                return "customColorDrawableValue";
            }
            case INTEGER: {
                return "customIntegerValue";
            }
            case FLOAT: {
                return "customFloatValue";
            }
            case DIMENSION: {
                return "customDimension";
            }
            case DIMENSION_PIXEL: {
                return "customPixelDimension";
            }
            case BOOLEAN: {
                return "customBoolean";
            }
        }
        return "customStringValue";
    }

    private static /* synthetic */ void lambda$loadFromStyleableName$3(NelePropertiesModel model2, MotionSelection selection, String subTagName, Table properties2, AttributeDefinition attr) {
        NelePropertyItem property2 = MotionLayoutPropertyProvider.createProperty(attr.getResourceReference().getNamespace().getXmlNamespaceUri(), attr.getName(), attr, model2, selection, subTagName);
        properties2.put((Object)property2.getNamespace(), (Object)property2.getName(), (Object)property2);
    }

    private static /* synthetic */ void lambda$loadCustomAttributes$2(MotionSelection selection, NelePropertiesModel model2, Table customProperties, MotionAttributes.DefinedAttribute defined) {
        NelePropertyItem item = MotionLayoutPropertyProvider.createCustomProperty(defined.getName(), defined.getCustomType(), selection, model2);
        customProperties.put((Object)item.getNamespace(), (Object)item.getName(), (Object)item);
    }
}

