/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.editor.ui;

import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEUI;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MTag;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import javax.swing.Icon;

public class Utils {
    public static final int ICON_LIGHT = 0;
    public static final int ICON_LIGHT_SELECTED = 1;
    public static final int ICON_SELECTED = 2;

    public static String stripID(String id) {
        if (id == null) {
            return "";
        }
        int index2 = id.indexOf(47);
        if (index2 < 0) {
            return id;
        }
        return id.substring(index2 + 1).trim();
    }

    public static String formatTransition(MTag tag) {
        String id = Utils.stripID(tag.getAttributeValue("id"));
        String start2 = Utils.stripID(tag.getAttributeValue("constraintSetStart"));
        String end = Utils.stripID(tag.getAttributeValue("constraintSetEnd"));
        return Utils.formatTransition(id, start2, end);
    }

    public static String formatTransition(String id, String start2, String end) {
        if (id == null || id.length() == 0) {
            return start2 + "->" + end;
        }
        return id;
    }

    public static Icon computeLiteIcon(int mode, Icon icon2) {
        int w = icon2.getIconWidth();
        int h = icon2.getIconHeight();
        BufferedImage image = MEUI.createImage(w, h, 2);
        Graphics2D g2d = image.createGraphics();
        icon2.paintIcon(null, g2d, 0, 0);
        int[] data = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        switch (mode) {
            case 0: {
                for (int i2 = 0; i2 < data.length; ++i2) {
                    int v = data[i2] & 0xFF;
                    int a = data[i2] >> 24 & 0xFF;
                    data[i2] = (a /= 3) << 24 | v * 65793;
                }
                break;
            }
            case 1: {
                for (int i3 = 0; i3 < data.length; ++i3) {
                    int a = data[i3] >> 24 & 0xFF;
                    int v = 255;
                    data[i3] = (a /= 3) << 24 | v * 65793;
                }
                break;
            }
            case 2: {
                for (int i4 = 0; i4 < data.length; ++i4) {
                    int a = data[i4] >> 24 & 0xFF;
                    int v = 255;
                    data[i4] = a << 24 | v * 65793;
                }
                break;
            }
        }
        return MEUI.generateImageIcon(image);
    }
}

